/*
 * Decompiled with CFR 0.152.
 */
package com.ucloudlink.css.elasticsearch.transport;

import com.carrotsearch.hppc.cursors.ObjectCursor;
import com.ucloudlink.css.elasticsearch.AbstractElasticsearchFactory;
import com.ucloudlink.css.util.StringUtil;
import java.net.InetAddress;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequestBuilder;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsResponse;
import org.elasticsearch.action.admin.indices.exists.types.TypesExistsResponse;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequestBuilder;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingResponse;
import org.elasticsearch.action.admin.indices.settings.get.GetSettingsResponse;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.fastjson.JSON;
import org.elasticsearch.fastjson.JSONObject;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.log4j.LogManager;
import org.elasticsearch.log4j.Logger;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightBuilder;
import org.elasticsearch.transport.client.PreBuiltTransportClient;
import org.elasticsearch.xpack.client.PreBuiltXPackTransportClient;

public class ElasticsearchTransportFactory
extends AbstractElasticsearchFactory {
    private static Logger logger = LogManager.getLogger();
    protected PreBuiltTransportClient client = null;
    private static int DEFAULT_PORT = 9300;

    @Override
    public int defaultPort() {
        return DEFAULT_PORT;
    }

    public ElasticsearchTransportFactory() {
    }

    public ElasticsearchTransportFactory(String servers) {
        super(servers);
    }

    public ElasticsearchTransportFactory(String servers, int port) {
        super(servers, port);
    }

    public ElasticsearchTransportFactory(String clusterName, String servers, int port) {
        super(clusterName, servers, port);
    }

    public ElasticsearchTransportFactory(String clusterName, String servers, String username, String password) {
        super(clusterName, servers, username, password);
    }

    public ElasticsearchTransportFactory(String clusterName, String servers, String username, String password, int port) {
        super(clusterName, servers, username, password, port);
    }

    public void init() {
        try {
            Settings settings;
            Settings.Builder builder = Settings.builder();
            builder.put("cluster.name", this.clusterName);
            builder.put("client.transport.sniff", true);
            if (!StringUtil.isEmpty(this.username) && !StringUtil.isEmpty(this.password)) {
                builder.put("xpack.security.user", this.username + ":" + this.password);
                settings = builder.build();
                this.client = new PreBuiltXPackTransportClient(settings, new Class[0]);
            } else {
                settings = builder.build();
                this.client = new PreBuiltTransportClient(settings, new Class[0]);
            }
            for (String server : this.servers.split(",")) {
                String[] address = server.split(":");
                String ip = address[0];
                int _port = this.port;
                if (address.length > 1) {
                    _port = Integer.valueOf(address[1]);
                }
                this.client.addTransportAddress(new InetSocketTransportAddress(InetAddress.getByName(ip), _port));
            }
        }
        catch (Exception e) {
            logger.error("-----Elasticsearch Config init Error-----", (Throwable)e);
        }
    }

    public void close() {
        if (this.client != null) {
            this.client.close();
        }
    }

    public PreBuiltTransportClient getClient() {
        return this.client;
    }

    @Override
    public String mapping(String index, String type, Class clazz) {
        TypesExistsResponse tresponse;
        boolean isCustom = true;
        IndicesExistsResponse response = (IndicesExistsResponse)this.client.admin().indices().prepareExists(index).get();
        if (response != null && !response.isExists()) {
            String body = "{properties:" + JSON.toJSONString(this.reflect(clazz, isCustom)) + "}";
            CreateIndexRequestBuilder builder = this.client.admin().indices().prepareCreate(index);
            builder.addMapping(type, JSON.parseObject(body).toJSONString(), XContentType.JSON);
            builder.setSource(JSON.parseObject("{settings:" + this.analyzer(index) + "}").toJSONString(), XContentType.JSON);
            PutMappingResponse putMappingResponse = (PutMappingResponse)this.client.admin().indices().preparePutMapping(index).setType(type).setSource(JSON.parseObject(body).toJSONString(), XContentType.JSON).get();
            return putMappingResponse.toString();
        }
        GetSettingsResponse sresponse = (GetSettingsResponse)this.client.admin().indices().prepareGetSettings(index).get();
        if (sresponse != null && !sresponse.getIndexToSettings().isEmpty()) {
            for (ObjectCursor<Settings> objectCursor : sresponse.getIndexToSettings().values()) {
                Settings setting = (Settings)objectCursor.value;
                if (setting == null || !setting.getByPrefix("index.analysis.analyzer.es_analyzer").isEmpty()) continue;
                isCustom = false;
            }
        }
        if ((tresponse = (TypesExistsResponse)this.client.admin().indices().prepareTypesExists(index).setTypes(type).get()) != null && !tresponse.isExists()) {
            String string = "{properties:" + JSON.toJSONString(this.reflect(clazz, isCustom)) + "}";
            PutMappingRequestBuilder builder = this.client.admin().indices().preparePutMapping(index);
            builder.setType(type);
            builder.setSource(JSON.parseObject(string).toJSONString(), XContentType.JSON);
            PutMappingResponse _response = (PutMappingResponse)builder.get();
            return _response.toString();
        }
        return null;
    }

    @Override
    public String insert(String index, String type, String json) {
        try {
            IndexResponse response;
            if (this.client == null) {
                this.init();
            }
            if ((response = (IndexResponse)this.client.prepareIndex(index, type).setSource(json, XContentType.JSON).execute().actionGet()).getResult().equals(DocWriteResponse.Result.CREATED)) {
                System.out.println(JSON.toJSONString(response));
            }
            return response.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String update(String index, String type, String id, String json) {
        try {
            if (this.client == null) {
                this.init();
            }
            UpdateResponse result = (UpdateResponse)this.client.prepareUpdate(index, type, id).setDoc(json, XContentType.JSON).execute().actionGet();
            System.out.println(JSON.toJSONString(result));
            return result.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String upsert(String index, String type, String id, String json) {
        try {
            if (this.client == null) {
                this.init();
            }
            IndexRequest indexRequest = new IndexRequest(index, type, id).source(json, XContentType.JSON);
            UpdateRequest updateRequest = new UpdateRequest(index, type, id).doc(json, XContentType.JSON).upsert(indexRequest);
            UpdateResponse result = (UpdateResponse)this.client.update(updateRequest).get();
            return result.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String delete(String index, String type, String id) {
        try {
            if (this.client == null) {
                this.init();
            }
            DeleteResponse result = (DeleteResponse)this.client.prepareDelete(index, type, id).execute().actionGet();
            System.out.println(JSON.toJSONString(result));
            return result.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String bulkUpsert(String index, String type, List<String> jsons) {
        try {
            if (this.client == null) {
                this.init();
            }
            BulkRequestBuilder bulkRequest = this.client.prepareBulk();
            for (String json : jsons) {
                JSONObject obj = JSON.parseObject(json);
                String id = UUIDs.base64UUID();
                if (obj.containsKey("id")) {
                    id = obj.getString("id");
                    obj.remove("id");
                    bulkRequest.add(this.client.prepareUpdate(index, type, id).setDoc(obj.toJSONString(), XContentType.JSON));
                    continue;
                }
                bulkRequest.add(this.client.prepareIndex(index, type, id).setSource(obj.toJSONString(), XContentType.JSON));
            }
            BulkResponse result = (BulkResponse)bulkRequest.execute().get();
            return result.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String bulkDelete(String index, String type, String ... ids) {
        try {
            if (this.client == null) {
                this.init();
            }
            BulkRequestBuilder bulkRequest = this.client.prepareBulk();
            for (String id : ids) {
                bulkRequest.add(this.client.prepareDelete(index, type, id));
            }
            BulkResponse result = (BulkResponse)bulkRequest.execute().get();
            return result.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String drop(String indexs) {
        return null;
    }

    @Override
    public String select(String index, String type, String id) {
        try {
            if (this.client == null) {
                this.init();
            }
            GetResponse result = (GetResponse)this.client.prepareGet(index, type, id).execute().actionGet();
            return result.getSourceAsString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String selectAll(String indexs, String types, String condition) {
        try {
            if (this.client == null) {
                this.init();
            }
            SearchResponse response = (SearchResponse)this.client.prepareSearch(indexs.split(",")).setTypes(types.split(",")).setSearchType(SearchType.DFS_QUERY_THEN_FETCH).setQuery(QueryBuilders.queryStringQuery(condition)).setFrom(0).setSize(60).setExplain(true).get();
            return response.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String selectMatchAll(String indexs, String types, String field, String value) {
        try {
            if (this.client == null) {
                this.init();
            }
            SearchResponse response = (SearchResponse)this.client.prepareSearch(indexs.split(",")).setTypes(types.split(",")).setSearchType(SearchType.DFS_QUERY_THEN_FETCH).setQuery(QueryBuilders.matchQuery(field, value)).highlighter(new HighlightBuilder().field(field)).addAggregation((AggregationBuilder)AggregationBuilders.terms("data").field(field + ".keyword")).setFrom(0).setSize(60).setExplain(true).get();
            return response.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String selectMatchAll(String indexs, String types, Map<String, String> must, Map<String, String> should, Map<String, String> must_not) {
        try {
            List<String> values;
            String value;
            if (this.client == null) {
                this.init();
            }
            BoolQueryBuilder boolquery = QueryBuilders.boolQuery();
            HighlightBuilder highlight = new HighlightBuilder();
            if (must != null && must.size() > 0) {
                for (String field : must.keySet()) {
                    if (field.matches(regex)) continue;
                    value = must.get(field);
                    if (!StringUtil.isEmpty(field) && !StringUtil.isEmpty(value)) {
                        if (value.startsWith("[") && value.endsWith("]")) {
                            values = JSON.parseArray(value, String.class);
                            for (String _value : values) {
                                if (_value.matches(regex)) continue;
                                boolquery.should(QueryBuilders.matchQuery(field, value));
                            }
                        } else if (!value.matches(regex)) {
                            boolquery.must(QueryBuilders.matchQuery(field, value));
                        }
                    }
                    highlight.field(field);
                }
            }
            if (should != null && should.size() > 0) {
                for (String field : should.keySet()) {
                    if (field.matches(regex)) continue;
                    value = should.get(field);
                    if (!StringUtil.isEmpty(field) && !StringUtil.isEmpty(value)) {
                        if (value.startsWith("[") && value.endsWith("]")) {
                            values = JSON.parseArray(value, String.class);
                            for (String _value : values) {
                                if (_value.matches(regex)) continue;
                                boolquery.should(QueryBuilders.matchQuery(field, value));
                            }
                        } else if (!value.matches(regex)) {
                            boolquery.should(QueryBuilders.matchQuery(field, value));
                        }
                    }
                    highlight.field(field);
                }
            }
            if (must_not != null && must_not.size() > 0) {
                for (String field : must_not.keySet()) {
                    if (field.matches(regex)) continue;
                    value = must_not.get(field);
                    if (!StringUtil.isEmpty(field) && !StringUtil.isEmpty(value)) {
                        if (value.startsWith("[") && value.endsWith("]")) {
                            values = JSON.parseArray(value, String.class);
                            for (String _value : values) {
                                if (_value.matches(regex)) continue;
                                boolquery.mustNot(QueryBuilders.matchQuery(field, value));
                            }
                        } else if (!value.matches(regex)) {
                            boolquery.mustNot(QueryBuilders.matchQuery(field, value));
                        }
                    }
                    highlight.field(field);
                }
            }
            SearchResponse response = (SearchResponse)this.client.prepareSearch(indexs.split(",")).setTypes(types.split(",")).setSearchType(SearchType.DFS_QUERY_THEN_FETCH).setQuery(boolquery).highlighter(highlight).setExplain(true).get();
            return response.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

