/*
 * Decompiled with CFR 0.152.
 */
package com.ucloudlink.css.elasticsearch.http;

import com.ucloudlink.css.elasticsearch.AbstractElasticsearchFactory;
import com.ucloudlink.css.util.HttpUtil;
import com.ucloudlink.css.util.StringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.fastjson.JSON;
import org.elasticsearch.fastjson.JSONObject;
import org.elasticsearch.log4j.LogManager;
import org.elasticsearch.log4j.Logger;

public class ElasticsearchHttpFactory
extends AbstractElasticsearchFactory {
    private static Logger logger = LogManager.getLogger();
    private static String auth = null;
    private static String api = "http://localhost:9200";
    private static int DEFAULT_PORT = 9200;

    @Override
    public int defaultPort() {
        return DEFAULT_PORT;
    }

    public ElasticsearchHttpFactory() {
    }

    public ElasticsearchHttpFactory(String servers) {
        super(servers);
    }

    public ElasticsearchHttpFactory(String servers, int port) {
        super(servers, port);
    }

    public ElasticsearchHttpFactory(String clusterName, String servers, int port) {
        super(clusterName, servers, port);
    }

    public ElasticsearchHttpFactory(String clusterName, String servers, String username, String password) {
        super(clusterName, servers, username, password);
    }

    public ElasticsearchHttpFactory(String clusterName, String servers, String username, String password, int port) {
        super(clusterName, servers, username, password, port);
    }

    public void init() {
        try {
            if (!StringUtil.isEmpty(this.username) && !StringUtil.isEmpty(this.password)) {
                auth = this.username + ":" + this.password;
            }
            for (String server : this.servers.split(",")) {
                boolean flag;
                String[] address = server.split(":");
                String ip = address[0];
                int _port = this.port;
                if (address.length > 1) {
                    _port = Integer.valueOf(address[1]);
                }
                if (flag = HttpUtil.checkConnection(api = "http://" + ip + ":" + _port, auth)) {
                    logger.info("--------------Elasticsearch[" + api + "] connect success-------------");
                    break;
                }
                logger.warn("--------------Elasticsearch[" + api + "] connect error-------------");
            }
        }
        catch (Exception e) {
            logger.error("-----Elasticsearch Config init Error-----", (Throwable)e);
        }
    }

    public String base(String uri, String method, String body) {
        try {
            String result;
            String url = uri;
            if (uri != null && !uri.startsWith("http://") && !uri.startsWith("https://")) {
                url = api + (uri.startsWith("/") ? "" : "/") + uri;
            }
            if (body != null) {
                String string = body = url.contains("_bulk") ? body : JSON.parseObject(body).toJSONString();
            }
            if ((result = HttpUtil.urlRequest(url, method, body, auth)) != null && result.contains("Connection refused")) {
                this.init();
            }
            return result;
        }
        catch (Exception e) {
            logger.error("----Elasticsearch RESTFull[http api] \u8bbf\u95ee\u5931\u8d25!------------", (Throwable)e);
            return null;
        }
    }

    public String indices() {
        String[] data;
        String uri = "/_cat/indices?v";
        String result = this.base(uri, "GET", null);
        if (!StringUtil.isEmpty(result) && (data = result.split("\n")) != null && data.length > 1) {
            ArrayList<JSONObject> list = new ArrayList<JSONObject>();
            String[] header = data[0].split("(\\s+)");
            for (int i = 1; i < data.length; ++i) {
                String[] values = data[i].split("(\\s+)");
                JSONObject json = new JSONObject();
                for (int j = 0; j < values.length; ++j) {
                    json.put(header[j], (Object)values[j]);
                }
                list.add(json);
            }
            if (list != null && list.size() == 1) {
                return ((JSONObject)list.get(0)).toJSONString();
            }
            return JSON.toJSONString(list);
        }
        return result;
    }

    public String nodes() {
        String[] data;
        String uri = "/_cat/nodes?v";
        String result = this.base(uri, "GET", null);
        if (!StringUtil.isEmpty(result) && (data = result.split("\n")) != null && data.length > 1) {
            ArrayList<JSONObject> list = new ArrayList<JSONObject>();
            String[] header = data[0].split("(\\s+)");
            for (int i = 1; i < data.length; ++i) {
                String[] values = data[i].split("(\\s+)");
                JSONObject json = new JSONObject();
                for (int j = 0; j < values.length; ++j) {
                    json.put(header[j], (Object)values[j]);
                }
                list.add(json);
            }
            if (list != null && list.size() == 1) {
                return ((JSONObject)list.get(0)).toJSONString();
            }
            return JSON.toJSONString(list);
        }
        return result;
    }

    @Override
    public String mapping(String index, String type, Class clazz) {
        boolean isCustom = true;
        String uri = "/" + index;
        String result = this.base(uri, "GET", null);
        JSONObject target = JSON.parseObject(result);
        if (target != null && target.getIntValue("status") == 404) {
            String body = "{mappings:{" + type + ":{properties:" + JSON.toJSONString(this.reflect(clazz, isCustom)) + "}},settings:" + this.analyzer(index).toJSONString() + "}";
            result = this.base(uri, "PUT", JSON.parseObject(body).toJSONString());
        } else {
            if (target == null || !target.getJSONObject(index).getJSONObject("settings").getJSONObject("index").containsKey("analysis") || !target.getJSONObject(index).getJSONObject("settings").getJSONObject("index").getJSONObject("analysis").getJSONObject("analyzer").containsKey("es_analyzer")) {
                isCustom = false;
            }
            if (target == null || !target.getJSONObject(index).getJSONObject("mappings").containsKey(type)) {
                String body = "{properties:" + JSON.toJSONString(this.reflect(clazz, isCustom)) + "}";
                result = this.base(uri + "/_mapping/" + type, "PUT", JSON.parseObject(body).toJSONString());
            }
        }
        return result;
    }

    @Override
    public String insert(String index, String type, String json) {
        String uri = "/" + index + "/" + type;
        JSONObject body = JSON.parseObject(json);
        String result = this.base(uri, "POST", body.toJSONString());
        return result;
    }

    @Override
    public String update(String index, String type, String id, String json) {
        String uri = "/" + index + "/" + type + "/" + id;
        String result = this.base(uri, "GET", null);
        JSONObject target = JSON.parseObject(result);
        if (target.getBooleanValue("found")) {
            JSONObject body = JSON.parseObject(json);
            result = this.base(uri, "PUT", body.toJSONString());
        }
        return result;
    }

    @Override
    public String upsert(String index, String type, String id, String json) {
        String uri = "/" + index + "/" + type + "/" + id;
        JSONObject body = JSON.parseObject(json);
        String result = this.base(uri, "PUT", body.toJSONString());
        return result;
    }

    @Override
    public String delete(String index, String type, String id) {
        String uri = "/" + index + "/" + type + "/" + id;
        String result = this.base(uri, "DELETE", null);
        return result;
    }

    @Override
    public String bulkUpsert(String index, String type, List<String> jsons) {
        String uri = "/_bulk";
        String body = "";
        for (String json : jsons) {
            String action;
            JSONObject obj = JSON.parseObject(json);
            String id = null;
            if (obj.containsKey("id") || obj.containsKey("_id")) {
                if (obj.containsKey("_id")) {
                    id = obj.getString("_id");
                    obj.remove("_id");
                } else {
                    id = obj.getString("id");
                    obj.remove("id");
                }
            }
            if (!StringUtil.isEmpty(id)) {
                action = "{update:{_index:'" + index + "',_type:'" + type + "',_id:'" + id + "'}}";
                String _body = "{doc:" + obj.toJSONString() + "}";
                body = body + JSON.parseObject(action).toJSONString() + "\n" + JSON.parseObject(_body).toJSONString() + "\n";
                continue;
            }
            id = UUIDs.base64UUID();
            action = "{create:{_index:'" + index + "',_type:'" + type + "',_id:'" + id + "'}}";
            body = body + JSON.parseObject(action).toJSONString() + "\n" + obj.toJSONString() + "\n";
        }
        String result = this.base(uri, "POST", body);
        return result;
    }

    @Override
    public String bulkDelete(String index, String type, String ... ids) {
        String uri = "/_bulk";
        String body = "";
        for (String id : ids) {
            String action = "{delete:{_index:'" + index + "',_type:'" + type + "',_id:'" + id + "'}}";
            body = body + JSON.parseObject(action).toJSONString() + "\n";
        }
        String result = this.base(uri, "POST", body);
        return result;
    }

    @Override
    public String drop(String indexs) {
        String uri = "/" + indexs;
        String result = this.base(uri, "DELETE", null);
        return result;
    }

    @Override
    public String select(String index, String type, String id) {
        String uri = "/" + index + "/" + type + "/" + id;
        String result = this.base(uri, "GET", null);
        return result;
    }

    @Override
    public String selectAll(String indexs, String types, String condition) {
        if (StringUtil.isEmpty(indexs)) {
            indexs = "_all";
        }
        String uri = "/" + indexs + (StringUtil.isEmpty(types) ? "" : "/" + types) + "/_search?pretty";
        if (!StringUtil.isEmpty(condition)) {
            uri = uri + "&q=" + HttpUtil.encode(condition);
        }
        String result = this.base(uri, "GET", null);
        return result;
    }

    @Override
    public String selectMatchAll(String indexs, String types, String field, String value) {
        if (StringUtil.isEmpty(indexs)) {
            indexs = "_all";
        }
        String uri = "/" + indexs + (StringUtil.isEmpty(types) ? "" : "/" + types) + "/_search?pretty";
        String body = "";
        if (!(StringUtil.isEmpty(field) || StringUtil.isEmpty(value) || field.matches(regex) || field.matches(value))) {
            String query = "{query:{match:{" + field + ":'" + value + "'}}}";
            body = JSON.parseObject(query).toJSONString();
        }
        String result = this.base(uri, "POST", body);
        return result;
    }

    @Override
    public String selectMatchAll(String indexs, String types, Map<String, String> must, Map<String, String> should, Map<String, String> must_not) {
        String match;
        String match2;
        List<String> values;
        String value;
        if (StringUtil.isEmpty(indexs)) {
            indexs = "_all";
        }
        String uri = "/" + indexs + (StringUtil.isEmpty(types) ? "" : "/" + types) + "/_search?pretty";
        ArrayList<JSONObject> must_matchs = new ArrayList<JSONObject>();
        ArrayList<JSONObject> should_matchs = new ArrayList<JSONObject>();
        ArrayList<JSONObject> must_not_matchs = new ArrayList<JSONObject>();
        if (must != null && must.size() > 0) {
            for (String field : must.keySet()) {
                if (field.matches(regex)) continue;
                value = must.get(field);
                if (StringUtil.isEmpty(field) || StringUtil.isEmpty(value)) continue;
                if (value.startsWith("[") && value.endsWith("]")) {
                    values = JSON.parseArray(value, String.class);
                    for (String _value : values) {
                        if (_value.matches(regex)) continue;
                        match2 = "{match:{" + field + ":'" + _value + "'}}";
                        should_matchs.add(JSON.parseObject(match2));
                    }
                    continue;
                }
                if (value.matches(regex)) continue;
                match = "{match:{" + field + ":'" + value + "'}}";
                must_matchs.add(JSON.parseObject(match));
            }
        }
        if (should != null && should.size() > 0) {
            for (String field : should.keySet()) {
                if (field.matches(regex)) continue;
                value = should.get(field);
                if (StringUtil.isEmpty(field) || StringUtil.isEmpty(value)) continue;
                if (value.startsWith("[") && value.endsWith("]")) {
                    values = JSON.parseArray(value, String.class);
                    for (String _value : values) {
                        if (_value.matches(regex)) continue;
                        match2 = "{match:{" + field + ":'" + _value + "'}}";
                        should_matchs.add(JSON.parseObject(match2));
                    }
                    continue;
                }
                if (value.matches(regex)) continue;
                match = "{match:{" + field + ":'" + value + "'}}";
                should_matchs.add(JSON.parseObject(match));
            }
        }
        if (must_not != null && must_not.size() > 0) {
            for (String field : must_not.keySet()) {
                if (field.matches(regex)) continue;
                value = must_not.get(field);
                if (StringUtil.isEmpty(field) || StringUtil.isEmpty(value)) continue;
                if (value.startsWith("[") && value.endsWith("]")) {
                    values = JSON.parseArray(value, String.class);
                    for (String _value : values) {
                        if (_value.matches(regex)) continue;
                        match2 = "{match:{" + field + ":'" + _value + "'}}";
                        must_not_matchs.add(JSON.parseObject(match2));
                    }
                    continue;
                }
                if (value.matches(regex)) continue;
                match = "{match:{" + field + ":'" + value + "'}}";
                must_not_matchs.add(JSON.parseObject(match));
            }
        }
        String query = "{query:{bool:{must:" + JSON.toJSONString(must_matchs) + ",must_not:" + JSON.toJSONString(must_not_matchs) + ",should:" + JSON.toJSONString(should_matchs) + "}}}";
        String body = JSON.parseObject(query).toJSONString();
        String result = this.base(uri, "POST", body);
        return result;
    }
}

