/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.stats.exp;

import com.twitter.finagle.stats.HistogramFormatter$;
import com.twitter.finagle.stats.MetricUnit;
import com.twitter.finagle.stats.Unspecified$;
import com.twitter.finagle.stats.exp.Bounds;
import com.twitter.finagle.stats.exp.Expression;
import com.twitter.finagle.stats.exp.ExpressionSchema;
import com.twitter.finagle.stats.exp.ExpressionSchema$ExpressionCollisionException$;
import com.twitter.finagle.stats.exp.HistogramComponent;
import com.twitter.finagle.stats.exp.HistogramComponent$Avg$;
import com.twitter.finagle.stats.exp.HistogramComponent$Count$;
import com.twitter.finagle.stats.exp.HistogramComponent$Max$;
import com.twitter.finagle.stats.exp.HistogramComponent$Min$;
import com.twitter.finagle.stats.exp.HistogramComponent$Percentile$;
import com.twitter.finagle.stats.exp.HistogramComponent$Sum$;
import com.twitter.finagle.stats.exp.HistogramExpression;
import com.twitter.finagle.stats.exp.Unbounded;
import com.twitter.finagle.stats.exp.Unbounded$;
import java.io.Serializable;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.deriving.Mirror;
import scala.package$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

public final class ExpressionSchema$
implements Mirror.Product,
Serializable {
    public static final ExpressionSchema$ExpressionCollisionException$ ExpressionCollisionException;
    private static final String Role;
    private static final String ServiceName;
    private static final String ProcessPath;
    public static final ExpressionSchema$ MODULE$;

    private ExpressionSchema$() {
    }

    static {
        MODULE$ = new ExpressionSchema$();
        Role = "role";
        ServiceName = "service_name";
        ProcessPath = "process_path";
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ExpressionSchema$.class);
    }

    private ExpressionSchema apply(String name, Map<String, String> labels, Expression expr, Seq<String> namespace, Bounds bounds, String description, MetricUnit unit, String exprQuery) {
        return new ExpressionSchema(name, labels, expr, namespace, bounds, description, unit, exprQuery);
    }

    public ExpressionSchema unapply(ExpressionSchema x$1) {
        return x$1;
    }

    public String toString() {
        return "ExpressionSchema";
    }

    public String Role() {
        return Role;
    }

    public String ServiceName() {
        return ServiceName;
    }

    public String ProcessPath() {
        return ProcessPath;
    }

    public ExpressionSchema apply(String name, Expression expr) {
        Map<String, String> map;
        Expression expression = expr;
        if (expression instanceof HistogramExpression) {
            HistogramExpression histoExpr = (HistogramExpression)expression;
            map = this.histogramLabel(histoExpr);
        } else {
            map = Predef$.MODULE$.Map().empty();
        }
        Map<String, String> preLabels = map;
        Seq seq = (Seq)package$.MODULE$.Seq().empty();
        Unbounded unbounded = Unbounded$.MODULE$.get();
        return this.apply(name, preLabels, expr, (Seq<String>)seq, unbounded, "Unspecified", Unspecified$.MODULE$, "");
    }

    private Map<String, String> histogramLabel(HistogramExpression histoExpr) {
        String string;
        HistogramComponent histogramComponent = histoExpr.component();
        if (histogramComponent instanceof HistogramComponent.Percentile) {
            double d;
            HistogramComponent.Percentile percentile = HistogramComponent$Percentile$.MODULE$.unapply((HistogramComponent.Percentile)histogramComponent);
            double percentile2 = d = percentile._1();
            string = HistogramFormatter$.MODULE$.labelPercentile(percentile2);
        } else if (HistogramComponent$Min$.MODULE$.equals(histogramComponent)) {
            string = HistogramFormatter$.MODULE$.labelMin();
        } else if (HistogramComponent$Max$.MODULE$.equals(histogramComponent)) {
            string = HistogramFormatter$.MODULE$.labelMax();
        } else if (HistogramComponent$Avg$.MODULE$.equals(histogramComponent)) {
            string = HistogramFormatter$.MODULE$.labelAverage();
        } else if (HistogramComponent$Sum$.MODULE$.equals(histogramComponent)) {
            string = HistogramFormatter$.MODULE$.labelSum();
        } else if (HistogramComponent$Count$.MODULE$.equals(histogramComponent)) {
            string = HistogramFormatter$.MODULE$.labelCount();
        } else {
            throw new MatchError((Object)histogramComponent);
        }
        String value = string;
        Object[] objectArray = new Tuple2[1];
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"bucket");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)value);
        return (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
    }

    public ExpressionSchema fromProduct(Product x$0) {
        return new ExpressionSchema((String)x$0.productElement(0), (Map<String, String>)((Map)x$0.productElement(1)), (Expression)x$0.productElement(2), (Seq<String>)((Seq)x$0.productElement(3)), (Bounds)x$0.productElement(4), (String)x$0.productElement(5), (MetricUnit)x$0.productElement(6), (String)x$0.productElement(7));
    }
}

