/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.stats;

import com.twitter.finagle.stats.CumulativeGauge;
import com.twitter.finagle.stats.Gauge;
import com.twitter.finagle.stats.StatsReceiverWithCumulativeGauges;
import com.twitter.finagle.stats.StatsReceiverWithCumulativeGauges$;
import com.twitter.finagle.stats.StatsReceiverWithCumulativeGauges$$anon$2$;
import com.twitter.finagle.stats.Verbosity;
import com.twitter.finagle.stats.Verbosity$;
import com.twitter.util.lint.Category;
import com.twitter.util.lint.Issue;
import com.twitter.util.lint.Rule;
import com.twitter.util.lint.Rule$;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.StampedLock;
import java.util.function.Function;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Iterable$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

public abstract class StatsReceiverWithCumulativeGauges$class {
    public static Rule largeGaugeLinterRule(StatsReceiverWithCumulativeGauges $this) {
        return Rule$.MODULE$.apply((Category)Category.Performance$.MODULE$, "Large CumulativeGauges", new StringBuilder().append((Object)"Identifies CumulativeGauges which are backed by very large numbers (10k+) of Gauges. Indicative of a leak or code registering the same gauge more ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"often than expected. (For ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.toString()}))).toString(), (Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StatsReceiverWithCumulativeGauges $outer;

            public final Seq<Issue> apply() {
                Map largeCgs = (Map)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter((ConcurrentMap)this.$outer.com$twitter$finagle$stats$StatsReceiverWithCumulativeGauges$$gauges()).asScala()).flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Iterable<Tuple2<Seq<String>, Object>> apply(Tuple2<Seq<String>, CumulativeGauge> x0$1) {
                        Tuple2<Seq<String>, CumulativeGauge> tuple2 = x0$1;
                        if (tuple2 != null) {
                            Seq ks = (Seq)tuple2._1();
                            CumulativeGauge cg = (CumulativeGauge)tuple2._2();
                            Iterable iterable = cg.totalSize() >= 10000 ? Option$.MODULE$.option2Iterable((Option)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ks), (Object)BoxesRunTime.boxToInteger((int)cg.totalSize())))) : Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                            return iterable;
                        }
                        throw new MatchError(tuple2);
                    }
                }, Map$.MODULE$.canBuildFrom());
                return largeCgs.isEmpty() ? Nil$.MODULE$ : ((TraversableOnce)largeCgs.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Issue apply(Tuple2<Seq<String>, Object> x0$2) {
                        Tuple2<Seq<String>, Object> tuple2 = x0$2;
                        if (tuple2 != null) {
                            Seq ks = (Seq)tuple2._1();
                            int size = tuple2._2$mcI$sp();
                            Issue issue = new Issue(new StringBuilder().append((Object)ks.mkString("/")).append((Object)"=").append((Object)BoxesRunTime.boxToInteger((int)size)).toString());
                            return issue;
                        }
                        throw new MatchError(tuple2);
                    }
                }, Iterable$.MODULE$.canBuildFrom())).toSeq();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public static Function com$twitter$finagle$stats$StatsReceiverWithCumulativeGauges$$getWhenNotPresent(StatsReceiverWithCumulativeGauges $this, Verbosity verbosity) {
        Function function;
        Verbosity verbosity2 = verbosity;
        Verbosity verbosity3 = Verbosity$.MODULE$.Default();
        Verbosity verbosity4 = verbosity2;
        if (!(verbosity3 != null ? !verbosity3.equals(verbosity4) : verbosity4 != null)) {
            function = $this.com$twitter$finagle$stats$StatsReceiverWithCumulativeGauges$$whenDefaultNotPresent();
        } else {
            Verbosity verbosity5 = Verbosity$.MODULE$.Debug();
            Verbosity verbosity6 = verbosity2;
            function = !(verbosity5 != null ? !verbosity5.equals(verbosity6) : verbosity6 != null) ? $this.com$twitter$finagle$stats$StatsReceiverWithCumulativeGauges$$whenDebugNotPresent() : StatsReceiverWithCumulativeGauges$class.com$twitter$finagle$stats$StatsReceiverWithCumulativeGauges$$whenNotPresent($this, verbosity);
        }
        return function;
    }

    public static Function com$twitter$finagle$stats$StatsReceiverWithCumulativeGauges$$whenNotPresent(StatsReceiverWithCumulativeGauges $this, Verbosity verbosity) {
        return new Function<Seq<String>, CumulativeGauge>($this, verbosity){
            private final /* synthetic */ StatsReceiverWithCumulativeGauges $outer;
            public final Verbosity verbosity$1;

            public CumulativeGauge apply(Seq<String> key) {
                return new CumulativeGauge(this, key){
                    private final StampedLock lock;
                    private final AtomicInteger registers;
                    private boolean dead;
                    private final /* synthetic */ StatsReceiverWithCumulativeGauges$.anon.2 $outer;
                    private final Seq key$1;

                    /*
                     * WARNING - void declaration
                     */
                    public boolean register() {
                        long stamp;
                        block3: {
                            stamp = this.lock.readLock();
                            try {
                                if (!this.dead) break block3;
                                this.lock.unlockRead(stamp);
                                return false;
                            }
                            catch (Throwable throwable) {
                                void var1_1;
                                this.lock.unlockRead((long)var1_1);
                                throw throwable;
                            }
                        }
                        this.registers.incrementAndGet();
                        this.lock.unlockRead(stamp);
                        return true;
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    public void deregister() {
                        long readStamp = this.lock.readLock();
                        if (this.registers.decrementAndGet() != 0) {
                            this.lock.unlockRead(readStamp);
                            return;
                        }
                        this.lock.unlockRead(readStamp);
                        long writeStamp = this.lock.writeLock();
                        try {
                            if (!this.dead && this.registers.get() == 0) {
                                this.dead = true;
                                this.$outer.com$twitter$finagle$stats$StatsReceiverWithCumulativeGauges$$anon$$$outer().com$twitter$finagle$stats$StatsReceiverWithCumulativeGauges$$gauges().remove(this.key$1);
                                this.$outer.com$twitter$finagle$stats$StatsReceiverWithCumulativeGauges$$anon$$$outer().deregisterGauge((Seq<String>)this.key$1);
                            }
                            this.lock.unlockWrite(writeStamp);
                            return;
                        }
                        catch (Throwable throwable) {
                            void var3_2;
                            this.lock.unlockWrite((long)var3_2);
                            throw throwable;
                        }
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.key$1 = key$1;
                        $outer.com$twitter$finagle$stats$StatsReceiverWithCumulativeGauges$$anon$$$outer().registerGauge($outer.verbosity$1, (Seq<String>)key$1, (Function0<Object>)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ StatsReceiverWithCumulativeGauges$$anon$2$.anon.3 $outer;

                            public final float apply() {
                                return this.apply$mcF$sp();
                            }

                            public float apply$mcF$sp() {
                                return this.$outer.getValue();
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        });
                        this.lock = new StampedLock();
                        this.registers = new AtomicInteger(0);
                        this.dead = false;
                    }
                };
            }

            public /* synthetic */ StatsReceiverWithCumulativeGauges com$twitter$finagle$stats$StatsReceiverWithCumulativeGauges$$anon$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.verbosity$1 = verbosity$1;
            }
        };
    }

    public static Gauge addGauge(StatsReceiverWithCumulativeGauges $this, Verbosity verbosity, Seq name, Function0 f) {
        Gauge gauge = null;
        while (gauge == null) {
            CumulativeGauge cumulativeGauge = (CumulativeGauge)$this.com$twitter$finagle$stats$StatsReceiverWithCumulativeGauges$$gauges().computeIfAbsent(name, StatsReceiverWithCumulativeGauges$class.com$twitter$finagle$stats$StatsReceiverWithCumulativeGauges$$getWhenNotPresent($this, verbosity));
            gauge = cumulativeGauge.addGauge((Function0<Object>)f);
        }
        return gauge;
    }

    public static int numUnderlying(StatsReceiverWithCumulativeGauges $this, Seq name) {
        CumulativeGauge cumulativeGauge = (CumulativeGauge)$this.com$twitter$finagle$stats$StatsReceiverWithCumulativeGauges$$gauges().get(name);
        return cumulativeGauge == null ? 0 : cumulativeGauge.size();
    }

    public static void $init$(StatsReceiverWithCumulativeGauges $this) {
        $this.com$twitter$finagle$stats$StatsReceiverWithCumulativeGauges$_setter_$com$twitter$finagle$stats$StatsReceiverWithCumulativeGauges$$gauges_$eq(new ConcurrentHashMap());
        $this.com$twitter$finagle$stats$StatsReceiverWithCumulativeGauges$_setter_$com$twitter$finagle$stats$StatsReceiverWithCumulativeGauges$$whenDefaultNotPresent_$eq(StatsReceiverWithCumulativeGauges$class.com$twitter$finagle$stats$StatsReceiverWithCumulativeGauges$$whenNotPresent($this, Verbosity$.MODULE$.Default()));
        $this.com$twitter$finagle$stats$StatsReceiverWithCumulativeGauges$_setter_$com$twitter$finagle$stats$StatsReceiverWithCumulativeGauges$$whenDebugNotPresent_$eq(StatsReceiverWithCumulativeGauges$class.com$twitter$finagle$stats$StatsReceiverWithCumulativeGauges$$whenNotPresent($this, Verbosity$.MODULE$.Debug()));
    }
}

