/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.util.security;

import com.twitter.util.Try;
import com.twitter.util.Try$;
import com.twitter.util.security.PemBytes;
import java.io.ByteArrayInputStream;
import java.io.Serializable;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import scala.Function1;
import scala.Tuple2;
import scala.collection.IterableOps;
import scala.collection.immutable.Seq;
import scala.runtime.ModuleSerializationProxy;

public final class X509CertificateDeserializer$
implements Serializable {
    private static final String MessageType;
    private static final Function1<byte[], X509Certificate> deserializeX509;
    public static final X509CertificateDeserializer$ MODULE$;

    private X509CertificateDeserializer$() {
    }

    static {
        MODULE$ = new X509CertificateDeserializer$();
        MessageType = "CERTIFICATE";
        deserializeX509 = (Function1 & Serializable)certBytes -> {
            void var3_3;
            CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
            X509Certificate certificate = (X509Certificate)certFactory.generateCertificate(new ByteArrayInputStream((byte[])certBytes));
            certificate.checkValidity();
            return var3_3;
        };
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(X509CertificateDeserializer$.class);
    }

    public Try<X509Certificate> deserializeCertificate(String rawPem, String name) {
        PemBytes pemBytes = new PemBytes(rawPem, name);
        Try<byte[]> message = pemBytes.readMessage(MessageType);
        return message.map(deserializeX509);
    }

    public Try<Seq<X509Certificate>> deserializeCertificates(String rawPem, String name) {
        PemBytes pemBytes = new PemBytes(rawPem, name);
        Try<Seq<byte[]>> messages = pemBytes.readMessages(MessageType);
        return messages.map((Function1 & Serializable)_$1 -> (Seq)_$1.map(deserializeX509));
    }

    public Tuple2<Seq<Try<X509Certificate>>, Seq<Try<X509Certificate>>> deserializeAndFilterOutInvalidCertificates(String rawPem, String name) {
        PemBytes pemBytes = new PemBytes(rawPem, name);
        Try<Seq<byte[]>> messages = pemBytes.readMessages(MessageType);
        return (Tuple2)messages.map((Function1 & Serializable)certs -> ((IterableOps)certs.map((Function1 & Serializable)cert -> Try$.MODULE$.apply(() -> this.deserializeAndFilterOutInvalidCertificates$$anonfun$2$$anonfun$1$$anonfun$1(cert)))).partition((Function1 & Serializable)_$2 -> _$2.isReturn())).get();
    }

    private final X509Certificate deserializeAndFilterOutInvalidCertificates$$anonfun$2$$anonfun$1$$anonfun$1(byte[] cert$1) {
        return (X509Certificate)deserializeX509.apply((Object)cert$1);
    }
}

