/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.util.security;

import com.twitter.util.Try;
import com.twitter.util.security.X509CertificateFile;
import com.twitter.util.security.X509TrustManagerFactory$;
import java.io.File;
import java.io.Serializable;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import scala.Function1;
import scala.collection.immutable.Seq;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public class X509TrustManagerFactory {
    private final File certsFile;

    public static Try<TrustManager[]> buildTrustManager(Seq<X509Certificate> seq) {
        return X509TrustManagerFactory$.MODULE$.buildTrustManager(seq);
    }

    public static KeyStore certsToKeyStore(Seq<X509Certificate> seq) {
        return X509TrustManagerFactory$.MODULE$.certsToKeyStore(seq);
    }

    public static TrustManagerFactory certsToTrustManagerFactory(Seq<X509Certificate> seq) {
        return X509TrustManagerFactory$.MODULE$.certsToTrustManagerFactory(seq);
    }

    public X509TrustManagerFactory(File certsFile) {
        this.certsFile = certsFile;
    }

    private void logException(Throwable ex) {
        X509TrustManagerFactory$.com$twitter$util$security$X509TrustManagerFactory$$$log.warning("X509TrustManagerFactory (" + this.certsFile.getName() + ") " + ("failed to create trust manager: " + ex.getMessage() + "."), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
    }

    public Try<TrustManager[]> getTrustManagers() {
        Try<Seq<X509Certificate>> tryCerts = new X509CertificateFile(this.certsFile).readX509Certificates();
        return tryCerts.flatMap((Function1 & Serializable)x509Certificates -> X509TrustManagerFactory$.MODULE$.buildTrustManager((Seq<X509Certificate>)x509Certificates)).onFailure((Function1)(JProcedure1 & Serializable)ex -> this.logException((Throwable)ex));
    }
}

