/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.util.security;

import com.twitter.util.Try;
import com.twitter.util.security.PemFile;
import com.twitter.util.security.X509CertificateFile$;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001U4A!\u0001\u0002\u0001\u0017\t\u0019\u0002,\u000e\u0019:\u0007\u0016\u0014H/\u001b4jG\u0006$XMR5mK*\u00111\u0001B\u0001\tg\u0016\u001cWO]5us*\u0011QAB\u0001\u0005kRLGN\u0003\u0002\b\u0011\u00059Ao^5ui\u0016\u0014(\"A\u0005\u0002\u0007\r|Wn\u0001\u0001\u0014\u0005\u0001a\u0001CA\u0007\u0011\u001b\u0005q!\"A\b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Eq!AB!osJ+g\r\u0003\u0005\u0014\u0001\t\u0005\t\u0015!\u0003\u0015\u0003\u00111\u0017\u000e\\3\u0011\u0005UQR\"\u0001\f\u000b\u0005]A\u0012AA5p\u0015\u0005I\u0012\u0001\u00026bm\u0006L!a\u0007\f\u0003\t\u0019KG.\u001a\u0005\u0006;\u0001!\tAH\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005}\t\u0003C\u0001\u0011\u0001\u001b\u0005\u0011\u0001\"B\n\u001d\u0001\u0004!\u0002BB\u0012\u0001A\u0013%A%\u0001\u0007m_\u001e,\u0005pY3qi&|g\u000e\u0006\u0002&QA\u0011QBJ\u0005\u0003O9\u0011A!\u00168ji\")\u0011F\ta\u0001U\u0005\u0011Q\r\u001f\t\u0003WMr!\u0001L\u0019\u000f\u00055\u0002T\"\u0001\u0018\u000b\u0005=R\u0011A\u0002\u001fs_>$h(C\u0001\u0010\u0013\t\u0011d\"A\u0004qC\u000e\\\u0017mZ3\n\u0005Q*$!\u0003+ie><\u0018M\u00197f\u0015\t\u0011d\u0002\u0003\u00048\u0001\u0001&I\u0001O\u0001\u0018O\u0016tWM]1uKb+\u0004'O\"feRLg-[2bi\u0016$\"!\u000f!\u0011\u0005irT\"A\u001e\u000b\u0005qj\u0014\u0001B2feRT!a\u0001\r\n\u0005}Z$a\u0004-6ae\u001aUM\u001d;jM&\u001c\u0017\r^3\t\u000b\u00053\u0004\u0019\u0001\"\u0002\u001d\u0011,7m\u001c3fI6+7o]1hKB\u0019QbQ#\n\u0005\u0011s!!B!se\u0006L\bCA\u0007G\u0013\t9eB\u0001\u0003CsR,\u0007\"B%\u0001\t\u0003Q\u0015a\u0005:fC\u0012DV\u0007M\u001dDKJ$\u0018NZ5dCR,G#A&\u0011\u00071k\u0015(D\u0001\u0005\u0013\tqEAA\u0002UefDQ\u0001\u0015\u0001\u0005\u0002E\u000bAC]3bIb+\u0004'O\"feRLg-[2bi\u0016\u001cH#\u0001*\u0011\u00071k5\u000bE\u0002,)fJ!!V\u001b\u0003\u0007M+\u0017oB\u0003X\u0005!%\u0001,A\nYkAJ4)\u001a:uS\u001aL7-\u0019;f\r&dW\r\u0005\u0002!3\u001a)\u0011A\u0001E\u00055N\u0011\u0011\f\u0004\u0005\u0006;e#\t\u0001\u0018\u000b\u00021\"9a,\u0017b\u0001\n\u0013y\u0016aC'fgN\fw-\u001a+za\u0016,\u0012\u0001\u0019\t\u0003C\u0016t!AY2\u0011\u00055r\u0011B\u00013\u000f\u0003\u0019\u0001&/\u001a3fM&\u0011am\u001a\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u0011t\u0001BB5ZA\u0003%\u0001-\u0001\u0007NKN\u001c\u0018mZ3UsB,\u0007\u0005C\u0004l3\n\u0007I\u0011\u00027\u0002\u00071|w-F\u0001n!\tq\u0017/D\u0001p\u0015\t\u0001h!A\u0004m_\u001e<\u0017N\\4\n\u0005I|'A\u0002'pO\u001e,'\u000f\u0003\u0004u3\u0002\u0006I!\\\u0001\u0005Y><\u0007\u0005")
public class X509CertificateFile {
    private final File file;

    private void logException(Throwable ex) {
        X509CertificateFile$.MODULE$.com$twitter$util$security$X509CertificateFile$$log().warning(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"X509Certificate (", ") failed to load: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.file.getName(), ex.getMessage()})), (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
    }

    private X509Certificate generateX509Certificate(byte[] decodedMessage) {
        CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
        return (X509Certificate)certFactory.generateCertificate(new ByteArrayInputStream(decodedMessage));
    }

    public Try<X509Certificate> readX509Certificate() {
        PemFile pemFile = new PemFile(this.file);
        return pemFile.readMessage(X509CertificateFile$.MODULE$.com$twitter$util$security$X509CertificateFile$$MessageType()).map((Function1 & java.io.Serializable & Serializable)decodedMessage -> this.generateX509Certificate((byte[])decodedMessage)).onFailure((Function1 & java.io.Serializable & Serializable)ex -> {
            this.logException(ex);
            return BoxedUnit.UNIT;
        });
    }

    public Try<Seq<X509Certificate>> readX509Certificates() {
        PemFile pemFile = new PemFile(this.file);
        return pemFile.readMessages(X509CertificateFile$.MODULE$.com$twitter$util$security$X509CertificateFile$$MessageType()).map((Function1 & java.io.Serializable & Serializable)certBytes -> (Seq)certBytes.map((Function1 & java.io.Serializable & Serializable)decodedMessage -> this.generateX509Certificate((byte[])decodedMessage), Seq$.MODULE$.canBuildFrom())).onFailure((Function1 & java.io.Serializable & Serializable)ex -> {
            this.logException(ex);
            return BoxedUnit.UNIT;
        });
    }

    public X509CertificateFile(File file) {
        this.file = file;
    }
}

