/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.util.security.exp;

import com.twitter.logging.Logger;
import com.twitter.logging.Logger$;
import com.twitter.util.Try;
import com.twitter.util.Try$;
import com.twitter.util.security.exp.X509CertificateLoader$$anonfun$com$twitter$util$security$exp$X509CertificateLoader$;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;

public final class X509CertificateLoader$ {
    public static final X509CertificateLoader$ MODULE$;
    private final Logger log;

    static {
        new X509CertificateLoader$();
    }

    private boolean isReadableFile(File file) {
        return file.isFile() && file.canRead();
    }

    public X509Certificate com$twitter$util$security$exp$X509CertificateLoader$$readX509Certificate(InputStream inputStream) {
        CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
        return (X509Certificate)certFactory.generateCertificate(inputStream);
    }

    public InputStream com$twitter$util$security$exp$X509CertificateLoader$$openStream(File certFile) {
        return new FileInputStream(certFile);
    }

    public void com$twitter$util$security$exp$X509CertificateLoader$$closeStream(InputStream inputStream) {
        inputStream.close();
    }

    private Try<InputStream> tryOpen(File certFile) {
        return Try$.MODULE$.apply((Function0)new Serializable(certFile){
            public static final long serialVersionUID = 0L;
            private final File certFile$1;

            public final InputStream apply() {
                return X509CertificateLoader$.MODULE$.com$twitter$util$security$exp$X509CertificateLoader$$openStream(this.certFile$1);
            }
            {
                this.certFile$1 = certFile$1;
            }
        });
    }

    public Try<X509Certificate> com$twitter$util$security$exp$X509CertificateLoader$$tryRead(InputStream inputStream) {
        return Try$.MODULE$.apply((Function0)new Serializable(inputStream){
            public static final long serialVersionUID = 0L;
            private final InputStream inputStream$1;

            public final X509Certificate apply() {
                return X509CertificateLoader$.MODULE$.com$twitter$util$security$exp$X509CertificateLoader$$readX509Certificate(this.inputStream$1);
            }
            {
                this.inputStream$1 = inputStream$1;
            }
        }).ensure((Function0)new Serializable(inputStream){
            public static final long serialVersionUID = 0L;
            public final InputStream inputStream$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Try$.MODULE$.apply((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun$com$twitter$util$security$exp$X509CertificateLoader$$tryRead$1 $outer;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        X509CertificateLoader$.MODULE$.com$twitter$util$security$exp$X509CertificateLoader$$closeStream(this.$outer.inputStream$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.inputStream$1 = inputStream$1;
            }
        });
    }

    public void com$twitter$util$security$exp$X509CertificateLoader$$logException(File certFile, Throwable ex) {
        this.log.warning(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"X509Certificate (", ") failed to load: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{certFile.getName(), ex.getMessage()})), (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
    }

    private void logNotReadableFile(File certFile) {
        this.log.warning(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"X509Certificate (", ") is not a file or is not readable."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{certFile.getName()})), (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
    }

    public Option<X509Certificate> load(File certFile) {
        None$ none$;
        if (this.isReadableFile(certFile)) {
            none$ = this.tryOpen(certFile).flatMap((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Try<X509Certificate> apply(InputStream inputStream) {
                    return X509CertificateLoader$.MODULE$.com$twitter$util$security$exp$X509CertificateLoader$$tryRead(inputStream);
                }
            }).onFailure((Function1)new Serializable(certFile){
                public static final long serialVersionUID = 0L;
                private final File certFile$2;

                public final void apply(Throwable ex) {
                    X509CertificateLoader$.MODULE$.com$twitter$util$security$exp$X509CertificateLoader$$logException(this.certFile$2, ex);
                }
                {
                    this.certFile$2 = certFile$2;
                }
            }).toOption();
        } else {
            this.logNotReadableFile(certFile);
            none$ = None$.MODULE$;
        }
        return none$;
    }

    private X509CertificateLoader$() {
        MODULE$ = this;
        this.log = Logger$.MODULE$.get("com.twitter.util.security");
    }
}

