/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.logging;

import com.twitter.logging.Formatter$;
import com.twitter.logging.Level;
import com.twitter.logging.LogRecord;
import com.twitter.logging.Logger$;
import com.twitter.util.TwitterDateFormat$;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public class Formatter
extends java.util.logging.Formatter {
    private final Option timezone;
    private final int truncateAt;
    private final int truncateStackTracesAt;
    private final boolean useFullPackageNames;
    private final String prefix;
    private final SimpleDateFormat DATE_FORMAT;
    private final String FORMAT;
    private final GregorianCalendar calendar;

    public static Pattern DateFormatRegex() {
        return Formatter$.MODULE$.DateFormatRegex();
    }

    public static String DefaultPrefix() {
        return Formatter$.MODULE$.DefaultPrefix();
    }

    public static int DefaultStackTraceSizeLimit() {
        return Formatter$.MODULE$.DefaultStackTraceSizeLimit();
    }

    public static List<String> formatStackTrace(Throwable throwable, int n) {
        return Formatter$.MODULE$.formatStackTrace(throwable, n);
    }

    public static Option<String> $lessinit$greater$default$1() {
        return Formatter$.MODULE$.$lessinit$greater$default$1();
    }

    public static int $lessinit$greater$default$2() {
        return Formatter$.MODULE$.$lessinit$greater$default$2();
    }

    public static int $lessinit$greater$default$3() {
        return Formatter$.MODULE$.$lessinit$greater$default$3();
    }

    public static boolean $lessinit$greater$default$4() {
        return Formatter$.MODULE$.$lessinit$greater$default$4();
    }

    public static String $lessinit$greater$default$5() {
        return Formatter$.MODULE$.$lessinit$greater$default$5();
    }

    public Formatter(Option<String> timezone, int truncateAt, int truncateStackTracesAt, boolean useFullPackageNames, String prefix) {
        this.timezone = timezone;
        this.truncateAt = truncateAt;
        this.truncateStackTracesAt = truncateStackTracesAt;
        this.useFullPackageNames = useFullPackageNames;
        this.prefix = prefix;
        Matcher matcher = Formatter$.MODULE$.DateFormatRegex().matcher(prefix);
        this.DATE_FORMAT = TwitterDateFormat$.MODULE$.apply(matcher.find() ? matcher.group(1) : "yyyyMMdd-HH:mm:ss.SSS");
        this.FORMAT = matcher.replaceFirst("%3\\$s");
        this.calendar = timezone.isDefined() ? new GregorianCalendar(TimeZone.getTimeZone((String)timezone.get())) : new GregorianCalendar();
        this.dateFormat().setCalendar(this.calendar());
    }

    public Option<String> timezone() {
        return this.timezone;
    }

    public int truncateAt() {
        return this.truncateAt;
    }

    public int truncateStackTracesAt() {
        return this.truncateStackTracesAt;
    }

    public boolean useFullPackageNames() {
        return this.useFullPackageNames;
    }

    public String prefix() {
        return this.prefix;
    }

    public DateFormat dateFormat() {
        return this.DATE_FORMAT;
    }

    public GregorianCalendar calendar() {
        return this.calendar;
    }

    public String formatPrefix(java.util.logging.Level level, String date, String name) {
        return StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(this.FORMAT), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.formatLevelName(level), name, date}));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String formatLevelName(java.util.logging.Level level) {
        String string;
        java.util.logging.Level level2 = level;
        if (level2 instanceof Level) {
            Level x = (Level)level2;
            string = x.name();
            return string;
        } else {
            if (level2 == null) throw new MatchError((Object)level2);
            java.util.logging.Level x = level2;
            Option option = Logger$.MODULE$.levels().get((Object)BoxesRunTime.boxToInteger((int)x.intValue()));
            if (None$.MODULE$.equals(option)) {
                string = StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%03d"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)x.intValue())}));
                return string;
            } else {
                if (!(option instanceof Some)) throw new MatchError((Object)option);
                Level level3 = (Level)((Some)option).value();
                string = level3.name();
            }
        }
        return string;
    }

    public String lineTerminator() {
        return "\n";
    }

    public String[] formatMessageLines(java.util.logging.LogRecord record) {
        String message = this.truncateText(this.formatText(record));
        return this.formatMessageLines(message, record.getThrown());
    }

    public String[] formatMessageLines(String message, Throwable thrown) {
        String[] stringArray;
        boolean containsNewLine;
        boolean bl = containsNewLine = message.indexOf(10) >= 0;
        if (!containsNewLine && thrown == null) {
            stringArray = new String[]{message};
        } else {
            Object[] splitOnNewlines = message.split("\n");
            int numThrowLines = thrown == null ? 0 : 20;
            ArrayBuffer lines = new ArrayBuffer(splitOnNewlines.length + numThrowLines);
            lines.$plus$plus$eq((IterableOnce)Predef$.MODULE$.wrapRefArray(splitOnNewlines));
            if (thrown != null) {
                List<String> traceLines = Formatter$.MODULE$.formatStackTrace(thrown, this.truncateStackTracesAt());
                lines.$plus$eq((Object)thrown.toString());
                if (traceLines.nonEmpty()) {
                    lines.$plus$plus$eq(traceLines);
                }
            }
            stringArray = (String[])lines.toArray(ClassTag$.MODULE$.apply(String.class));
        }
        return stringArray;
    }

    public String formatText(java.util.logging.LogRecord record) {
        String string;
        java.util.logging.LogRecord logRecord = record;
        if (logRecord == null) {
            string = "";
        } else if (logRecord instanceof LogRecord) {
            LogRecord r = (LogRecord)logRecord;
            Object[] objectArray = r.getParameters();
            if (objectArray == null) {
                string = r.getMessage();
            } else {
                Object[] formatArgs = objectArray;
                string = String.format(r.getMessage(), formatArgs);
            }
        } else if (logRecord != null) {
            java.util.logging.LogRecord r = logRecord;
            Object[] objectArray = r.getParameters();
            if (objectArray == null) {
                string = r.getMessage();
            } else {
                Object[] formatArgs = objectArray;
                string = MessageFormat.format(r.getMessage(), formatArgs);
            }
        } else {
            throw new MatchError((Object)logRecord);
        }
        return string;
    }

    @Override
    public String format(java.util.logging.LogRecord record) {
        String name = this.formatName(record);
        String prefix = this.formatPrefix(record.getLevel(), this.dateFormat().format(new Date(record.getMillis())), name);
        return Predef$.MODULE$.wrapRefArray((Object[])this.formatMessageLines(record)).mkString(prefix, this.lineTerminator() + prefix, this.lineTerminator());
    }

    public String formatName(java.util.logging.LogRecord record) {
        Object object;
        String string = record.getLoggerName();
        if (string == null) {
            object = "(root)";
        } else if ("".equals(string)) {
            object = "(root)";
        } else {
            String n = string;
            Object[] nameSegments = n.split("\\.");
            if (nameSegments.length >= 2) {
                if (this.useFullPackageNames()) {
                    Object object2 = Predef$.MODULE$.refArrayOps(nameSegments);
                    object = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.slice$extension(object2, 0, nameSegments.length - 1)).mkString(".");
                } else {
                    object = nameSegments[nameSegments.length - 2];
                }
            } else {
                object = n;
            }
        }
        return object;
    }

    public String truncateText(String message) {
        return this.truncateAt() > 0 && message.length() > this.truncateAt() ? StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(message), this.truncateAt()) + "..." : message;
    }
}

