/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.logging;

import com.twitter.logging.Formatter;
import com.twitter.logging.Formatter$;
import com.twitter.logging.Handler;
import com.twitter.logging.Level;
import com.twitter.logging.SyslogFuture$;
import com.twitter.logging.SyslogHandler$;
import java.io.Serializable;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.text.SimpleDateFormat;
import java.util.logging.LogRecord;
import scala.Function0;
import scala.Option;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;

public class SyslogHandler
extends Handler {
    private final String server;
    private final int port;
    private final DatagramSocket socket;
    private final InetSocketAddress dest;

    public static int DEFAULT_PORT() {
        return SyslogHandler$.MODULE$.DEFAULT_PORT();
    }

    public static SimpleDateFormat ISO_DATE_FORMAT() {
        return SyslogHandler$.MODULE$.ISO_DATE_FORMAT();
    }

    public static SimpleDateFormat OLD_SYSLOG_DATE_FORMAT() {
        return SyslogHandler$.MODULE$.OLD_SYSLOG_DATE_FORMAT();
    }

    public static int PRIORITY_DAEMON() {
        return SyslogHandler$.MODULE$.PRIORITY_DAEMON();
    }

    public static int PRIORITY_LOCAL0() {
        return SyslogHandler$.MODULE$.PRIORITY_LOCAL0();
    }

    public static int PRIORITY_LOCAL1() {
        return SyslogHandler$.MODULE$.PRIORITY_LOCAL1();
    }

    public static int PRIORITY_LOCAL2() {
        return SyslogHandler$.MODULE$.PRIORITY_LOCAL2();
    }

    public static int PRIORITY_LOCAL3() {
        return SyslogHandler$.MODULE$.PRIORITY_LOCAL3();
    }

    public static int PRIORITY_LOCAL4() {
        return SyslogHandler$.MODULE$.PRIORITY_LOCAL4();
    }

    public static int PRIORITY_LOCAL5() {
        return SyslogHandler$.MODULE$.PRIORITY_LOCAL5();
    }

    public static int PRIORITY_LOCAL6() {
        return SyslogHandler$.MODULE$.PRIORITY_LOCAL6();
    }

    public static int PRIORITY_LOCAL7() {
        return SyslogHandler$.MODULE$.PRIORITY_LOCAL7();
    }

    public static int PRIORITY_USER() {
        return SyslogHandler$.MODULE$.PRIORITY_USER();
    }

    public static Function0<SyslogHandler> apply(String string, int n, Formatter formatter, Option<Level> option) {
        return SyslogHandler$.MODULE$.apply(string, n, formatter, option);
    }

    public static int severityForLogLevel(int n) {
        return SyslogHandler$.MODULE$.severityForLogLevel(n);
    }

    public static String apply$default$1() {
        return SyslogHandler$.MODULE$.apply$default$1();
    }

    public static int apply$default$2() {
        return SyslogHandler$.MODULE$.apply$default$2();
    }

    public static Formatter apply$default$3() {
        return SyslogHandler$.MODULE$.apply$default$3();
    }

    public static Option<Level> apply$default$4() {
        return SyslogHandler$.MODULE$.apply$default$4();
    }

    public SyslogHandler(String server, int port, Formatter formatter, Option<Level> level) {
        this.server = server;
        this.port = port;
        super(formatter, level);
        this.socket = new DatagramSocket();
        this.dest = new InetSocketAddress(server, port);
    }

    public String server() {
        return this.server;
    }

    public int port() {
        return this.port;
    }

    private Formatter formatter$accessor() {
        return super.formatter();
    }

    private Option<Level> level$accessor() {
        return super.level();
    }

    public InetSocketAddress dest() {
        return this.dest;
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }

    @Override
    public void publish(LogRecord record) {
        byte[] data = this.formatter$accessor().format(record).getBytes();
        DatagramPacket packet = new DatagramPacket(data, data.length, this.dest());
        SyslogFuture$.MODULE$.apply((Function0<BoxedUnit>)((JFunction0.mcV.sp & Serializable)() -> this.publish$$anonfun$1(packet)));
    }

    private final void liftedTree1$1(DatagramPacket packet$2) {
        try {
            this.socket.send(packet$2);
        }
        catch (Throwable e) {
            System.err.println(Formatter$.MODULE$.formatStackTrace(e, 30).mkString("\n"));
        }
    }

    private final void publish$$anonfun$1(DatagramPacket packet$1) {
        this.liftedTree1$1(packet$1);
    }
}

