/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.logging;

import com.twitter.logging.Formatter;
import com.twitter.logging.Level;
import com.twitter.logging.SyslogFormatter$;
import com.twitter.logging.SyslogHandler$;
import java.text.DateFormat;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public class SyslogFormatter
extends Formatter {
    private final String hostname;
    private final Option serverName;
    private final boolean useIsoDateFormat;
    private final int priority;

    public static String $lessinit$greater$default$1() {
        return SyslogFormatter$.MODULE$.$lessinit$greater$default$1();
    }

    public static Option<String> $lessinit$greater$default$2() {
        return SyslogFormatter$.MODULE$.$lessinit$greater$default$2();
    }

    public static boolean $lessinit$greater$default$3() {
        return SyslogFormatter$.MODULE$.$lessinit$greater$default$3();
    }

    public static int $lessinit$greater$default$4() {
        return SyslogFormatter$.MODULE$.$lessinit$greater$default$4();
    }

    public static Option<String> $lessinit$greater$default$5() {
        return SyslogFormatter$.MODULE$.$lessinit$greater$default$5();
    }

    public static int $lessinit$greater$default$6() {
        return SyslogFormatter$.MODULE$.$lessinit$greater$default$6();
    }

    public static int $lessinit$greater$default$7() {
        return SyslogFormatter$.MODULE$.$lessinit$greater$default$7();
    }

    public SyslogFormatter(String hostname, Option<String> serverName, boolean useIsoDateFormat, int priority, Option<String> timezone, int truncateAt, int truncateStackTracesAt) {
        this.hostname = hostname;
        this.serverName = serverName;
        this.useIsoDateFormat = useIsoDateFormat;
        this.priority = priority;
        super(timezone, truncateAt, truncateStackTracesAt, false, "");
    }

    public String hostname() {
        return this.hostname;
    }

    public Option<String> serverName() {
        return this.serverName;
    }

    public boolean useIsoDateFormat() {
        return this.useIsoDateFormat;
    }

    public int priority() {
        return this.priority;
    }

    private Option<String> timezone$accessor() {
        return super.timezone();
    }

    private int truncateAt$accessor() {
        return super.truncateAt();
    }

    private int truncateStackTracesAt$accessor() {
        return super.truncateStackTracesAt();
    }

    @Override
    public DateFormat dateFormat() {
        return this.useIsoDateFormat() ? SyslogHandler$.MODULE$.ISO_DATE_FORMAT() : SyslogHandler$.MODULE$.OLD_SYSLOG_DATE_FORMAT();
    }

    @Override
    public String lineTerminator() {
        return "";
    }

    @Override
    public String formatPrefix(java.util.logging.Level level, String date, String name) {
        String string;
        int n;
        java.util.logging.Level level2 = level;
        if (level2 instanceof Level) {
            Level x = (Level)level2;
            n = SyslogHandler$.MODULE$.severityForLogLevel(x.value());
        } else if (level2 != null) {
            java.util.logging.Level x = level2;
            n = SyslogHandler$.MODULE$.severityForLogLevel(x.intValue());
        } else {
            throw new MatchError((Object)level2);
        }
        int syslogLevel = n;
        Option<String> option = this.serverName();
        if (None$.MODULE$.equals(option)) {
            string = StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("<%d>%s %s %s: "), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(this.priority() | syslogLevel)), date, this.hostname(), name}));
        } else if (option instanceof Some) {
            String serverName = (String)((Some)option).value();
            string = StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("<%d>%s %s [%s] %s: "), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(this.priority() | syslogLevel)), date, this.hostname(), serverName, name}));
        } else {
            throw new MatchError(option);
        }
        return string;
    }
}

