/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.logging;

import com.twitter.logging.FileHandler$;
import com.twitter.logging.Formatter;
import com.twitter.logging.Formatter$;
import com.twitter.logging.Handler;
import com.twitter.logging.Level;
import com.twitter.logging.Policy;
import com.twitter.logging.Policy$Daily$;
import com.twitter.logging.Policy$Hourly$;
import com.twitter.logging.Policy$MaxSize$;
import com.twitter.logging.Policy$Never$;
import com.twitter.logging.Policy$SigHup$;
import com.twitter.logging.Policy$Weekly$;
import com.twitter.util.HandleSignal$;
import com.twitter.util.StorageUnit;
import com.twitter.util.Time$;
import com.twitter.util.TwitterDateFormat$;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.LogRecord;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.math.Ordering;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.LazyRef;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;

public class FileHandler
extends Handler {
    private final Policy rollPolicy;
    private final boolean append;
    private final int rotateCount;
    private final String filename;
    private final String name;
    private final String filenamePrefix;
    private final String filenameSuffix;
    private OutputStream stream;
    private volatile long openTime;
    private Option<Object> nextRollTime;
    private long bytesWrittenToFile;
    private final Option<StorageUnit> maxFileSize;
    private final boolean examineRollTime;

    public static Charset UTF8() {
        return FileHandler$.MODULE$.UTF8();
    }

    public static Function0<FileHandler> apply(String string, Policy policy, boolean bl, int n, Formatter formatter, Option<Level> option) {
        return FileHandler$.MODULE$.apply(string, policy, bl, n, formatter, option);
    }

    public static Policy apply$default$2() {
        return FileHandler$.MODULE$.apply$default$2();
    }

    public static boolean apply$default$3() {
        return FileHandler$.MODULE$.apply$default$3();
    }

    public static int apply$default$4() {
        return FileHandler$.MODULE$.apply$default$4();
    }

    public static Formatter apply$default$5() {
        return FileHandler$.MODULE$.apply$default$5();
    }

    public static Option<Level> apply$default$6() {
        return FileHandler$.MODULE$.apply$default$6();
    }

    public FileHandler(String path, Policy rollPolicy, boolean append, int rotateCount, Formatter formatter, Option<Level> level) {
        None$ none$;
        this.rollPolicy = rollPolicy;
        this.append = append;
        this.rotateCount = rotateCount;
        super(formatter, level);
        File f = new File(path);
        Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)f.getAbsolutePath(), (Object)f.getName());
        this.filename = (String)tuple2._1();
        this.name = (String)tuple2._2();
        int n = this.filename().lastIndexOf(46);
        Tuple2 tuple22 = n > 0 ? Tuple2$.MODULE$.apply((Object)this.filename().substring(0, n), (Object)this.filename().substring(n)) : Tuple2$.MODULE$.apply((Object)this.filename(), (Object)"");
        this.filenamePrefix = (String)tuple22._1();
        this.filenameSuffix = (String)tuple22._2();
        this.stream = null;
        this.openTime = 0L;
        this.nextRollTime = None$.MODULE$;
        this.bytesWrittenToFile = 0L;
        Policy policy = rollPolicy;
        if (policy instanceof Policy.MaxSize) {
            StorageUnit storageUnit;
            Policy.MaxSize maxSize = Policy$MaxSize$.MODULE$.unapply((Policy.MaxSize)policy);
            StorageUnit size = storageUnit = maxSize._1();
            none$ = Some$.MODULE$.apply((Object)size);
        } else {
            none$ = None$.MODULE$;
        }
        this.maxFileSize = none$;
        this.openLog();
        this.examineRollTime = this.nextRollTime.isDefined();
        Policy policy2 = rollPolicy;
        Policy$SigHup$ policy$SigHup$ = Policy$SigHup$.MODULE$;
        if (!(policy2 != null ? !policy2.equals(policy$SigHup$) : policy$SigHup$ != null)) {
            HandleSignal$.MODULE$.apply("HUP", (Function1)(JProcedure1 & Serializable)signal -> {
                OutputStream oldStream = this.stream;
                FileHandler fileHandler = this;
                synchronized (fileHandler) {
                    this.stream = this.openStream();
                }
                this.liftedTree1$1(oldStream);
            });
        }
    }

    public boolean append() {
        return this.append;
    }

    private Formatter formatter$accessor() {
        return super.formatter();
    }

    private Option<Level> level$accessor() {
        return super.level();
    }

    public String filename() {
        return this.filename;
    }

    public String name() {
        return this.name;
    }

    public String filenamePrefix() {
        return this.filenamePrefix;
    }

    public String filenameSuffix() {
        return this.filenameSuffix;
    }

    @Override
    public void flush() {
        FileHandler fileHandler = this;
        synchronized (fileHandler) {
            this.stream.flush();
        }
    }

    @Override
    public void close() {
        FileHandler fileHandler = this;
        synchronized (fileHandler) {
            this.flush();
            this.liftedTree2$1();
        }
    }

    private OutputStream openStream() {
        File file = new File(this.filename());
        File dir = file.getParentFile();
        if (dir != null && !dir.exists()) {
            dir.mkdirs();
        }
        this.bytesWrittenToFile = file.exists() ? file.length() : 0L;
        return new FileOutputStream(this.filename(), this.append());
    }

    private void openLog() {
        FileHandler fileHandler = this;
        synchronized (fileHandler) {
            this.stream = this.openStream();
            this.openTime = Time$.MODULE$.now().inMilliseconds();
            this.nextRollTime = this.computeNextRollTime(this.openTime);
        }
    }

    public String timeSuffix(Date date) {
        SimpleDateFormat simpleDateFormat;
        Policy policy = this.rollPolicy;
        if (Policy$Never$.MODULE$.equals(policy)) {
            simpleDateFormat = TwitterDateFormat$.MODULE$.apply("yyyy");
        } else if (Policy$SigHup$.MODULE$.equals(policy)) {
            simpleDateFormat = TwitterDateFormat$.MODULE$.apply("yyyy");
        } else if (Policy$Hourly$.MODULE$.equals(policy)) {
            simpleDateFormat = TwitterDateFormat$.MODULE$.apply("yyyyMMdd-HH");
        } else if (Policy$Daily$.MODULE$.equals(policy)) {
            simpleDateFormat = TwitterDateFormat$.MODULE$.apply("yyyyMMdd");
        } else if (policy instanceof Policy.Weekly) {
            Policy.Weekly weekly = Policy$Weekly$.MODULE$.unapply((Policy.Weekly)policy);
            int n = weekly._1();
            simpleDateFormat = TwitterDateFormat$.MODULE$.apply("yyyyMMdd");
        } else if (policy instanceof Policy.MaxSize) {
            Policy.MaxSize maxSize = Policy$MaxSize$.MODULE$.unapply((Policy.MaxSize)policy);
            StorageUnit storageUnit = maxSize._1();
            simpleDateFormat = TwitterDateFormat$.MODULE$.apply("yyyyMMdd-HHmmss");
        } else {
            throw new MatchError((Object)policy);
        }
        SimpleDateFormat dateFormat = simpleDateFormat;
        dateFormat.setCalendar(this.formatter$accessor().calendar());
        return dateFormat.format(date);
    }

    /*
     * Unable to fully structure code
     */
    public Option<Object> computeNextRollTime(long now) {
        block9: {
            var3_2 = new LazyRef();
            var5_3 = this.rollPolicy;
            if (!(var5_3 instanceof Policy.MaxSize)) break block9;
            var6_4 = Policy$MaxSize$.MODULE$.unapply((Policy.MaxSize)var5_3);
            var7_5 = var6_4._1();
            ** GOTO lbl-1000
        }
        if (Policy$Never$.MODULE$.equals(var5_3) || Policy$SigHup$.MODULE$.equals(var5_3)) lbl-1000:
        // 2 sources

        {
            v0 = None$.MODULE$;
        } else if (Policy$Hourly$.MODULE$.equals(var5_3)) {
            this.next$1(now, var3_2).add(11, 1);
            v0 = Some$.MODULE$.apply((Object)this.next$1(now, var3_2));
        } else if (Policy$Daily$.MODULE$.equals(var5_3)) {
            this.next$1(now, var3_2).set(11, 0);
            this.next$1(now, var3_2).add(5, 1);
            v0 = Some$.MODULE$.apply((Object)this.next$1(now, var3_2));
        } else if (var5_3 instanceof Policy.Weekly) {
            var8_6 = Policy$Weekly$.MODULE$.unapply((Policy.Weekly)var5_3);
            weekday = var9_7 = var8_6._1();
            this.next$1(now, var3_2).set(11, 0);
            this.next$1(now, var3_2).add(5, 1);
            while (this.next$1(now, var3_2).get(7) != weekday) {
                this.next$1(now, var3_2).add(5, 1);
            }
            v0 = Some$.MODULE$.apply((Object)this.next$1(now, var3_2));
        } else {
            throw new MatchError((Object)var5_3);
        }
        rv = v0;
        return rv.map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, computeNextRollTime$$anonfun$1(java.util.Calendar ), (Ljava/util/Calendar;)J)());
    }

    private void removeOldFiles() {
        if (this.rotateCount >= 0) {
            String prefixName = new File(this.filenamePrefix()).getName();
            Object object = Predef$.MODULE$.refArrayOps((Object[])new File(this.filename()).getParentFile().listFiles(new FilenameFilter(prefixName, this){
                private final String prefixName$1;
                private final FileHandler $outer;
                {
                    this.prefixName$1 = prefixName$2;
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public boolean accept(File f, String fname) {
                    String string = fname;
                    String string2 = this.$outer.name();
                    return (string == null ? string2 != null : !string.equals(string2)) && fname.startsWith(this.prefixName$1) && fname.endsWith(this.$outer.filenameSuffix());
                }
            }));
            Object[] rotatedFiles = (File[])ArrayOps$.MODULE$.sortBy$extension(object, (Function1 & Serializable)_$2 -> _$2.getName(), (Ordering)Ordering.String$.MODULE$);
            int toDeleteCount = package$.MODULE$.max(0, rotatedFiles.length - this.rotateCount);
            Object object2 = Predef$.MODULE$.refArrayOps(rotatedFiles);
            Object object3 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.take$extension(object2, toDeleteCount));
            ArrayOps$.MODULE$.foreach$extension(object3, (Function1 & Serializable)_$3 -> _$3.delete());
        }
    }

    public void roll() {
        FileHandler fileHandler = this;
        synchronized (fileHandler) {
            this.stream.close();
            String newFilename = this.filenamePrefix() + "-" + this.timeSuffix(new Date(this.openTime)) + this.filenameSuffix();
            new File(this.filename()).renameTo(new File(newFilename));
            this.openLog();
            this.removeOldFiles();
        }
    }

    @Override
    public void publish(LogRecord record) {
        try {
            String formattedLine = this.getFormatter().format(record);
            byte[] formattedBytes = formattedLine.getBytes(FileHandler$.MODULE$.UTF8());
            int lineSizeBytes = formattedBytes.length;
            if (this.examineRollTime) {
                FileHandler fileHandler = this;
                synchronized (fileHandler) {
                    this.nextRollTime.foreach((Function1)(JFunction1.mcVJ.sp & Serializable)time -> {
                        if (Time$.MODULE$.now().inMilliseconds() > time) {
                            this.roll();
                        }
                    });
                }
            }
            this.maxFileSize.foreach((Function1)(JProcedure1 & Serializable)size -> {
                FileHandler fileHandler = this;
                synchronized (fileHandler) {
                    BoxedUnit boxedUnit;
                    if (this.bytesWrittenToFile + (long)lineSizeBytes > size.bytes()) {
                        this.roll();
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                }
            });
            FileHandler fileHandler = this;
            synchronized (fileHandler) {
                this.stream.write(formattedBytes);
                this.stream.flush();
                this.bytesWrittenToFile += (long)lineSizeBytes;
            }
        }
        catch (Throwable e) {
            this.handleThrowable(e);
        }
    }

    private void handleThrowable(Throwable e) {
        System.err.println(Formatter$.MODULE$.formatStackTrace(e, 30).mkString("\n"));
    }

    private final void liftedTree1$1(OutputStream oldStream$1) {
        try {
            oldStream$1.close();
        }
        catch (Throwable e) {
            this.handleThrowable(e);
        }
    }

    private final void liftedTree2$1() {
        try {
            this.stream.close();
        }
        catch (Throwable e) {
            this.handleThrowable(e);
        }
    }

    private final Calendar next$lzyINIT1$1(long now$1, LazyRef next$lzy1$1) {
        Calendar calendar;
        LazyRef lazyRef = next$lzy1$1;
        synchronized (lazyRef) {
            Object object;
            if (next$lzy1$1.initialized()) {
                object = next$lzy1$1.value();
            } else {
                Calendar n = (Calendar)this.formatter$accessor().calendar().clone();
                n.setTimeInMillis(now$1);
                n.set(14, 0);
                n.set(13, 0);
                n.set(12, 0);
                object = next$lzy1$1.initialize((Object)n);
            }
            calendar = (Calendar)object;
        }
        return calendar;
    }

    private final Calendar next$1(long now$2, LazyRef next$lzy1$2) {
        return (Calendar)(next$lzy1$2.initialized() ? next$lzy1$2.value() : this.next$lzyINIT1$1(now$2, next$lzy1$2));
    }

    private static final /* synthetic */ long computeNextRollTime$$anonfun$1(Calendar _$1) {
        return _$1.getTimeInMillis();
    }
}

