/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.logging;

import com.twitter.logging.Handler;
import com.twitter.logging.Logger;
import com.twitter.logging.Logger$;
import com.twitter.logging.QueueingHandler$;
import com.twitter.util.Time$;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.LogRecord;
import scala.Console$;
import scala.Function0;
import scala.ScalaObject;
import scala.reflect.ScalaSignature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001\u0005}q!B\u0001\u0003\u0011\u000bI\u0011aD)vKV,\u0017N\\4IC:$G.\u001a:\u000b\u0005\r!\u0011a\u00027pO\u001eLgn\u001a\u0006\u0003\u000b\u0019\tq\u0001^<jiR,'OC\u0001\b\u0003\r\u0019w.\\\u0002\u0001!\tQ1\"D\u0001\u0003\r\u0015a!\u0001#\u0002\u000e\u0005=\tV/Z;fS:<\u0007*\u00198eY\u0016\u00148cA\u0006\u000f-A\u0011q\u0002F\u0007\u0002!)\u0011\u0011CE\u0001\u0005Y\u0006twMC\u0001\u0014\u0003\u0011Q\u0017M^1\n\u0005U\u0001\"AB(cU\u0016\u001cG\u000f\u0005\u0002\u001855\t\u0001DC\u0001\u001a\u0003\u0015\u00198-\u00197b\u0013\tY\u0002DA\u0006TG\u0006d\u0017m\u00142kK\u000e$\b\"B\u000f\f\t\u0003q\u0012A\u0002\u001fj]&$h\bF\u0001\n\u0011\u0015\u00013\u0002\"\u0001\"\u0003\u0015\t\u0007\u000f\u001d7z)\r\u0011so \t\u0004/\r*\u0013B\u0001\u0013\u0019\u0005%1UO\\2uS>t\u0007\u0007\u0005\u0002\u000bM\u0019!AB\u0001\u0001('\r1\u0003F\u0006\t\u0003\u0015%J!A\u000b\u0002\u0003\u000f!\u000bg\u000e\u001a7fe\"AAF\nBC\u0002\u0013\u0005Q&A\u0004iC:$G.\u001a:\u0016\u0003!B\u0001b\f\u0014\u0003\u0002\u0003\u0006I\u0001K\u0001\tQ\u0006tG\r\\3sA!A\u0011G\nB\u0001B\u0003%!'\u0001\u0007nCb\fV/Z;f'&TX\r\u0005\u0002\u0018g%\u0011A\u0007\u0007\u0002\u0004\u0013:$\b\"B\u000f'\t\u00031DcA\u00138q!)A&\u000ea\u0001Q!9\u0011'\u000eI\u0001\u0002\u0004\u0011\u0004b\u0002\u001e'\u0005\u0004%\tbO\u0001\fIJ|\u0007\u000fT8h\u001d>$W-F\u0001=!\ti\u0004I\u0004\u0002\u0018}%\u0011q\bG\u0001\u0007!J,G-\u001a4\n\u0005\u0005\u0013%AB*ue&twM\u0003\u0002@1!1AI\nQ\u0001\nq\nA\u0002\u001a:pa2{wMT8eK\u0002BqA\u0012\u0014C\u0002\u0013Eq)A\u0002m_\u001e,\u0012\u0001\u0013\t\u0003\u0015%K!A\u0013\u0002\u0003\r1{wmZ3s\u0011\u0019ae\u0005)A\u0005\u0011\u0006!An\\4!\u0011\u0019qe\u0005)A\u0005\u001f\u0006)\u0011/^3vKB\u0019\u0001+V,\u000e\u0003ES!AU*\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002U%\u0005!Q\u000f^5m\u0013\t1\u0016KA\nMS:\\W\r\u001a\"m_\u000e\\\u0017N\\4Rk\u0016,X\r\u0005\u0002Y56\t\u0011L\u0003\u0002\u0004'&\u00111,\u0017\u0002\n\u0019><'+Z2pe\u0012Da!\u0018\u0014!\u0002\u0013q\u0016A\u0002;ie\u0016\fG\r\u0005\u0002\u0010?&\u0011\u0001\r\u0005\u0002\u0007)\"\u0014X-\u00193\t\r\t4\u0003\u0015!\u0003d\u0003)\u0019Gn\\:f\u0019\u0006$8\r\u001b\t\u0003!\u0012L!!Z)\u0003\u001d\r{WO\u001c;E_^tG*\u0019;dQ\")qM\nC\u0001Q\u00069\u0001/\u001e2mSNDGCA5m!\t9\".\u0003\u0002l1\t!QK\\5u\u0011\u0015ig\r1\u0001X\u0003\u0019\u0011XmY8sI\")qN\nC\u0001a\u0006)1\r\\8tKR\t\u0011\u000eC\u0003sM\u0011\u0005\u0001/A\u0003gYV\u001c\b\u000eC\u0003uM\u0011EQ/\u0001\u0006p]>3XM\u001d4m_^$\"!\u001b<\t\u000b5\u001c\b\u0019A,\t\u000b1z\u0002\u0019\u0001=\u0011\u0005edhB\u0001\u0006{\u0013\tY(!A\u0004qC\u000e\\\u0017mZ3\n\u0005ut(A\u0004%b]\u0012dWM\u001d$bGR|'/\u001f\u0006\u0003w\nAq!M\u0010\u0011\u0002\u0003\u0007!\u0007C\u0005\u0002\u0004-\t\n\u0011\"\u0001\u0002\u0006\u0005q\u0011N\\5uI\u0011,g-Y;mi\u0012\u0012TCAA\u0004U\r\u0011\u0014\u0011B\u0016\u0003\u0003\u0017\u0001B!!\u0004\u0002\u00185\u0011\u0011q\u0002\u0006\u0005\u0003#\t\u0019\"A\u0005v]\u000eDWmY6fI*\u0019\u0011Q\u0003\r\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\u001a\u0005=!!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"I\u0011QD\u0006\u0012\u0002\u0013\u0005\u0011QA\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%e\u0001")
public class QueueingHandler
extends Handler
implements ScalaObject {
    private final Handler handler;
    private final String dropLogNode;
    private final Logger log;
    public final LinkedBlockingQueue<LogRecord> com$twitter$logging$QueueingHandler$$queue;
    private final Thread thread;
    public final CountDownLatch com$twitter$logging$QueueingHandler$$closeLatch;

    public static final int apply$default$2() {
        return QueueingHandler$.MODULE$.apply$default$2();
    }

    public static final int init$default$2() {
        return QueueingHandler$.MODULE$.init$default$2();
    }

    public static final Function0<QueueingHandler> apply(Function0<Handler> function0, int n) {
        return QueueingHandler$.MODULE$.apply(function0, n);
    }

    public Handler handler() {
        return this.handler;
    }

    public String dropLogNode() {
        return this.dropLogNode;
    }

    public Logger log() {
        return this.log;
    }

    @Override
    public void publish(LogRecord record) {
        if (!this.com$twitter$logging$QueueingHandler$$queue.offer(record)) {
            this.onOverflow(record);
        }
    }

    @Override
    public void close() {
        this.thread.interrupt();
        this.com$twitter$logging$QueueingHandler$$closeLatch.await();
        this.handler().close();
    }

    @Override
    public void flush() {
        LogRecord record = this.com$twitter$logging$QueueingHandler$$queue.poll();
        while (record != null) {
            this.handler().publish(record);
            record = this.com$twitter$logging$QueueingHandler$$queue.poll();
        }
        this.handler().flush();
    }

    public void onOverflow(LogRecord record) {
        Console$.MODULE$.err().println(String.format("[%s] log queue overflow - record dropped", Time$.MODULE$.now().toString()));
    }

    public QueueingHandler(Handler handler, int maxQueueSize) {
        this.handler = handler;
        super(handler.formatter(), handler.level());
        this.dropLogNode = "";
        this.log = Logger$.MODULE$.apply(this.dropLogNode());
        this.com$twitter$logging$QueueingHandler$$queue = new LinkedBlockingQueue(maxQueueSize);
        this.thread = new $anon$1(this);
        this.com$twitter$logging$QueueingHandler$$closeLatch = new CountDownLatch(1);
        this.thread.setDaemon(true);
        this.thread.start();
    }
}

