/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.logging;

import com.twitter.logging.Handler;
import com.twitter.logging.Logger;
import com.twitter.logging.Logger$;
import com.twitter.logging.QueueingHandler$;
import com.twitter.util.Time$;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.LogRecord;
import scala.Console$;
import scala.Function0;
import scala.ScalaObject;
import scala.reflect.ScalaSignature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001\u0005\u0015r!B\u0001\u0003\u0011\u000bI\u0011aD)vKV,\u0017N\\4IC:$G.\u001a:\u000b\u0005\r!\u0011a\u00027pO\u001eLgn\u001a\u0006\u0003\u000b\u0019\tq\u0001^<jiR,'OC\u0001\b\u0003\r\u0019w.\\\u0002\u0001!\tQ1\"D\u0001\u0003\r\u0015a!\u0001#\u0002\u000e\u0005=\tV/Z;fS:<\u0007*\u00198eY\u0016\u00148cA\u0006\u000f-A\u0011q\u0002F\u0007\u0002!)\u0011\u0011CE\u0001\u0005Y\u0006twMC\u0001\u0014\u0003\u0011Q\u0017M^1\n\u0005U\u0001\"AB(cU\u0016\u001cG\u000f\u0005\u0002\u001855\t\u0001DC\u0001\u001a\u0003\u0015\u00198-\u00197b\u0013\tY\u0002DA\u0006TG\u0006d\u0017m\u00142kK\u000e$\b\"B\u000f\f\t\u0003q\u0012A\u0002\u001fj]&$h\bF\u0001\n\u0011\u0015\u00013\u0002\"\u0001\"\u0003\u0015\t\u0007\u000f\u001d7z)\u0011\u0011#0!\u0002\u0011\u0007]\u0019S%\u0003\u0002%1\tIa)\u001e8di&|g\u000e\r\t\u0003\u0015\u00192A\u0001\u0004\u0002\u0001OM\u0019a\u0005\u000b\f\u0011\u0005)I\u0013B\u0001\u0016\u0003\u0005\u001dA\u0015M\u001c3mKJD\u0001\u0002\f\u0014\u0003\u0006\u0004%\t!L\u0001\bQ\u0006tG\r\\3s+\u0005A\u0003\u0002C\u0018'\u0005\u0003\u0005\u000b\u0011\u0002\u0015\u0002\u0011!\fg\u000e\u001a7fe\u0002B\u0001\"\r\u0014\u0003\u0006\u0004%\tAM\u0001\r[\u0006D\u0018+^3vKNK'0Z\u000b\u0002gA\u0011q\u0003N\u0005\u0003ka\u00111!\u00138u\u0011!9dE!A!\u0002\u0013\u0019\u0014!D7bqF+X-^3TSj,\u0007\u0005C\u0003\u001eM\u0011\u0005\u0011\bF\u0002&umBQ\u0001\f\u001dA\u0002!Bq!\r\u001d\u0011\u0002\u0003\u00071\u0007C\u0004>M\t\u0007I\u0011\u0003 \u0002\u0017\u0011\u0014x\u000e\u001d'pO:{G-Z\u000b\u0002\u007fA\u0011\u0001i\u0011\b\u0003/\u0005K!A\u0011\r\u0002\rA\u0013X\rZ3g\u0013\t!UI\u0001\u0004TiJLgn\u001a\u0006\u0003\u0005bAaa\u0012\u0014!\u0002\u0013y\u0014\u0001\u00043s_Bdun\u001a(pI\u0016\u0004\u0003bB%'\u0005\u0004%\tBS\u0001\u0004Y><W#A&\u0011\u0005)a\u0015BA'\u0003\u0005\u0019aunZ4fe\"1qJ\nQ\u0001\n-\u000bA\u0001\\8hA!1\u0011K\nQ\u0001\nI\u000bQ!];fk\u0016\u00042a\u0015-[\u001b\u0005!&BA+W\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003/J\tA!\u001e;jY&\u0011\u0011\f\u0016\u0002\u0014\u0019&t7.\u001a3CY>\u001c7.\u001b8h#V,W/\u001a\t\u00037vk\u0011\u0001\u0018\u0006\u0003\u0007YK!A\u0018/\u0003\u00131{wMU3d_J$\u0007B\u00021'A\u0003%\u0011-\u0001\u0004uQJ,\u0017\r\u001a\t\u0003\u001f\tL!a\u0019\t\u0003\rQC'/Z1e\u0011\u0019)g\u0005)A\u0005M\u0006Q1\r\\8tK2\u000bGo\u00195\u0011\u0005M;\u0017B\u00015U\u00059\u0019u.\u001e8u\t><h\u000eT1uG\"DQA\u001b\u0014\u0005\u0002-\fq\u0001];cY&\u001c\b\u000e\u0006\u0002m_B\u0011q#\\\u0005\u0003]b\u0011A!\u00168ji\")\u0001/\u001ba\u00015\u00061!/Z2pe\u0012DQA\u001d\u0014\u0005\u0002M\fQa\u00197pg\u0016$\u0012\u0001\u001c\u0005\u0006k\u001a\"\ta]\u0001\u0006M2,8\u000f\u001b\u0005\u0006o\u001a\"\t\u0002_\u0001\u000b_:|e/\u001a:gY><HC\u00017z\u0011\u0015\u0001h\u000f1\u0001[\u0011\u0015as\u00041\u0001|!\taxP\u0004\u0002\u000b{&\u0011aPA\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t\t!a\u0001\u0003\u001d!\u000bg\u000e\u001a7fe\u001a\u000b7\r^8ss*\u0011aP\u0001\u0005\bc}\u0001\n\u00111\u00014\u0011%\tIaCI\u0001\n\u0003\tY!\u0001\bj]&$H\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u00055!fA\u001a\u0002\u0010-\u0012\u0011\u0011\u0003\t\u0005\u0003'\ti\"\u0004\u0002\u0002\u0016)!\u0011qCA\r\u0003%)hn\u00195fG.,GMC\u0002\u0002\u001ca\t!\"\u00198o_R\fG/[8o\u0013\u0011\ty\"!\u0006\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rC\u0005\u0002$-\t\n\u0011\"\u0001\u0002\f\u0005y\u0011\r\u001d9ms\u0012\"WMZ1vYR$#\u0007")
public class QueueingHandler
extends Handler
implements ScalaObject {
    private final Handler handler;
    private final int maxQueueSize;
    private final String dropLogNode;
    private final Logger log;
    public final LinkedBlockingQueue<LogRecord> com$twitter$logging$QueueingHandler$$queue;
    private final Thread thread;
    public final CountDownLatch com$twitter$logging$QueueingHandler$$closeLatch;

    public static final int apply$default$2() {
        return QueueingHandler$.MODULE$.apply$default$2();
    }

    public static final int init$default$2() {
        return QueueingHandler$.MODULE$.init$default$2();
    }

    public static final Function0<QueueingHandler> apply(Function0<Handler> function0, int n) {
        return QueueingHandler$.MODULE$.apply(function0, n);
    }

    public Handler handler() {
        return this.handler;
    }

    public int maxQueueSize() {
        return this.maxQueueSize;
    }

    public String dropLogNode() {
        return this.dropLogNode;
    }

    public Logger log() {
        return this.log;
    }

    @Override
    public void publish(LogRecord record) {
        if (!this.com$twitter$logging$QueueingHandler$$queue.offer(record)) {
            this.onOverflow(record);
        }
    }

    @Override
    public void close() {
        this.thread.interrupt();
        this.com$twitter$logging$QueueingHandler$$closeLatch.await();
        this.handler().close();
    }

    @Override
    public void flush() {
        LogRecord record = this.com$twitter$logging$QueueingHandler$$queue.poll();
        while (record != null) {
            this.handler().publish(record);
            record = this.com$twitter$logging$QueueingHandler$$queue.poll();
        }
        this.handler().flush();
    }

    public void onOverflow(LogRecord record) {
        Console$.MODULE$.err().println(String.format("[%s] log queue overflow - record dropped", Time$.MODULE$.now().toString()));
    }

    public QueueingHandler(Handler handler, int maxQueueSize) {
        this.handler = handler;
        this.maxQueueSize = maxQueueSize;
        super(handler.formatter(), handler.level());
        this.dropLogNode = "";
        this.log = Logger$.MODULE$.apply(this.dropLogNode());
        this.com$twitter$logging$QueueingHandler$$queue = new LinkedBlockingQueue(maxQueueSize);
        this.thread = new $anon$1(this);
        this.com$twitter$logging$QueueingHandler$$closeLatch = new CountDownLatch(1);
        this.thread.setDaemon(true);
        this.thread.setName("QueueingHandler");
        this.thread.start();
    }
}

