/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.logging;

import com.twitter.concurrent.NamedPoolThreadFactory;
import com.twitter.conversions.string$;
import com.twitter.finagle.stats.Counter;
import com.twitter.finagle.stats.Gauge;
import com.twitter.finagle.stats.NullStatsReceiver$;
import com.twitter.finagle.stats.StatsReceiver;
import com.twitter.logging.Formatter;
import com.twitter.logging.Handler;
import com.twitter.logging.Level;
import com.twitter.logging.Logger;
import com.twitter.logging.ScribeHandler$;
import com.twitter.logging.ScribeHandler$Archaic$;
import com.twitter.logging.ScribeHandler$Modern$;
import com.twitter.logging.ScribeHandler$Unknown$;
import com.twitter.util.Duration;
import com.twitter.util.Time;
import com.twitter.util.Time$;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.LogRecord;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0011%u!B\u0001\u0003\u0011\u0003I\u0011!D*de&\u0014W\rS1oI2,'O\u0003\u0002\u0004\t\u00059An\\4hS:<'BA\u0003\u0007\u0003\u001d!x/\u001b;uKJT\u0011aB\u0001\u0004G>l7\u0001\u0001\t\u0003\u0015-i\u0011A\u0001\u0004\u0006\u0019\tA\t!\u0004\u0002\u000e'\u000e\u0014\u0018NY3IC:$G.\u001a:\u0014\u0005-q\u0001CA\b\u0013\u001b\u0005\u0001\"\"A\t\u0002\u000bM\u001c\u0017\r\\1\n\u0005M\u0001\"AB!osJ+g\rC\u0003\u0016\u0017\u0011\u0005a#\u0001\u0004=S:LGO\u0010\u000b\u0002\u0013\u00199\u0001d\u0003I\u0001$SI\"AC*feZ,'\u000fV=qKN\u0011qCD\u0015\u0005/mq\u0006OB\u0003\u001d\u0017!%UDA\u0004Be\u000eD\u0017-[2\u0014\u000bmqa\u0004I\u0012\u0011\u0005}9R\"A\u0006\u0011\u0005=\t\u0013B\u0001\u0012\u0011\u0005\u001d\u0001&o\u001c3vGR\u0004\"a\u0004\u0013\n\u0005\u0015\u0002\"\u0001D*fe&\fG.\u001b>bE2,\u0007\"B\u000b\u001c\t\u00039C#\u0001\u0015\u0011\u0005}Y\u0002b\u0002\u0016\u001c\u0003\u0003%\teK\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u00031\u0002\"!\f\u001a\u000e\u00039R!a\f\u0019\u0002\t1\fgn\u001a\u0006\u0002c\u0005!!.\u0019<b\u0013\t\u0019dF\u0001\u0004TiJLgn\u001a\u0005\bkm\t\t\u0011\"\u00017\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\u00059\u0004CA\b9\u0013\tI\u0004CA\u0002J]RDqaO\u000e\u0002\u0002\u0013\u0005A(\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\u0005u\u0002\u0005CA\b?\u0013\ty\u0004CA\u0002B]fDq!\u0011\u001e\u0002\u0002\u0003\u0007q'A\u0002yIEBqaQ\u000e\u0002\u0002\u0013\u0005C)A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\u0005)\u0005c\u0001$J{5\tqI\u0003\u0002I!\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005);%\u0001C%uKJ\fGo\u001c:\t\u000f1[\u0012\u0011!C\u0001\u001b\u0006A1-\u00198FcV\fG\u000e\u0006\u0002O#B\u0011qbT\u0005\u0003!B\u0011qAQ8pY\u0016\fg\u000eC\u0004B\u0017\u0006\u0005\t\u0019A\u001f\t\u000fM[\u0012\u0011!C!)\u0006A\u0001.Y:i\u0007>$W\rF\u00018\u0011\u001d16$!A\u0005B]\u000b\u0001\u0002^8TiJLgn\u001a\u000b\u0002Y!9\u0011lGA\u0001\n\u0013Q\u0016a\u0003:fC\u0012\u0014Vm]8mm\u0016$\u0012a\u0017\t\u0003[qK!!\u0018\u0018\u0003\r=\u0013'.Z2u\r\u0015y6\u0002##a\u0005\u0019iu\u000eZ3s]N)aL\u0004\u0010!G!)QC\u0018C\u0001ER\t1\r\u0005\u0002 =\"9!FXA\u0001\n\u0003Z\u0003bB\u001b_\u0003\u0003%\tA\u000e\u0005\bwy\u000b\t\u0011\"\u0001h)\ti\u0004\u000eC\u0004BM\u0006\u0005\t\u0019A\u001c\t\u000f\rs\u0016\u0011!C!\t\"9AJXA\u0001\n\u0003YGC\u0001(m\u0011\u001d\t%.!AA\u0002uBqa\u00150\u0002\u0002\u0013\u0005C\u000bC\u0004W=\u0006\u0005I\u0011I,\t\u000fes\u0016\u0011!C\u00055\u001a)\u0011o\u0003EEe\n9QK\\6o_^t7#\u00029\u000f=\u0001\u001a\u0003\"B\u000bq\t\u0003!H#A;\u0011\u0005}\u0001\bb\u0002\u0016q\u0003\u0003%\te\u000b\u0005\bkA\f\t\u0011\"\u00017\u0011\u001dY\u0004/!A\u0005\u0002e$\"!\u0010>\t\u000f\u0005C\u0018\u0011!a\u0001o!91\t]A\u0001\n\u0003\"\u0005b\u0002'q\u0003\u0003%\t! \u000b\u0003\u001dzDq!\u0011?\u0002\u0002\u0003\u0007Q\bC\u0004Ta\u0006\u0005I\u0011\t+\t\u000fY\u0003\u0018\u0011!C!/\"9\u0011\f]A\u0001\n\u0013QvABA\u0004\u0017!%U/A\u0004V].twn\u001e8\b\r\u0005-1\u0002##)\u0003\u001d\t%o\u00195bS\u000e<a!a\u0004\f\u0011\u0013\u001b\u0017AB'pI\u0016\u0014h\u000e\u0003\u0005\u0002\u0014-\u0011\r\u0011\"\u00017\u0003\ty5\nC\u0004\u0002\u0018-\u0001\u000b\u0011B\u001c\u0002\u0007=[\u0005\u0005\u0003\u0005\u0002\u001c-\u0011\r\u0011\"\u00017\u0003%!&+W0M\u0003R+%\u000bC\u0004\u0002 -\u0001\u000b\u0011B\u001c\u0002\u0015Q\u0013\u0016l\u0018'B)\u0016\u0013\u0006\u0005\u0003\u0005\u0002$-\u0011\r\u0011\"\u0001,\u0003=!UMZ1vYRDun\u001d;oC6,\u0007bBA\u0014\u0017\u0001\u0006I\u0001L\u0001\u0011\t\u00164\u0017-\u001e7u\u0011>\u001cHO\\1nK\u0002B\u0001\"a\u000b\f\u0005\u0004%\tAN\u0001\f\t\u00164\u0017-\u001e7u!>\u0014H\u000fC\u0004\u00020-\u0001\u000b\u0011B\u001c\u0002\u0019\u0011+g-Y;miB{'\u000f\u001e\u0011\t\u0011\u0005M2B1A\u0005\u0002-\nq\u0002R3gCVdGoQ1uK\u001e|'/\u001f\u0005\b\u0003oY\u0001\u0015!\u0003-\u0003A!UMZ1vYR\u001c\u0015\r^3h_JL\b\u0005C\u0005\u0002<-\u0011\r\u0011\"\u0001\u0002>\u0005\tB)\u001a4bk2$()\u001e4gKJ$\u0016.\\3\u0016\u0005\u0005}\u0002\u0003BA!\u0003\u000fj!!a\u0011\u000b\u0007\u0005\u0015C!\u0001\u0003vi&d\u0017\u0002BA%\u0003\u0007\u0012\u0001\u0002R;sCRLwN\u001c\u0005\t\u0003\u001bZ\u0001\u0015!\u0003\u0002@\u0005\u0011B)\u001a4bk2$()\u001e4gKJ$\u0016.\\3!\u0011%\t\tf\u0003b\u0001\n\u0003\ti$A\u000bEK\u001a\fW\u000f\u001c;D_:tWm\u0019;CC\u000e\\wN\u001a4\t\u0011\u0005U3\u0002)A\u0005\u0003\u007f\ta\u0003R3gCVdGoQ8o]\u0016\u001cGOQ1dW>4g\r\t\u0005\t\u00033Z!\u0019!C\u0001m\u0005\u0001C)\u001a4bk2$X*\u0019=NKN\u001c\u0018mZ3t!\u0016\u0014HK]1og\u0006\u001cG/[8o\u0011\u001d\tif\u0003Q\u0001\n]\n\u0011\u0005R3gCVdG/T1y\u001b\u0016\u001c8/Y4fgB+'\u000f\u0016:b]N\f7\r^5p]\u0002B\u0001\"!\u0019\f\u0005\u0004%\tAN\u0001\u001b\t\u00164\u0017-\u001e7u\u001b\u0006DX*Z:tC\u001e,7\u000fV8Ck\u001a4WM\u001d\u0005\b\u0003KZ\u0001\u0015!\u00038\u0003m!UMZ1vYRl\u0015\r_'fgN\fw-Z:U_\n+hMZ3sA!I\u0011\u0011N\u0006C\u0002\u0013\u0005\u0011QH\u0001\u0019\t\u00164\u0017-\u001e7u'R\fGo\u001d*fa>\u0014H\u000fU3sS>$\u0007\u0002CA7\u0017\u0001\u0006I!a\u0010\u00023\u0011+g-Y;miN#\u0018\r^:SKB|'\u000f\u001e)fe&|G\r\t\u0005\n\u0003cZ!\u0019!C\u0001\u0003g\n1\u0001\\8h+\t\t)\bE\u0002\u000b\u0003oJ1!!\u001f\u0003\u0005\u0019aunZ4fe\"A\u0011QP\u0006!\u0002\u0013\t)(\u0001\u0003m_\u001e\u0004\u0003bBAA\u0017\u0011\u0005\u00111Q\u0001\u0006CB\u0004H.\u001f\u000b\u0017\u0003\u000b#\u0019\u0003\"\n\u0005(\u0011%B1\u0006C\u0017\t_!\t\u0004b\r\u00056A)q\"a\"\u0002\f&\u0019\u0011\u0011\u0012\t\u0003\u0013\u0019+hn\u0019;j_:\u0004\u0004c\u0001\u0006\u0002\u000e\u001a)AB\u0001\u0001\u0002\u0010N!\u0011QRAI!\rQ\u00111S\u0005\u0004\u0003+\u0013!a\u0002%b]\u0012dWM\u001d\u0005\f\u00033\u000biI!A!\u0002\u0013\tY*\u0001\u0005i_N$h.Y7f!\u0011\ti*a+\u000f\t\u0005}\u0015q\u0015\t\u0004\u0003C\u0003RBAAR\u0015\r\t)\u000bC\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005%\u0006#\u0001\u0004Qe\u0016$WMZ\u0005\u0004g\u00055&bAAU!!Q\u0011\u0011WAG\u0005\u0003\u0005\u000b\u0011B\u001c\u0002\tA|'\u000f\u001e\u0005\f\u0003k\u000biI!A!\u0002\u0013\tY*\u0001\u0005dCR,wm\u001c:z\u0011-\tI,!$\u0003\u0002\u0003\u0006I!a\u0010\u0002\u0015\t,hMZ3s)&lW\rC\u0006\u0002>\u00065%\u0011!Q\u0001\n\u0005}\u0012AD2p]:,7\r\u001e\"bG.|gM\u001a\u0005\u000b\u0003\u0003\fiI!A!\u0002\u00139\u0014!G7bq6+7o]1hKN\u0004VM\u001d+sC:\u001c\u0018m\u0019;j_:D!\"!2\u0002\u000e\n\u0005\t\u0015!\u00038\u0003Mi\u0017\r_'fgN\fw-Z:U_\n+hMZ3s\u00115\tI-!$\u0003\u0002\u0003\u0006I!a3\u0002R\u0006Iam\u001c:nCR$XM\u001d\t\u0004\u0015\u00055\u0017bAAh\u0005\tIai\u001c:nCR$XM]\u0005\u0005\u0003\u0013\f\u0019\nC\u0007\u0002V\u00065%\u0011!Q\u0001\n\u0005]\u00171]\u0001\u0006Y\u00164X\r\u001c\t\u0006\u001f\u0005e\u0017Q\\\u0005\u0004\u00037\u0004\"AB(qi&|g\u000eE\u0002\u000b\u0003?L1!!9\u0003\u0005\u0015aUM^3m\u0013\u0011\t).a%\t\u0017\u0005\u001d\u0018Q\u0012B\u0001B\u0003%\u0011\u0011^\u0001\u000egR\fGo\u001d*fG\u0016Lg/\u001a:\u0011\t\u0005-\u0018Q_\u0007\u0003\u0003[TA!a<\u0002r\u0006)1\u000f^1ug*\u0019\u00111\u001f\u0003\u0002\u000f\u0019Lg.Y4mK&!\u0011q_Aw\u00055\u0019F/\u0019;t%\u0016\u001cW-\u001b<fe\"9Q#!$\u0005\u0002\u0005mHCFAF\u0003{\fyP!\u0001\u0003\u0004\t\u0015!q\u0001B\u0005\u0005\u0017\u0011iAa\u0004\t\u0011\u0005e\u0015\u0011 a\u0001\u00037Cq!!-\u0002z\u0002\u0007q\u0007\u0003\u0005\u00026\u0006e\b\u0019AAN\u0011!\tI,!?A\u0002\u0005}\u0002\u0002CA_\u0003s\u0004\r!a\u0010\t\u000f\u0005\u0005\u0017\u0011 a\u0001o!9\u0011QYA}\u0001\u00049\u0004\u0002CAe\u0003s\u0004\r!a3\t\u0011\u0005U\u0017\u0011 a\u0001\u0003/D\u0001\"a:\u0002z\u0002\u0007\u0011\u0011\u001e\u0005\b+\u00055E\u0011\u0001B\n)Q\tYI!\u0006\u0003\u0018\te!1\u0004B\u000f\u0005?\u0011\tCa\t\u0003&!A\u0011\u0011\u0014B\t\u0001\u0004\tY\nC\u0004\u00022\nE\u0001\u0019A\u001c\t\u0011\u0005U&\u0011\u0003a\u0001\u00037C\u0001\"!/\u0003\u0012\u0001\u0007\u0011q\b\u0005\t\u0003{\u0013\t\u00021\u0001\u0002@!9\u0011\u0011\u0019B\t\u0001\u00049\u0004bBAc\u0005#\u0001\ra\u000e\u0005\t\u0003\u0013\u0014\t\u00021\u0001\u0002L\"A\u0011Q\u001bB\t\u0001\u0004\t9\u000eC\u0005\u0002p\u00065\u0005\u0015!\u0003\u0003*A!!1\u0006B\u0017\u001b\t\tiIB\u0004\u00030\u00055EA!\r\u0003%M\u001b'/\u001b2f\u0011\u0006tG\r\\3s'R\fGo]\n\u0004\u0005[q\u0001bCAt\u0005[\u0011\t\u0011)A\u0005\u0003SDq!\u0006B\u0017\t\u0003\u00119\u0004\u0006\u0003\u0003*\te\u0002\u0002CAt\u0005k\u0001\r!!;\t\u0015\tu\"Q\u0006a\u0001\n\u0013\u0011y$A\u0007`Y\u0006\u001cH\u000fT8h'R\fGo]\u000b\u0003\u0005\u0003\u0002B!!\u0011\u0003D%!!QIA\"\u0005\u0011!\u0016.\\3\t\u0015\t%#Q\u0006a\u0001\n\u0013\u0011Y%A\t`Y\u0006\u001cH\u000fT8h'R\fGo]0%KF$BA!\u0014\u0003TA\u0019qBa\u0014\n\u0007\tE\u0003C\u0001\u0003V]&$\b\"C!\u0003H\u0005\u0005\t\u0019\u0001B!\u0011%\u00119F!\f!B\u0013\u0011\t%\u0001\b`Y\u0006\u001cH\u000fT8h'R\fGo\u001d\u0011\t\u0015\tm#Q\u0006b\u0001\n\u0013\u0011i&A\u0006tK:$(+Z2pe\u0012\u001cXC\u0001B0!\u0011\u0011\tG!\u001c\u000e\u0005\t\r$\u0002\u0002B3\u0005O\na!\u0019;p[&\u001c'\u0002\u0002B5\u0005W\n!bY8oGV\u0014(/\u001a8u\u0015\r\t)\u0005M\u0005\u0005\u0005_\u0012\u0019G\u0001\u0006Bi>l\u0017n\u0019'p]\u001eD\u0011Ba\u001d\u0003.\u0001\u0006IAa\u0018\u0002\u0019M,g\u000e\u001e*fG>\u0014Hm\u001d\u0011\t\u0015\t]$Q\u0006b\u0001\n\u0013\u0011i&\u0001\bee>\u0004\b/\u001a3SK\u000e|'\u000fZ:\t\u0013\tm$Q\u0006Q\u0001\n\t}\u0013a\u00043s_B\u0004X\r\u001a*fG>\u0014Hm\u001d\u0011\t\u0015\t}$Q\u0006b\u0001\n\u0013\u0011i&A\td_:tWm\u0019;j_:4\u0015-\u001b7ve\u0016D\u0011Ba!\u0003.\u0001\u0006IAa\u0018\u0002%\r|gN\\3di&|gNR1jYV\u0014X\r\t\u0005\u000b\u0005\u000f\u0013iC1A\u0005\n\tu\u0013!E2p]:,7\r^5p]N[\u0017\u000e\u001d9fI\"I!1\u0012B\u0017A\u0003%!qL\u0001\u0013G>tg.Z2uS>t7k[5qa\u0016$\u0007\u0005\u0003\u0006\u0003\u0010\n5\"\u0019!C\u0001\u0005#\u000b\u0001\u0003^8uC2\u001cVM\u001c;SK\u000e|'\u000fZ:\u0016\u0005\tM\u0005\u0003BAv\u0005+KAAa&\u0002n\n91i\\;oi\u0016\u0014\b\"\u0003BN\u0005[\u0001\u000b\u0011\u0002BJ\u0003E!x\u000e^1m'\u0016tGOU3d_J$7\u000f\t\u0005\u000b\u0005?\u0013iC1A\u0005\u0002\tE\u0015a\u0005;pi\u0006dGI]8qa\u0016$'+Z2pe\u0012\u001c\b\"\u0003BR\u0005[\u0001\u000b\u0011\u0002BJ\u0003Q!x\u000e^1m\tJ|\u0007\u000f]3e%\u0016\u001cwN\u001d3tA!Q!q\u0015B\u0017\u0005\u0004%\tA!%\u0002-Q|G/\u00197D_:tWm\u0019;j_:4\u0015-\u001b7ve\u0016D\u0011Ba+\u0003.\u0001\u0006IAa%\u0002/Q|G/\u00197D_:tWm\u0019;j_:4\u0015-\u001b7ve\u0016\u0004\u0003B\u0003BX\u0005[\u0011\r\u0011\"\u0001\u0003\u0012\u00061Bo\u001c;bY\u000e{gN\\3di&|gnU6jaB,G\rC\u0005\u00034\n5\u0002\u0015!\u0003\u0003\u0014\u00069Bo\u001c;bY\u000e{gN\\3di&|gnU6jaB,G\r\t\u0005\u000b\u0005o\u0013iC1A\u0005\u0002\tE\u0015!\u0004;pi\u0006d7i\u001c8oK\u000e$8\u000fC\u0005\u0003<\n5\u0002\u0015!\u0003\u0003\u0014\u0006qAo\u001c;bY\u000e{gN\\3diN\u0004\u0003B\u0003B`\u0005[\u0011\r\u0011\"\u0001\u0003\u0012\u0006qAo\u001c;bYB+(\r\\5tQ\u0016$\u0007\"\u0003Bb\u0005[\u0001\u000b\u0011\u0002BJ\u0003=!x\u000e^1m!V\u0014G.[:iK\u0012\u0004\u0003B\u0003Bd\u0005[\u0011\r\u0011\"\u0001\u0003\u0012\u0006YAo\u001c;bY\u000ecwn]3t\u0011%\u0011YM!\f!\u0002\u0013\u0011\u0019*\u0001\u0007u_R\fGn\u00117pg\u0016\u001c\b\u0005\u0003\u0006\u0003P\n5\"\u0019!C\u0001\u0005#\f\u0011\"\u001b8ti\u0006t7-Z:\u0016\u0005\tM\u0007\u0003BAv\u0005+LAAa6\u0002n\n)q)Y;hK\"I!1\u001cB\u0017A\u0003%!1[\u0001\u000bS:\u001cH/\u00198dKN\u0004\u0003B\u0003Bp\u0005[\u0011\r\u0011\"\u0001\u0003R\u0006YQO\\:f]R\fV/Z;f\u0011%\u0011\u0019O!\f!\u0002\u0013\u0011\u0019.\u0001\u0007v]N,g\u000e^)vKV,\u0007\u0005\u0003\u0005\u0003h\n5B\u0011\u0001Bu\u0003=Ign\u0019:TK:$(+Z2pe\u0012\u001cH\u0003\u0002B'\u0005WDqA!<\u0003f\u0002\u0007q'A\u0003d_VtG\u000f\u0003\u0005\u0003r\n5B\u0011\u0001Bz\u0003IIgn\u0019:Ee>\u0004\b/\u001a3SK\u000e|'\u000fZ:\u0015\t\t5#Q\u001f\u0005\n\u0005[\u0014y\u000f%AA\u0002]B\u0001B!?\u0003.\u0011\u0005!1`\u0001\u0016S:\u001c'oQ8o]\u0016\u001cG/[8o\r\u0006LG.\u001e:f)\t\u0011i\u0005\u0003\u0005\u0003\u0000\n5B\u0011\u0001B~\u0003UIgn\u0019:D_:tWm\u0019;j_:\u001c6.\u001b9qK\u0012D\u0001ba\u0001\u0003.\u0011\u0005!1`\u0001\u000eS:\u001c'\u000fU;cY&\u001c\b.\u001a3\t\u0011\r\u001d!Q\u0006C\u0001\u0005w\fa\"\u001b8de\u000e{gN\\3di&|g\u000e\u0003\u0005\u0004\f\t5B\u0011\u0001B~\u0003)Ign\u0019:DY>\u001cXm\u001d\u0005\t\u0003c\u0012i\u0003\"\u0001\u0003|\"Q1\u0011\u0003B\u0017#\u0003%\taa\u0005\u00029%t7M\u001d#s_B\u0004X\r\u001a*fG>\u0014Hm\u001d\u0013eK\u001a\fW\u000f\u001c;%cU\u00111Q\u0003\u0016\u0004o\r]1FAB\r!\u0011\u0019Yb!\n\u000e\u0005\ru!\u0002BB\u0010\u0007C\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\r\r\u0002#\u0001\u0006b]:|G/\u0019;j_:LAaa\n\u0004\u001e\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0013\r-\u0012Q\u0012b\u0001\n\u0013Y\u0013A\u00037pO\u001e,'OT1nK\"A1qFAGA\u0003%A&A\u0006m_\u001e<WM\u001d(b[\u0016\u0004\u0003BCB\u001a\u0003\u001b\u0003\r\u0011\"\u0003\u0003@\u0005\u0011B.Y:u\u0007>tg.Z2u\u0003R$X-\u001c9u\u0011)\u00199$!$A\u0002\u0013%1\u0011H\u0001\u0017Y\u0006\u001cHoQ8o]\u0016\u001cG/\u0011;uK6\u0004Ho\u0018\u0013fcR!!QJB\u001e\u0011%\t5QGA\u0001\u0002\u0004\u0011\t\u0005C\u0005\u0004@\u00055\u0005\u0015)\u0003\u0003B\u0005\u0019B.Y:u\u0007>tg.Z2u\u0003R$X-\u001c9uA!Q11IAG\u0001\u0004%IAa\u0010\u0002#}c\u0017m\u001d;Ue\u0006t7/\\5tg&|g\u000e\u0003\u0006\u0004H\u00055\u0005\u0019!C\u0005\u0007\u0013\nQc\u00187bgR$&/\u00198t[&\u001c8/[8o?\u0012*\u0017\u000f\u0006\u0003\u0003N\r-\u0003\"C!\u0004F\u0005\u0005\t\u0019\u0001B!\u0011%\u0019y%!$!B\u0013\u0011\t%\u0001\n`Y\u0006\u001cH\u000f\u0016:b]Nl\u0017n]:j_:\u0004\u0003\u0006BB'\u0007'\u00022aDB+\u0013\r\u00199\u0006\u0005\u0002\tm>d\u0017\r^5mK\"I11LAG\t\u0003\u0011!1`\u0001\u0017kB$\u0017\r^3MCN$HK]1og6L7o]5p]\"Q1qLAG\u0001\u0004%Ia!\u0019\u0002\rM|7m[3u+\t\u0019\u0019\u0007E\u0003\u0010\u00033\u001c)\u0007\u0005\u0003\u0004h\r5TBAB5\u0015\r\u0019Y\u0007M\u0001\u0004]\u0016$\u0018\u0002BB8\u0007S\u0012aaU8dW\u0016$\bBCB:\u0003\u001b\u0003\r\u0011\"\u0003\u0004v\u0005Q1o\\2lKR|F%Z9\u0015\t\t53q\u000f\u0005\n\u0003\u000eE\u0014\u0011!a\u0001\u0007GB\u0011ba\u001f\u0002\u000e\u0002\u0006Kaa\u0019\u0002\u000fM|7m[3uA!I1qPAG\t\u0003\u00111\u0011Q\u0001\ng\u0016$8k\\2lKR$BA!\u0014\u0004\u0004\"A1QQB?\u0001\u0004\u0019\u0019'A\u0005oK^\u001cvnY6fi\"Q1\u0011RAG\u0001\u0004%Iaa#\u0002\u0015M,'O^3s)f\u0004X-\u0006\u0002\u0004\u000eB\u00191qR\f\u000f\u0005)\u0001\u0001BCBJ\u0003\u001b\u0003\r\u0011\"\u0003\u0004\u0016\u0006q1/\u001a:wKJ$\u0016\u0010]3`I\u0015\fH\u0003\u0002B'\u0007/C\u0011\"QBI\u0003\u0003\u0005\ra!$\t\u0013\rm\u0015Q\u0012Q!\n\r5\u0015aC:feZ,'\u000fV=qK\u0002B\u0001ba(\u0002\u000e\u0012%1\u0011U\u0001\u0010SN\f%o\u00195bS\u000e\u001cVM\u001d<feR\ta\nC\u0006\u0004&\u00065%\u0019!C\u0001\u0005\r\u001d\u0016a\u00024mkNDWM]\u000b\u0003\u0007S\u0003Baa+\u0004.6\u0011!qM\u0005\u0005\u0007_\u00139G\u0001\nUQJ,\u0017\r\u001a)p_2,\u00050Z2vi>\u0014\b\"CBZ\u0003\u001b\u0003\u000b\u0011BBU\u0003!1G.^:iKJ\u0004\u0003bCB\\\u0003\u001b\u0013\r\u0011\"\u0001\u0003\u0007s\u000bQ!];fk\u0016,\"aa/\u0011\r\r-6QXBa\u0013\u0011\u0019yLa\u001a\u0003'1Kgn[3e\u00052|7m[5oOF+X-^3\u0011\u000b=\u0019\u0019ma2\n\u0007\r\u0015\u0007CA\u0003BeJ\f\u0017\u0010E\u0002\u0010\u0007\u0013L1aa3\u0011\u0005\u0011\u0011\u0015\u0010^3\t\u0013\r=\u0017Q\u0012Q\u0001\n\rm\u0016AB9vKV,\u0007\u0005C\u0004\u0004T\u00065E\u0011\u0001\u001c\u0002\u0013E,X-^3TSj,\u0007\u0002CBl\u0003\u001b#\tEa?\u0002\u000b\u0019dWo\u001d5\t\u0013\rm\u0017Q\u0012C\u0001\u0005\ru\u0017AC7bW\u0016\u0014UO\u001a4feR!1q\\Bv!\u0011\u0019\toa:\u000e\u0005\r\r(bABsa\u0005\u0019a.[8\n\t\r%81\u001d\u0002\u000b\u0005f$XMQ;gM\u0016\u0014\bb\u0002Bw\u00073\u0004\ra\u000e\u0005\t\u0007_\fi\t\"\u0003\u0003|\u0006Y1\r\\8tKN{7m[3u\u0011!\u0019\u00190!$\u0005B\tm\u0018!B2m_N,\u0007\u0002CB|\u0003\u001b#\te!?\u0002\u000fA,(\r\\5tQR!!QJB~\u0011!\u0019ip!>A\u0002\r}\u0018A\u0002:fG>\u0014H\r\u0005\u0003\u0005\u0002\u0011\u0015QB\u0001C\u0002\u0015\r\u0019!1N\u0005\u0005\t\u000f!\u0019AA\u0005M_\u001e\u0014VmY8sI\"A1q_AG\t\u0003!Y\u0001\u0006\u0003\u0003N\u00115\u0001\u0002CB\u007f\t\u0013\u0001\ra!1\t\u000fY\u000bi\t\"\u0011\u0005\u0012Q\u0011\u00111\u0014\u0005\n\t+\ti\t)A\u0005\u0007\u0003\fQbU\"S\u0013\n+u\f\u0015*F\r&C\u0006\"\u0003C\r\u0003\u001b\u0003\u000b\u0011BBa\u0003EyE\nR0T\u0007JK%)R0Q%\u00163\u0015\n\u0017\u0005\n\t;\ti\t)A\u0005\u0007\u0003\fAbU\"S\u0013\n+uLU#Q\u0019fC\u0011\u0002\"\t\u0002\u000e\u0002\u0006Ia!1\u0002!=cEiX*D%&\u0013Ui\u0018*F!2K\u0006BCAM\u0003\u007f\u0002\n\u00111\u0001\u0002\u001c\"I\u0011\u0011WA@!\u0003\u0005\ra\u000e\u0005\u000b\u0003k\u000by\b%AA\u0002\u0005m\u0005BCA]\u0003\u007f\u0002\n\u00111\u0001\u0002@!Q\u0011QXA@!\u0003\u0005\r!a\u0010\t\u0013\u0005\u0005\u0017q\u0010I\u0001\u0002\u00049\u0004\"CAc\u0003\u007f\u0002\n\u00111\u00018\u0011)\tI-a \u0011\u0002\u0003\u0007\u00111\u001a\u0005\u000b\u0003+\fy\b%AA\u0002\u0005]\u0007BCAt\u0003\u007f\u0002\n\u00111\u0001\u0002j\"9\u0011\u0011Q\u0006\u0005\u0002\u0011eB\u0003FAC\tw!i\u0004b\u0010\u0005B\u0011\rCQ\tC$\t\u0013\"Y\u0005\u0003\u0005\u0002\u001a\u0012]\u0002\u0019AAN\u0011\u001d\t\t\fb\u000eA\u0002]B\u0001\"!.\u00058\u0001\u0007\u00111\u0014\u0005\t\u0003s#9\u00041\u0001\u0002@!A\u0011Q\u0018C\u001c\u0001\u0004\ty\u0004C\u0004\u0002B\u0012]\u0002\u0019A\u001c\t\u000f\u0005\u0015Gq\u0007a\u0001o!A\u0011\u0011\u001aC\u001c\u0001\u0004\tY\r\u0003\u0005\u0002V\u0012]\u0002\u0019AAl\u0011%!yeCI\u0001\n\u0003!\t&A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t!\u0019F\u000b\u0003\u0002\u001c\u000e]\u0001\"\u0003C,\u0017E\u0005I\u0011AB\n\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\u0012\u0004\"\u0003C.\u0017E\u0005I\u0011\u0001C)\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\u001a\u0004\"\u0003C0\u0017E\u0005I\u0011\u0001C1\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\"TC\u0001C2U\u0011\tyda\u0006\t\u0013\u0011\u001d4\"%A\u0005\u0002\u0011\u0005\u0014aD1qa2LH\u0005Z3gCVdG\u000fJ\u001b\t\u0013\u0011-4\"%A\u0005\u0002\rM\u0011aD1qa2LH\u0005Z3gCVdG\u000f\n\u001c\t\u0013\u0011=4\"%A\u0005\u0002\rM\u0011aD1qa2LH\u0005Z3gCVdG\u000fJ\u001c\t\u0013\u0011M4\"%A\u0005\u0002\u0011U\u0014aD1qa2LH\u0005Z3gCVdG\u000f\n\u001d\u0016\u0005\u0011]$\u0006BAf\u0007/A\u0011\u0002b\u001f\f#\u0003%\t\u0001\" \u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uIe*\"\u0001b +\t\u0005]7q\u0003\u0005\n\t\u0007[\u0011\u0013!C\u0001\t\u000b\u000b\u0001#\u00199qYf$C-\u001a4bk2$H%\r\u0019\u0016\u0005\u0011\u001d%\u0006BAu\u0007/\u0001")
public class ScribeHandler
extends Handler {
    private final String hostname;
    private final int port;
    private final String category;
    private final Duration bufferTime;
    private final Duration connectBackoff;
    private final int maxMessagesPerTransaction;
    private final ScribeHandlerStats stats;
    private final String loggerName;
    private Time lastConnectAttempt;
    private volatile Time _lastTransmission;
    private Option<Socket> socket;
    private ServerType serverType;
    private final ThreadPoolExecutor flusher;
    private final LinkedBlockingQueue<byte[]> queue;
    private final byte[] SCRIBE_PREFIX;
    private final byte[] OLD_SCRIBE_PREFIX;
    private final byte[] SCRIBE_REPLY;
    private final byte[] OLD_SCRIBE_REPLY;

    public static StatsReceiver apply$default$10() {
        return ScribeHandler$.MODULE$.apply$default$10();
    }

    public static Option<Level> apply$default$9() {
        return ScribeHandler$.MODULE$.apply$default$9();
    }

    public static Formatter apply$default$8() {
        return ScribeHandler$.MODULE$.apply$default$8();
    }

    public static int apply$default$7() {
        return ScribeHandler$.MODULE$.apply$default$7();
    }

    public static int apply$default$6() {
        return ScribeHandler$.MODULE$.apply$default$6();
    }

    public static Duration apply$default$5() {
        return ScribeHandler$.MODULE$.apply$default$5();
    }

    public static Duration apply$default$4() {
        return ScribeHandler$.MODULE$.apply$default$4();
    }

    public static String apply$default$3() {
        return ScribeHandler$.MODULE$.apply$default$3();
    }

    public static int apply$default$2() {
        return ScribeHandler$.MODULE$.apply$default$2();
    }

    public static String apply$default$1() {
        return ScribeHandler$.MODULE$.apply$default$1();
    }

    public static Function0<ScribeHandler> apply(String string2, int n, String string3, Duration duration, Duration duration2, int n2, int n3, Formatter formatter, Option<Level> option) {
        return ScribeHandler$.MODULE$.apply(string2, n, string3, duration, duration2, n2, n3, formatter, option);
    }

    public static Function0<ScribeHandler> apply(String string2, int n, String string3, Duration duration, Duration duration2, int n2, int n3, Formatter formatter, Option<Level> option, StatsReceiver statsReceiver) {
        return ScribeHandler$.MODULE$.apply(string2, n, string3, duration, duration2, n2, n3, formatter, option, statsReceiver);
    }

    public static Logger log() {
        return ScribeHandler$.MODULE$.log();
    }

    public static Duration DefaultStatsReportPeriod() {
        return ScribeHandler$.MODULE$.DefaultStatsReportPeriod();
    }

    public static int DefaultMaxMessagesToBuffer() {
        return ScribeHandler$.MODULE$.DefaultMaxMessagesToBuffer();
    }

    public static int DefaultMaxMessagesPerTransaction() {
        return ScribeHandler$.MODULE$.DefaultMaxMessagesPerTransaction();
    }

    public static Duration DefaultConnectBackoff() {
        return ScribeHandler$.MODULE$.DefaultConnectBackoff();
    }

    public static Duration DefaultBufferTime() {
        return ScribeHandler$.MODULE$.DefaultBufferTime();
    }

    public static String DefaultCategory() {
        return ScribeHandler$.MODULE$.DefaultCategory();
    }

    public static int DefaultPort() {
        return ScribeHandler$.MODULE$.DefaultPort();
    }

    public static String DefaultHostname() {
        return ScribeHandler$.MODULE$.DefaultHostname();
    }

    public static int TRY_LATER() {
        return ScribeHandler$.MODULE$.TRY_LATER();
    }

    public static int OK() {
        return ScribeHandler$.MODULE$.OK();
    }

    private String loggerName() {
        return this.loggerName;
    }

    private Time lastConnectAttempt() {
        return this.lastConnectAttempt;
    }

    private void lastConnectAttempt_$eq(Time x$1) {
        this.lastConnectAttempt = x$1;
    }

    private Time _lastTransmission() {
        return this._lastTransmission;
    }

    private void _lastTransmission_$eq(Time x$1) {
        this._lastTransmission = x$1;
    }

    public void updateLastTransmission() {
        this._lastTransmission_$eq(Time$.MODULE$.now());
    }

    private Option<Socket> socket() {
        return this.socket;
    }

    private void socket_$eq(Option<Socket> x$1) {
        this.socket = x$1;
    }

    public synchronized void setSocket(Option<Socket> newSocket) {
        this.socket_$eq(newSocket);
    }

    private ServerType serverType() {
        return this.serverType;
    }

    private void serverType_$eq(ServerType x$1) {
        this.serverType = x$1;
    }

    private boolean isArchaicServer() {
        ServerType serverType = this.serverType();
        ScribeHandler$Archaic$ scribeHandler$Archaic$ = ScribeHandler$Archaic$.MODULE$;
        return !(serverType != null ? !serverType.equals(scribeHandler$Archaic$) : scribeHandler$Archaic$ != null);
    }

    public ThreadPoolExecutor flusher() {
        return this.flusher;
    }

    public LinkedBlockingQueue<byte[]> queue() {
        return this.queue;
    }

    public int queueSize() {
        return this.queue().size();
    }

    @Override
    public void flush() {
        this.flusher().execute(new Runnable(this){
            private final /* synthetic */ ScribeHandler $outer;

            public void run() {
                this.$outer.com$twitter$logging$ScribeHandler$$sendBatch$1();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public ByteBuffer makeBuffer(int count) {
        IndexedSeq texts = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), count).map((Function1 & Serializable & scala.Serializable)i -> ScribeHandler.$anonfun$makeBuffer$1(this, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        ByteBuffer recordHeader = ByteBuffer.wrap(new byte[10 + this.category.length()]);
        recordHeader.order(ByteOrder.BIG_ENDIAN);
        recordHeader.put((byte)11);
        recordHeader.putShort((short)1);
        recordHeader.putInt(this.category.length());
        recordHeader.put(this.category.getBytes(StandardCharsets.ISO_8859_1));
        recordHeader.put((byte)11);
        recordHeader.putShort((short)2);
        byte[] prefix = this.isArchaicServer() ? this.OLD_SCRIBE_PREFIX : this.SCRIBE_PREFIX;
        int messageSize = count * (recordHeader.capacity() + 5) + BoxesRunTime.unboxToInt((Object)texts.foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2 & Serializable & scala.Serializable)(x$1, x$2) -> BoxesRunTime.boxToInteger((int)ScribeHandler.$anonfun$makeBuffer$2(BoxesRunTime.unboxToInt((Object)x$1), x$2)))) + prefix.length + 5;
        ByteBuffer buffer = ByteBuffer.wrap(new byte[messageSize + 4]);
        buffer.order(ByteOrder.BIG_ENDIAN);
        buffer.putInt(messageSize);
        buffer.put(prefix);
        buffer.putInt(count);
        texts.foreach((Function1 & Serializable & scala.Serializable)text -> {
            buffer.put(recordHeader.array());
            buffer.putInt(((byte[])text).length);
            buffer.put((byte[])text);
            return buffer.put((byte)0);
        });
        buffer.put((byte)0);
        return buffer;
    }

    private synchronized void closeSocket() {
        this.socket().foreach((Function1 & Serializable & scala.Serializable)s -> {
            ScribeHandler.$anonfun$closeSocket$1(s);
            return BoxedUnit.UNIT;
        });
        this.socket_$eq((Option<Socket>)None$.MODULE$);
    }

    @Override
    public void close() {
        this.stats.incrCloses();
        this.closeSocket();
        this.flusher().shutdown();
    }

    @Override
    public void publish(LogRecord record) {
        String string2 = record.getLoggerName();
        String string3 = this.loggerName();
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            return;
        }
        this.publish(this.getFormatter().format(record).getBytes("UTF-8"));
    }

    public void publish(byte[] record) {
        block1: {
            this.stats.incrPublished();
            if (!this.queue().offer(record)) {
                this.stats.incrDroppedRecords(this.stats.incrDroppedRecords$default$1());
            }
            if (!Time$.MODULE$.now().since(this._lastTransmission()).$greater$eq((Object)this.bufferTime)) break block1;
            this.flush();
        }
    }

    @Override
    public String toString() {
        return new StringOps(Predef$.MODULE$.augmentString("<%s level=%s hostname=%s port=%d scribe_buffer=%s scribe_backoff=%s scribe_max_packet_size=%d formatter=%s>")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.getClass().getName(), this.getLevel(), this.hostname, BoxesRunTime.boxToInteger((int)this.port), this.bufferTime, this.connectBackoff, BoxesRunTime.boxToInteger((int)this.maxMessagesPerTransaction), super.formatter().toString()}));
    }

    private final void connect$1() {
        block4: {
            if (this.socket().isDefined()) break block4;
            if (Time$.MODULE$.now().since(this.lastConnectAttempt()).$greater((Object)this.connectBackoff)) {
                try {
                    this.lastConnectAttempt_$eq(Time$.MODULE$.now());
                    this.socket_$eq((Option<Socket>)new Some((Object)new Socket(this.hostname, this.port)));
                    this.stats.incrConnection();
                    this.serverType_$eq(ScribeHandler$Unknown$.MODULE$);
                }
                catch (Exception e) {
                    ScribeHandler$.MODULE$.log().error("Unable to open socket to scribe server at %s:%d: %s", (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.hostname, BoxesRunTime.boxToInteger((int)this.port), e}));
                    this.stats.incrConnectionFailure();
                }
            } else {
                this.stats.incrConnectionSkipped();
            }
        }
    }

    private final ServerType liftedTree1$1(Socket s$1, OutputStream outStream$1) {
        Product product;
        try {
            byte[] prefix = this.OLD_SCRIBE_PREFIX;
            int messageSize = prefix.length + 5;
            ByteBuffer buffer = ByteBuffer.wrap(new byte[messageSize + 4]);
            buffer.order(ByteOrder.BIG_ENDIAN);
            buffer.putInt(messageSize);
            buffer.put(prefix);
            buffer.putInt(0);
            buffer.put((byte)0);
            byte[] fakeMessageWithOldScribePrefix = buffer.array();
            outStream$1.write(fakeMessageWithOldScribePrefix);
            ScribeHandler.readResponseExpecting$1(s$1, this.OLD_SCRIBE_REPLY);
            ScribeHandler$.MODULE$.log().debug("Scribe server is archaic; changing to old protocol for future requests.", (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
            product = ScribeHandler$Archaic$.MODULE$;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            ScribeHandler$Modern$ scribeHandler$Modern$ = ScribeHandler$Modern$.MODULE$;
            product = scribeHandler$Modern$;
        }
        return product;
    }

    private final void detectArchaicServer$1() {
        ServerType serverType;
        ServerType serverType2 = this.serverType();
        ScribeHandler$Unknown$ scribeHandler$Unknown$ = ScribeHandler$Unknown$.MODULE$;
        if (serverType2 == null ? scribeHandler$Unknown$ != null : !serverType2.equals(scribeHandler$Unknown$)) {
            return;
        }
        Option<Socket> option = this.socket();
        if (None$.MODULE$.equals(option)) {
            serverType = ScribeHandler$Unknown$.MODULE$;
        } else if (option instanceof Some) {
            Some some = (Some)option;
            Socket s = (Socket)some.value();
            OutputStream outStream = s.getOutputStream();
            serverType = this.liftedTree1$1(s, outStream);
        } else {
            throw new MatchError(option);
        }
        this.serverType_$eq(serverType);
    }

    public static final /* synthetic */ void $anonfun$flush$1(ScribeHandler $this, Socket s) {
        OutputStream outStream = s.getOutputStream();
        int remaining = $this.queue().size();
        while (remaining > 0 && $this.socket().isDefined()) {
            int count = RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper($this.maxMessagesPerTransaction), remaining);
            ByteBuffer buffer = $this.makeBuffer(count);
            boolean offset = false;
            try {
                outStream.write(buffer.array());
                byte[] expectedReply = $this.isArchaicServer() ? $this.OLD_SCRIBE_REPLY : $this.SCRIBE_REPLY;
                ScribeHandler.readResponseExpecting$1(s, expectedReply);
                $this.stats.incrSentRecords(count);
                remaining -= count;
            }
            catch (Exception e) {
                $this.stats.incrDroppedRecords(count);
                ScribeHandler$.MODULE$.log().error((Throwable)e, "Failed to send %s %d log entries to scribe server at %s:%d", (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.category, BoxesRunTime.boxToInteger((int)count), $this.hostname, BoxesRunTime.boxToInteger((int)$this.port)}));
                $this.closeSocket();
            }
        }
        $this.updateLastTransmission();
    }

    public final synchronized void com$twitter$logging$ScribeHandler$$sendBatch$1() {
        this.connect$1();
        this.detectArchaicServer$1();
        this.socket().foreach((Function1 & Serializable & scala.Serializable)s -> {
            ScribeHandler.$anonfun$flush$1(this, s);
            return BoxedUnit.UNIT;
        });
        this.stats.log();
    }

    private static final void readResponseExpecting$1(Socket socket, byte[] expectedReply) {
        int n;
        InputStream inStream = socket.getInputStream();
        byte[] response = new byte[expectedReply.length];
        for (int offset = 0; offset < response.length; offset += n) {
            n = inStream.read(response, offset, response.length - offset);
            if (n >= 0) continue;
            throw new IOException("End of stream");
        }
        if (!Arrays.equals(response, expectedReply)) {
            throw new IOException("Error response from scribe server: " + string$.MODULE$.byteArrayToConfiggyByteArray(response).hexlify());
        }
    }

    public static final /* synthetic */ byte[] $anonfun$makeBuffer$1(ScribeHandler $this, int i) {
        return $this.queue().poll();
    }

    public static final /* synthetic */ int $anonfun$makeBuffer$2(int x$1, byte[] x$2) {
        return x$1 + x$2.length;
    }

    public static final /* synthetic */ void $anonfun$closeSocket$1(Socket s) {
        try {
            s.close();
        }
        catch (Throwable throwable) {}
    }

    public ScribeHandler(String hostname, int port, String category, Duration bufferTime, Duration connectBackoff, int maxMessagesPerTransaction, int maxMessagesToBuffer, Formatter formatter, Option<Level> level, StatsReceiver statsReceiver) {
        this.hostname = hostname;
        this.port = port;
        this.category = category;
        this.bufferTime = bufferTime;
        this.connectBackoff = connectBackoff;
        this.maxMessagesPerTransaction = maxMessagesPerTransaction;
        super(formatter, level);
        this.stats = new ScribeHandlerStats(statsReceiver);
        this.loggerName = this.getClass().toString();
        this.lastConnectAttempt = Time$.MODULE$.epoch();
        this._lastTransmission = Time$.MODULE$.epoch();
        this.socket = None$.MODULE$;
        this.serverType = ScribeHandler$Unknown$.MODULE$;
        NamedPoolThreadFactory threadFactory = new NamedPoolThreadFactory("ScribeFlusher-" + category, true);
        ArrayBlockingQueue<Runnable> queue = new ArrayBlockingQueue<Runnable>(5);
        ThreadPoolExecutor.DiscardPolicy rejectionHandler = new ThreadPoolExecutor.DiscardPolicy();
        this.flusher = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, queue, (ThreadFactory)threadFactory, rejectionHandler);
        this.queue = new LinkedBlockingQueue(maxMessagesToBuffer);
        this.SCRIBE_PREFIX = (byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{(byte)128, 1, 0, 1, 0, 0, 0, 3, (byte)76, (byte)111, (byte)103, 0, 0, 0, 0, 15, 0, 1, 12}), ClassTag$.MODULE$.Byte());
        this.OLD_SCRIBE_PREFIX = (byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{0, 0, 0, 3, (byte)76, (byte)111, (byte)103, 1, 0, 0, 0, 0, 15, 0, 1, 12}), ClassTag$.MODULE$.Byte());
        this.SCRIBE_REPLY = (byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{(byte)128, 1, 0, 2, 0, 0, 0, 3, (byte)76, (byte)111, (byte)103, 0, 0, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0}), ClassTag$.MODULE$.Byte());
        this.OLD_SCRIBE_REPLY = (byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{0, 0, 0, 20, 0, 0, 0, 3, (byte)76, (byte)111, (byte)103, 2, 0, 0, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0}), ClassTag$.MODULE$.Byte());
    }

    public ScribeHandler(String hostname, int port, String category, Duration bufferTime, Duration connectBackoff, int maxMessagesPerTransaction, int maxMessagesToBuffer, Formatter formatter, Option<Level> level) {
        this(hostname, port, category, bufferTime, connectBackoff, maxMessagesPerTransaction, maxMessagesToBuffer, formatter, level, (StatsReceiver)NullStatsReceiver$.MODULE$);
    }

    public class ScribeHandlerStats {
        private Time _lastLogStats;
        private final AtomicLong sentRecords;
        private final AtomicLong droppedRecords;
        private final AtomicLong connectionFailure;
        private final AtomicLong connectionSkipped;
        private final Counter totalSentRecords;
        private final Counter totalDroppedRecords;
        private final Counter totalConnectionFailure;
        private final Counter totalConnectionSkipped;
        private final Counter totalConnects;
        private final Counter totalPublished;
        private final Counter totalCloses;
        private final Gauge instances;
        private final Gauge unsentQueue;

        private Time _lastLogStats() {
            return this._lastLogStats;
        }

        private void _lastLogStats_$eq(Time x$1) {
            this._lastLogStats = x$1;
        }

        private AtomicLong sentRecords() {
            return this.sentRecords;
        }

        private AtomicLong droppedRecords() {
            return this.droppedRecords;
        }

        private AtomicLong connectionFailure() {
            return this.connectionFailure;
        }

        private AtomicLong connectionSkipped() {
            return this.connectionSkipped;
        }

        public Counter totalSentRecords() {
            return this.totalSentRecords;
        }

        public Counter totalDroppedRecords() {
            return this.totalDroppedRecords;
        }

        public Counter totalConnectionFailure() {
            return this.totalConnectionFailure;
        }

        public Counter totalConnectionSkipped() {
            return this.totalConnectionSkipped;
        }

        public Counter totalConnects() {
            return this.totalConnects;
        }

        public Counter totalPublished() {
            return this.totalPublished;
        }

        public Counter totalCloses() {
            return this.totalCloses;
        }

        public Gauge instances() {
            return this.instances;
        }

        public Gauge unsentQueue() {
            return this.unsentQueue;
        }

        public void incrSentRecords(int count) {
            this.sentRecords().addAndGet(count);
            this.totalSentRecords().incr(count);
        }

        public void incrDroppedRecords(int count) {
            this.droppedRecords().addAndGet(count);
            this.totalDroppedRecords().incr(count);
        }

        public int incrDroppedRecords$default$1() {
            return 1;
        }

        public void incrConnectionFailure() {
            this.connectionFailure().incrementAndGet();
            this.totalConnectionFailure().incr();
        }

        public void incrConnectionSkipped() {
            this.connectionSkipped().incrementAndGet();
            this.totalConnectionSkipped().incr();
        }

        public void incrPublished() {
            this.totalPublished().incr();
        }

        public void incrConnection() {
            this.totalConnects().incr();
        }

        public void incrCloses() {
            this.totalCloses().incr();
        }

        public synchronized void log() {
            block0: {
                Duration period = Time$.MODULE$.now().since(this._lastLogStats());
                if (!period.$greater((Object)ScribeHandler$.MODULE$.DefaultStatsReportPeriod())) break block0;
                long sent = this.sentRecords().getAndSet(0L);
                long dropped = this.droppedRecords().getAndSet(0L);
                long failed = this.connectionFailure().getAndSet(0L);
                long skipped = this.connectionSkipped().getAndSet(0L);
                ScribeHandler$.MODULE$.log().info("sent records: %d, per second: %d, dropped records: %d, reconnection failures: %d, reconnection skipped: %d", (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)sent), BoxesRunTime.boxToLong((long)(sent / (long)period.inSeconds())), BoxesRunTime.boxToLong((long)dropped), BoxesRunTime.boxToLong((long)failed), BoxesRunTime.boxToLong((long)skipped)}));
                this._lastLogStats_$eq(Time$.MODULE$.now());
            }
        }

        public /* synthetic */ ScribeHandler com$twitter$logging$ScribeHandler$ScribeHandlerStats$$$outer() {
            return ScribeHandler.this;
        }

        public ScribeHandlerStats(StatsReceiver statsReceiver) {
            if (ScribeHandler.this == null) {
                throw null;
            }
            this._lastLogStats = Time$.MODULE$.epoch();
            this.sentRecords = new AtomicLong();
            this.droppedRecords = new AtomicLong();
            this.connectionFailure = new AtomicLong();
            this.connectionSkipped = new AtomicLong();
            this.totalSentRecords = statsReceiver.counter((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"sent_records"}));
            this.totalDroppedRecords = statsReceiver.counter((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"dropped_records"}));
            this.totalConnectionFailure = statsReceiver.counter((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"connection_failed"}));
            this.totalConnectionSkipped = statsReceiver.counter((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"connection_skipped"}));
            this.totalConnects = statsReceiver.counter((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"connects"}));
            this.totalPublished = statsReceiver.counter((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"published"}));
            this.totalCloses = statsReceiver.counter((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"closes"}));
            this.instances = statsReceiver.addGauge((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"instances"}), (Function0)(JFunction0.mcF.sp & Serializable & scala.Serializable)() -> 1.0f);
            this.unsentQueue = statsReceiver.addGauge((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"unsent_queue"}), (Function0)(JFunction0.mcF.sp & Serializable & scala.Serializable)() -> this.com$twitter$logging$ScribeHandler$ScribeHandlerStats$$$outer().queueSize());
        }
    }

    public static interface ServerType {
    }
}

