/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.logging;

import com.twitter.logging.FileHandler$;
import com.twitter.logging.Formatter;
import com.twitter.logging.Formatter$;
import com.twitter.logging.Handler;
import com.twitter.logging.Level;
import com.twitter.logging.Policy;
import com.twitter.logging.Policy$Daily$;
import com.twitter.logging.Policy$Hourly$;
import com.twitter.logging.Policy$Never$;
import com.twitter.logging.Policy$SigHup$;
import com.twitter.util.HandleSignal$;
import com.twitter.util.StorageUnit;
import com.twitter.util.Time$;
import com.twitter.util.TwitterDateFormat$;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.LogRecord;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t\rs!\u0002\u001d:\u0011\u0003\u0001e!\u0002\":\u0011\u0003\u0019\u0005\"\u0002&\u0002\t\u0003Y\u0005b\u0002'\u0002\u0005\u0004%\t!\u0014\u0005\u00071\u0006\u0001\u000b\u0011\u0002(\t\u000be\u000bA\u0011\u0001.\t\u0013\tM\u0011!%A\u0005\u0002\tU\u0001\"\u0003B\u0016\u0003E\u0005I\u0011\u0001B\u0017\u0011%\u0011\t$AI\u0001\n\u0003\u0011\u0019\u0004C\u0005\u00038\u0005\t\n\u0011\"\u0001\u0003:!I!QH\u0001\u0012\u0002\u0013\u0005!q\b\u0004\u0005\u0005f\u0002q\f\u0003\u0005d\u0017\t\u0005\t\u0015!\u0003e\u0011!y7B!A!\u0002\u0013\u0001\b\u0002C:\f\u0005\u000b\u0007I\u0011\u0001;\t\u0011a\\!\u0011!Q\u0001\nUD\u0001\"_\u0006\u0003\u0002\u0003\u0006IA\u001f\u0005\u000b{.\u0011\t\u0011)A\u0005}\u0006\r\u0001\u0002DA\u0003\u0017\t\u0005\t\u0015!\u0003\u0002\b\u0005M\u0001B\u0002&\f\t\u0003\t)\u0002\u0003\u0007\u0002$-\u0001\n\u0011aA!\u0002\u0013\t)\u0003C\u0005\u00026-\u0011\r\u0011\"\u0001\u00028!A\u0011\u0011H\u0006!\u0002\u0013\tY\u0003C\u0005\u0002<-\u0011\r\u0011\"\u0001\u00028!A\u0011QH\u0006!\u0002\u0013\tY\u0003\u0003\u0007\u0002@-\u0001\n\u0011aA!\u0002\u0013\t)\u0003C\u0005\u0002B-\u0011\r\u0011\"\u0001\u00028!A\u00111I\u0006!\u0002\u0013\tY\u0003C\u0005\u0002F-\u0011\r\u0011\"\u0001\u00028!A\u0011qI\u0006!\u0002\u0013\tY\u0003C\u0005\u0002J-\u0001\r\u0011\"\u0003\u0002L!I\u0011\u0011L\u0006A\u0002\u0013%\u00111\f\u0005\t\u0003KZ\u0001\u0015)\u0003\u0002N!I\u0011qM\u0006A\u0002\u0013%\u0011\u0011\u000e\u0005\n\u0003cZ\u0001\u0019!C\u0005\u0003gB\u0001\"a\u001e\fA\u0003&\u00111\u000e\u0005\n\u0003\u0003[\u0001\u0019!C\u0005\u0003\u0007C\u0011\"a\"\f\u0001\u0004%I!!#\t\u0011\u000555\u0002)Q\u0005\u0003\u000bC\u0011\"a$\f\u0001\u0004%I!!\u001b\t\u0013\u0005E5\u00021A\u0005\n\u0005M\u0005\u0002CAL\u0017\u0001\u0006K!a\u001b\t\u0013\u0005e5B1A\u0005\n\u0005m\u0005\u0002CAV\u0017\u0001\u0006I!!(\t\u0011\u000556B1A\u0005\nQDq!a,\fA\u0003%Q\u000fC\u0004\u00022.!\t!a-\t\u000f\u0005U6\u0002\"\u0001\u00024\"9\u0011qW\u0006\u0005\n\u0005e\u0006bBA^\u0017\u0011%\u00111\u0017\u0005\b\u0003{[A\u0011AA`\u0011\u001d\tym\u0003C\u0001\u0003#Dq!a6\f\t\u0013\t\u0019\fC\u0004\u0002Z.!\t!a-\t\u000f\u0005m7\u0002\"\u0001\u0002^\"9\u0011Q^\u0006\u0005\n\u0005=\u0018a\u0003$jY\u0016D\u0015M\u001c3mKJT!AO\u001e\u0002\u000f1|wmZ5oO*\u0011A(P\u0001\bi^LG\u000f^3s\u0015\u0005q\u0014aA2p[\u000e\u0001\u0001CA!\u0002\u001b\u0005I$a\u0003$jY\u0016D\u0015M\u001c3mKJ\u001c\"!\u0001#\u0011\u0005\u0015CU\"\u0001$\u000b\u0003\u001d\u000bQa]2bY\u0006L!!\u0013$\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t\u0001)\u0001\u0003V)\u001aCT#\u0001(\u0011\u0005=3V\"\u0001)\u000b\u0005E\u0013\u0016aB2iCJ\u001cX\r\u001e\u0006\u0003'R\u000b1A\\5p\u0015\u0005)\u0016\u0001\u00026bm\u0006L!a\u0016)\u0003\u000f\rC\u0017M]:fi\u0006)Q\u000b\u0016$9A\u0005)\u0011\r\u001d9msRi1La\u0002\u0003\n\t-!Q\u0002B\b\u0005#\u00012!\u0012/_\u0013\tifIA\u0005Gk:\u001cG/[8oaA\u0011\u0011iC\n\u0003\u0017\u0001\u0004\"!Q1\n\u0005\tL$a\u0002%b]\u0012dWM]\u0001\u0005a\u0006$\b\u000e\u0005\u0002fY:\u0011aM\u001b\t\u0003O\u001ak\u0011\u0001\u001b\u0006\u0003S~\na\u0001\u0010:p_Rt\u0014BA6G\u0003\u0019\u0001&/\u001a3fM&\u0011QN\u001c\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005-4\u0015A\u0003:pY2\u0004v\u000e\\5dsB\u0011\u0011)]\u0005\u0003ef\u0012a\u0001U8mS\u000eL\u0018AB1qa\u0016tG-F\u0001v!\t)e/\u0003\u0002x\r\n9!i\\8mK\u0006t\u0017aB1qa\u0016tG\rI\u0001\fe>$\u0018\r^3D_VtG\u000f\u0005\u0002Fw&\u0011AP\u0012\u0002\u0004\u0013:$\u0018!\u00034pe6\fG\u000f^3s!\t\tu0C\u0002\u0002\u0002e\u0012\u0011BR8s[\u0006$H/\u001a:\n\u0005u\f\u0017!\u00027fm\u0016d\u0007#B#\u0002\n\u00055\u0011bAA\u0006\r\n1q\n\u001d;j_:\u00042!QA\b\u0013\r\t\t\"\u000f\u0002\u0006\u0019\u00164X\r\\\u0005\u0004\u0003\u000b\tG#\u00040\u0002\u0018\u0005e\u00111DA\u000f\u0003?\t\t\u0003C\u0003d'\u0001\u0007A\rC\u0003p'\u0001\u0007\u0001\u000fC\u0003t'\u0001\u0007Q\u000fC\u0003z'\u0001\u0007!\u0010C\u0003~'\u0001\u0007a\u0010C\u0004\u0002\u0006M\u0001\r!a\u0002\u0002\u0007a$\u0013\u0007E\u0004F\u0003O\tY#a\u000b\n\u0007\u0005%bI\u0001\u0004UkBdWM\r\t\u0005\u0003[\t\u0019$\u0004\u0002\u00020)\u0019\u0011\u0011\u0007+\u0002\t1\fgnZ\u0005\u0004[\u0006=\u0012\u0001\u00034jY\u0016t\u0017-\\3\u0016\u0005\u0005-\u0012!\u00034jY\u0016t\u0017-\\3!\u0003\u0011q\u0017-\\3\u0002\u000b9\fW.\u001a\u0011\u0002\u0007a$#'\u0001\bgS2,g.Y7f!J,g-\u001b=\u0002\u001f\u0019LG.\u001a8b[\u0016\u0004&/\u001a4jq\u0002\naBZ5mK:\fW.Z*vM\u001aL\u00070A\bgS2,g.Y7f'V4g-\u001b=!\u0003\u0019\u0019HO]3b[V\u0011\u0011Q\n\t\u0005\u0003\u001f\n)&\u0004\u0002\u0002R)\u0019\u00111\u000b+\u0002\u0005%|\u0017\u0002BA,\u0003#\u0012AbT;uaV$8\u000b\u001e:fC6\f!b\u001d;sK\u0006lw\fJ3r)\u0011\ti&a\u0019\u0011\u0007\u0015\u000by&C\u0002\u0002b\u0019\u0013A!\u00168ji\"I\u00111E\u0010\u0002\u0002\u0003\u0007\u0011QJ\u0001\bgR\u0014X-Y7!\u0003!y\u0007/\u001a8US6,WCAA6!\r)\u0015QN\u0005\u0004\u0003_2%\u0001\u0002'p]\u001e\fAb\u001c9f]RKW.Z0%KF$B!!\u0018\u0002v!I\u00111\u0005\u0012\u0002\u0002\u0003\u0007\u00111N\u0001\n_B,g\u000eV5nK\u0002B3aIA>!\r)\u0015QP\u0005\u0004\u0003\u007f2%\u0001\u0003<pY\u0006$\u0018\u000e\\3\u0002\u00199,\u0007\u0010\u001e*pY2$\u0016.\\3\u0016\u0005\u0005\u0015\u0005#B#\u0002\n\u0005-\u0014\u0001\u00058fqR\u0014v\u000e\u001c7US6,w\fJ3r)\u0011\ti&a#\t\u0013\u0005\rR%!AA\u0002\u0005\u0015\u0015!\u00048fqR\u0014v\u000e\u001c7US6,\u0007%\u0001\ncsR,7o\u0016:jiR,g\u000eV8GS2,\u0017A\u00062zi\u0016\u001cxK]5ui\u0016tGk\u001c$jY\u0016|F%Z9\u0015\t\u0005u\u0013Q\u0013\u0005\n\u0003GA\u0013\u0011!a\u0001\u0003W\n1CY=uKN<&/\u001b;uK:$vNR5mK\u0002\n1\"\\1y\r&dWmU5{KV\u0011\u0011Q\u0014\t\u0006\u000b\u0006%\u0011q\u0014\t\u0005\u0003C\u000b9+\u0004\u0002\u0002$*\u0019\u0011QU\u001e\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003S\u000b\u0019KA\u0006Ti>\u0014\u0018mZ3V]&$\u0018\u0001D7bq\u001aKG.Z*ju\u0016\u0004\u0013aD3yC6Lg.\u001a*pY2$\u0016.\\3\u0002!\u0015D\u0018-\\5oKJ{G\u000e\u001c+j[\u0016\u0004\u0013!\u00024mkNDGCAA/\u0003\u0015\u0019Gn\\:f\u0003)y\u0007/\u001a8TiJ,\u0017-\u001c\u000b\u0003\u0003\u001b\nqa\u001c9f]2{w-\u0001\u0006uS6,7+\u001e4gSb$2\u0001ZAa\u0011\u001d\t\u0019M\ra\u0001\u0003\u000b\fA\u0001Z1uKB!\u0011qYAf\u001b\t\tIMC\u0002\u0002&RKA!!4\u0002J\n!A)\u0019;f\u0003M\u0019w.\u001c9vi\u0016tU\r\u001f;S_2dG+[7f)\u0011\t))a5\t\u000f\u0005U7\u00071\u0001\u0002l\u0005\u0019an\\<\u0002\u001dI,Wn\u001c<f\u001f2$g)\u001b7fg\u0006!!o\u001c7m\u0003\u001d\u0001XO\u00197jg\"$B!!\u0018\u0002`\"9\u0011\u0011\u001d\u001cA\u0002\u0005\r\u0018A\u0002:fG>\u0014H\r\u0005\u0003\u0002f\u0006%XBAAt\u0015\rQ\u0014\u0011Z\u0005\u0005\u0003W\f9OA\u0005M_\u001e\u0014VmY8sI\u0006y\u0001.\u00198eY\u0016$\u0006N]8xC\ndW\r\u0006\u0003\u0002^\u0005E\bbBAzo\u0001\u0007\u0011Q_\u0001\u0002KB!\u0011q\u001fB\u0001\u001d\u0011\tI0!@\u000f\u0007\u001d\fY0C\u0001H\u0013\r\tyPR\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u0011\u0019A!\u0002\u0003\u0013QC'o\\<bE2,'bAA\u0000\r\"1\u0011QG\u0003A\u0002\u0011Dqa\\\u0003\u0011\u0002\u0003\u0007\u0001\u000fC\u0004t\u000bA\u0005\t\u0019A;\t\u000fe,\u0001\u0013!a\u0001u\"9Q0\u0002I\u0001\u0002\u0004q\b\"CA\u0003\u000bA\u0005\t\u0019AA\u0004\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\u0012TC\u0001B\fU\r\u0001(\u0011D\u0016\u0003\u00057\u0001BA!\b\u0003(5\u0011!q\u0004\u0006\u0005\u0005C\u0011\u0019#A\u0005v]\u000eDWmY6fI*\u0019!Q\u0005$\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003*\t}!!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006y\u0011\r\u001d9ms\u0012\"WMZ1vYR$3'\u0006\u0002\u00030)\u001aQO!\u0007\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uIQ*\"A!\u000e+\u0007i\u0014I\"A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00136+\t\u0011YDK\u0002\u007f\u00053\tq\"\u00199qYf$C-\u001a4bk2$HEN\u000b\u0003\u0005\u0003RC!a\u0002\u0003\u001a\u0001")
public class FileHandler
extends Handler {
    private final Policy rollPolicy;
    private final boolean append;
    private final int rotateCount;
    private final /* synthetic */ Tuple2 x$1;
    private final String filename;
    private final String name;
    private final /* synthetic */ Tuple2 x$2;
    private final String filenamePrefix;
    private final String filenameSuffix;
    private OutputStream stream;
    private volatile long openTime;
    private Option<Object> nextRollTime;
    private long bytesWrittenToFile;
    private final Option<StorageUnit> maxFileSize;
    private final boolean examineRollTime;

    public static Option<Level> apply$default$6() {
        return FileHandler$.MODULE$.apply$default$6();
    }

    public static Formatter apply$default$5() {
        return FileHandler$.MODULE$.apply$default$5();
    }

    public static int apply$default$4() {
        return FileHandler$.MODULE$.apply$default$4();
    }

    public static boolean apply$default$3() {
        return FileHandler$.MODULE$.apply$default$3();
    }

    public static Policy apply$default$2() {
        return FileHandler$.MODULE$.apply$default$2();
    }

    public static Function0<FileHandler> apply(String string, Policy policy, boolean bl, int n, Formatter formatter, Option<Level> option) {
        return FileHandler$.MODULE$.apply(string, policy, bl, n, formatter, option);
    }

    public static Charset UTF8() {
        return FileHandler$.MODULE$.UTF8();
    }

    public boolean append() {
        return this.append;
    }

    public String filename() {
        return this.filename;
    }

    public String name() {
        return this.name;
    }

    public String filenamePrefix() {
        return this.filenamePrefix;
    }

    public String filenameSuffix() {
        return this.filenameSuffix;
    }

    private OutputStream stream() {
        return this.stream;
    }

    private void stream_$eq(OutputStream x$1) {
        this.stream = x$1;
    }

    private long openTime() {
        return this.openTime;
    }

    private void openTime_$eq(long x$1) {
        this.openTime = x$1;
    }

    private Option<Object> nextRollTime() {
        return this.nextRollTime;
    }

    private void nextRollTime_$eq(Option<Object> x$1) {
        this.nextRollTime = x$1;
    }

    private long bytesWrittenToFile() {
        return this.bytesWrittenToFile;
    }

    private void bytesWrittenToFile_$eq(long x$1) {
        this.bytesWrittenToFile = x$1;
    }

    private Option<StorageUnit> maxFileSize() {
        return this.maxFileSize;
    }

    private boolean examineRollTime() {
        return this.examineRollTime;
    }

    @Override
    public synchronized void flush() {
        this.stream().flush();
    }

    @Override
    public synchronized void close() {
        this.flush();
        try {
            this.stream().close();
        }
        catch (Throwable e) {
            this.handleThrowable(e);
        }
    }

    private OutputStream openStream() {
        File file = new File(this.filename());
        File dir = file.getParentFile();
        Object object = dir != null && !dir.exists() ? BoxesRunTime.boxToBoolean((boolean)dir.mkdirs()) : BoxedUnit.UNIT;
        this.bytesWrittenToFile_$eq(file.exists() ? file.length() : 0L);
        return new FileOutputStream(this.filename(), this.append());
    }

    private synchronized void openLog() {
        this.stream_$eq(this.openStream());
        this.openTime_$eq(Time$.MODULE$.now().inMilliseconds());
        this.nextRollTime_$eq(this.computeNextRollTime(this.openTime()));
    }

    public String timeSuffix(Date date) {
        SimpleDateFormat simpleDateFormat;
        Policy policy = this.rollPolicy;
        if (Policy$Never$.MODULE$.equals(policy)) {
            simpleDateFormat = TwitterDateFormat$.MODULE$.apply("yyyy");
        } else if (Policy$SigHup$.MODULE$.equals(policy)) {
            simpleDateFormat = TwitterDateFormat$.MODULE$.apply("yyyy");
        } else if (Policy$Hourly$.MODULE$.equals(policy)) {
            simpleDateFormat = TwitterDateFormat$.MODULE$.apply("yyyyMMdd-HH");
        } else if (Policy$Daily$.MODULE$.equals(policy)) {
            simpleDateFormat = TwitterDateFormat$.MODULE$.apply("yyyyMMdd");
        } else if (policy instanceof Policy.Weekly) {
            simpleDateFormat = TwitterDateFormat$.MODULE$.apply("yyyyMMdd");
        } else if (policy instanceof Policy.MaxSize) {
            simpleDateFormat = TwitterDateFormat$.MODULE$.apply("yyyyMMdd-HHmmss");
        } else {
            throw new MatchError((Object)policy);
        }
        SimpleDateFormat dateFormat = simpleDateFormat;
        dateFormat.setCalendar(super.formatter().calendar());
        return dateFormat.format(date);
    }

    public Option<Object> computeNextRollTime(long now) {
        None$ none$;
        LazyRef next$lzy = new LazyRef();
        Policy policy = this.rollPolicy;
        boolean bl = policy instanceof Policy.MaxSize ? true : (Policy$Never$.MODULE$.equals(policy) ? true : Policy$SigHup$.MODULE$.equals(policy));
        if (bl) {
            none$ = None$.MODULE$;
        } else if (Policy$Hourly$.MODULE$.equals(policy)) {
            this.next$1(next$lzy, now).add(11, 1);
            none$ = new Some((Object)this.next$1(next$lzy, now));
        } else if (Policy$Daily$.MODULE$.equals(policy)) {
            this.next$1(next$lzy, now).set(11, 0);
            this.next$1(next$lzy, now).add(5, 1);
            none$ = new Some((Object)this.next$1(next$lzy, now));
        } else if (policy instanceof Policy.Weekly) {
            Policy.Weekly weekly = (Policy.Weekly)policy;
            int weekday = weekly.dayOfWeek();
            this.next$1(next$lzy, now).set(11, 0);
            do {
                this.next$1(next$lzy, now).add(5, 1);
            } while (this.next$1(next$lzy, now).get(7) != weekday);
            none$ = new Some((Object)this.next$1(next$lzy, now));
        } else {
            throw new MatchError((Object)policy);
        }
        None$ rv = none$;
        return rv.map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.getTimeInMillis()));
    }

    private void removeOldFiles() {
        block0: {
            if (this.rotateCount < 0) break block0;
            String prefixName = new File(this.filenamePrefix()).getName();
            File[] rotatedFiles = (File[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new File(this.filename()).getParentFile().listFiles(new FilenameFilter(this, prefixName){
                private final /* synthetic */ FileHandler $outer;
                private final String prefixName$1;

                public boolean accept(File f, String fname) {
                    String string = fname;
                    String string2 = this.$outer.name();
                    return (string == null ? string2 != null : !string.equals(string2)) && fname.startsWith(this.prefixName$1) && fname.endsWith(this.$outer.filenameSuffix());
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.prefixName$1 = prefixName$1;
                }
            }))).sortBy((Function1 & Serializable & scala.Serializable)x$4 -> x$4.getName(), (Ordering)Ordering.String$.MODULE$);
            int toDeleteCount = package$.MODULE$.max(0, rotatedFiles.length - this.rotateCount);
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rotatedFiles)).take(toDeleteCount))).foreach((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.delete()));
        }
    }

    public synchronized void roll() {
        this.stream().close();
        String newFilename = new StringBuilder(1).append(this.filenamePrefix()).append("-").append(this.timeSuffix(new Date(this.openTime()))).append(this.filenameSuffix()).toString();
        new File(this.filename()).renameTo(new File(newFilename));
        this.openLog();
        this.removeOldFiles();
    }

    @Override
    public void publish(LogRecord record) {
        try {
            String formattedLine = this.getFormatter().format(record);
            byte[] formattedBytes = formattedLine.getBytes(FileHandler$.MODULE$.UTF8());
            int lineSizeBytes = formattedBytes.length;
            if (this.examineRollTime()) {
                FileHandler fileHandler = this;
                synchronized (fileHandler) {
                    this.nextRollTime().foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)time -> {
                        block0: {
                            if (Time$.MODULE$.now().inMilliseconds() <= time) break block0;
                            this.roll();
                        }
                    });
                }
            }
            this.maxFileSize().foreach((Function1 & Serializable & scala.Serializable)size -> {
                FileHandler.$anonfun$publish$2(this, lineSizeBytes, size);
                return BoxedUnit.UNIT;
            });
            FileHandler fileHandler = this;
            synchronized (fileHandler) {
                this.stream().write(formattedBytes);
                this.stream().flush();
                this.bytesWrittenToFile_$eq(this.bytesWrittenToFile() + (long)lineSizeBytes);
            }
        }
        catch (Throwable e) {
            this.handleThrowable(e);
        }
    }

    private void handleThrowable(Throwable e) {
        System.err.println(Formatter$.MODULE$.formatStackTrace(e, 30).mkString("\n"));
    }

    public static final /* synthetic */ void $anonfun$new$1(FileHandler $this, String signal) {
        OutputStream oldStream = $this.stream();
        FileHandler fileHandler = $this;
        synchronized (fileHandler) {
            $this.stream_$eq($this.openStream());
        }
        try {
            oldStream.close();
        }
        catch (Throwable e) {
            $this.handleThrowable(e);
        }
    }

    private final /* synthetic */ Calendar next$lzycompute$1(LazyRef next$lzy$1, long now$1) {
        Calendar calendar;
        LazyRef lazyRef = next$lzy$1;
        synchronized (lazyRef) {
            Calendar calendar2;
            if (next$lzy$1.initialized()) {
                calendar2 = (Calendar)next$lzy$1.value();
            } else {
                Calendar n = (Calendar)super.formatter().calendar().clone();
                n.setTimeInMillis(now$1);
                n.set(14, 0);
                n.set(13, 0);
                n.set(12, 0);
                calendar2 = (Calendar)next$lzy$1.initialize((Object)n);
            }
            calendar = calendar2;
        }
        return calendar;
    }

    private final Calendar next$1(LazyRef next$lzy$1, long now$1) {
        return next$lzy$1.initialized() ? (Calendar)next$lzy$1.value() : this.next$lzycompute$1(next$lzy$1, now$1);
    }

    public static final /* synthetic */ void $anonfun$publish$2(FileHandler $this, int lineSizeBytes$1, StorageUnit size) {
        FileHandler fileHandler = $this;
        synchronized (fileHandler) {
            if ($this.bytesWrittenToFile() + (long)lineSizeBytes$1 > size.bytes()) {
                $this.roll();
            }
        }
    }

    public FileHandler(String path, Policy rollPolicy, boolean append, int rotateCount, Formatter formatter, Option<Level> level) {
        block4: {
            None$ none$;
            Tuple2 tuple2;
            this.rollPolicy = rollPolicy;
            this.append = append;
            this.rotateCount = rotateCount;
            super(formatter, level);
            File f = new File(path);
            Tuple2 tuple22 = new Tuple2((Object)f.getAbsolutePath(), (Object)f.getName());
            if (tuple22 == null) {
                throw new MatchError((Object)tuple22);
            }
            String filename = (String)tuple22._1();
            String name = (String)tuple22._2();
            Tuple2 tuple23 = new Tuple2((Object)filename, (Object)name);
            this.x$1 = tuple23;
            this.filename = (String)this.x$1._1();
            this.name = (String)this.x$1._2();
            int n = this.filename().lastIndexOf(46);
            Tuple2 tuple24 = tuple2 = n > 0 ? new Tuple2((Object)this.filename().substring(0, n), (Object)this.filename().substring(n)) : new Tuple2((Object)this.filename(), (Object)"");
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String filenamePrefix = (String)tuple2._1();
            String filenameSuffix = (String)tuple2._2();
            Tuple2 tuple25 = new Tuple2((Object)filenamePrefix, (Object)filenameSuffix);
            this.x$2 = tuple25;
            this.filenamePrefix = (String)this.x$2._1();
            this.filenameSuffix = (String)this.x$2._2();
            this.stream = null;
            this.openTime = 0L;
            this.nextRollTime = None$.MODULE$;
            this.bytesWrittenToFile = 0L;
            Policy policy = rollPolicy;
            if (policy instanceof Policy.MaxSize) {
                Policy.MaxSize maxSize = (Policy.MaxSize)policy;
                StorageUnit size = maxSize.size();
                none$ = new Some((Object)size);
            } else {
                none$ = None$.MODULE$;
            }
            this.maxFileSize = none$;
            this.openLog();
            this.examineRollTime = this.nextRollTime().isDefined();
            Policy policy2 = rollPolicy;
            Policy$SigHup$ policy$SigHup$ = Policy$SigHup$.MODULE$;
            if (policy2 != null ? !policy2.equals(policy$SigHup$) : policy$SigHup$ != null) break block4;
            HandleSignal$.MODULE$.apply("HUP", (Function1 & Serializable & scala.Serializable)signal -> {
                FileHandler.$anonfun$new$1(this, signal);
                return BoxedUnit.UNIT;
            });
        }
    }
}

