/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.logging;

import com.twitter.concurrent.NamedPoolThreadFactory;
import com.twitter.conversions.string$;
import com.twitter.finagle.stats.Counter;
import com.twitter.finagle.stats.Gauge;
import com.twitter.finagle.stats.NullStatsReceiver$;
import com.twitter.finagle.stats.StatsReceiver;
import com.twitter.io.Charsets$;
import com.twitter.logging.Formatter;
import com.twitter.logging.Handler;
import com.twitter.logging.Level;
import com.twitter.logging.Logger;
import com.twitter.logging.Retry;
import com.twitter.logging.ScribeHandler$;
import com.twitter.util.Duration;
import com.twitter.util.Time;
import com.twitter.util.Time$;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.LogRecord;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\r=v!B\u0001\u0003\u0011\u0003I\u0011!D*de&\u0014W\rS1oI2,'O\u0003\u0002\u0004\t\u00059An\\4hS:<'BA\u0003\u0007\u0003\u001d!x/\u001b;uKJT\u0011aB\u0001\u0004G>l7\u0001\u0001\t\u0003\u0015-i\u0011A\u0001\u0004\u0006\u0019\tA\t!\u0004\u0002\u000e'\u000e\u0014\u0018NY3IC:$G.\u001a:\u0014\u0005-q\u0001CA\b\u0013\u001b\u0005\u0001\"\"A\t\u0002\u000bM\u001c\u0017\r\\1\n\u0005M\u0001\"AB!osJ+g\rC\u0003\u0016\u0017\u0011\u0005a#\u0001\u0004=S:LGO\u0010\u000b\u0002\u0013!9\u0001d\u0003b\u0001\n\u0003I\u0012AA(L+\u0005Q\u0002CA\b\u001c\u0013\ta\u0002CA\u0002J]RDaAH\u0006!\u0002\u0013Q\u0012aA(LA!9\u0001e\u0003b\u0001\n\u0003I\u0012!\u0003+S3~c\u0015\tV#S\u0011\u0019\u00113\u0002)A\u00055\u0005QAKU-`\u0019\u0006#VI\u0015\u0011\t\u000f\u0011Z!\u0019!C\u0001K\u0005yA)\u001a4bk2$\bj\\:u]\u0006lW-F\u0001'!\t9C&D\u0001)\u0015\tI#&\u0001\u0003mC:<'\"A\u0016\u0002\t)\fg/Y\u0005\u0003[!\u0012aa\u0015;sS:<\u0007BB\u0018\fA\u0003%a%\u0001\tEK\u001a\fW\u000f\u001c;I_N$h.Y7fA!9\u0011g\u0003b\u0001\n\u0003I\u0012a\u0003#fM\u0006,H\u000e\u001e)peRDaaM\u0006!\u0002\u0013Q\u0012\u0001\u0004#fM\u0006,H\u000e\u001e)peR\u0004\u0003bB\u001b\f\u0005\u0004%\t!J\u0001\u0010\t\u00164\u0017-\u001e7u\u0007\u0006$XmZ8ss\"1qg\u0003Q\u0001\n\u0019\n\u0001\u0003R3gCVdGoQ1uK\u001e|'/\u001f\u0011\t\u000feZ!\u0019!C\u0001u\u0005\tB)\u001a4bk2$()\u001e4gKJ$\u0016.\\3\u0016\u0003m\u0002\"\u0001P \u000e\u0003uR!A\u0010\u0003\u0002\tU$\u0018\u000e\\\u0005\u0003\u0001v\u0012\u0001\u0002R;sCRLwN\u001c\u0005\u0007\u0005.\u0001\u000b\u0011B\u001e\u0002%\u0011+g-Y;mi\n+hMZ3s)&lW\r\t\u0005\b\t.\u0011\r\u0011\"\u0001;\u0003U!UMZ1vYR\u001cuN\u001c8fGR\u0014\u0015mY6pM\u001aDaAR\u0006!\u0002\u0013Y\u0014A\u0006#fM\u0006,H\u000e^\"p]:,7\r\u001e\"bG.|gM\u001a\u0011\t\u000f![!\u0019!C\u00013\u0005\u0001C)\u001a4bk2$X*\u0019=NKN\u001c\u0018mZ3t!\u0016\u0014HK]1og\u0006\u001cG/[8o\u0011\u0019Q5\u0002)A\u00055\u0005\tC)\u001a4bk2$X*\u0019=NKN\u001c\u0018mZ3t!\u0016\u0014HK]1og\u0006\u001cG/[8oA!9Aj\u0003b\u0001\n\u0003I\u0012A\u0007#fM\u0006,H\u000e^'bq6+7o]1hKN$vNQ;gM\u0016\u0014\bB\u0002(\fA\u0003%!$A\u000eEK\u001a\fW\u000f\u001c;NCblUm]:bO\u0016\u001cHk\u001c\"vM\u001a,'\u000f\t\u0005\b!.\u0011\r\u0011\"\u0001;\u0003a!UMZ1vYR\u001cF/\u0019;t%\u0016\u0004xN\u001d;QKJLw\u000e\u001a\u0005\u0007%.\u0001\u000b\u0011B\u001e\u00023\u0011+g-Y;miN#\u0018\r^:SKB|'\u000f\u001e)fe&|G\r\t\u0005\b).\u0011\r\u0011\"\u0001V\u0003\rawnZ\u000b\u0002-B\u0011!bV\u0005\u00031\n\u0011a\u0001T8hO\u0016\u0014\bB\u0002.\fA\u0003%a+\u0001\u0003m_\u001e\u0004\u0003\"\u0002/\f\t\u0003i\u0016!B1qa2LH#\u00060\u0004J\r-3QJB(\u0007#\u001a\u0019f!\u0016\u0004X\re31\f\t\u0004\u001f}\u000b\u0017B\u00011\u0011\u0005%1UO\\2uS>t\u0007\u0007\u0005\u0002\u000bE\u001a!AB\u0001\u0001d'\t\u0011G\r\u0005\u0002\u000bK&\u0011aM\u0001\u0002\b\u0011\u0006tG\r\\3s\u0011!A'M!A!\u0002\u0013I\u0017\u0001\u00035pgRt\u0017-\\3\u0011\u0005)lgBA\bl\u0013\ta\u0007#\u0001\u0004Qe\u0016$WMZ\u0005\u0003[9T!\u0001\u001c\t\t\u0011A\u0014'\u0011!Q\u0001\ni\tA\u0001]8si\"A!O\u0019B\u0001B\u0003%\u0011.\u0001\u0005dCR,wm\u001c:z\u0011!!(M!A!\u0002\u0013Y\u0014A\u00032vM\u001a,'\u000fV5nK\"AaO\u0019B\u0001B\u0003%1(\u0001\bd_:tWm\u0019;CC\u000e\\wN\u001a4\t\u0011a\u0014'\u0011!Q\u0001\ni\t\u0011$\\1y\u001b\u0016\u001c8/Y4fgB+'\u000f\u0016:b]N\f7\r^5p]\"A!P\u0019B\u0001B\u0003%!$A\nnCblUm]:bO\u0016\u001cHk\u001c\"vM\u001a,'\u000f\u0003\u0006}E\n\u0005\t\u0015!\u0003~\u0003\u0003\t\u0011BZ8s[\u0006$H/\u001a:\u0011\u0005)q\u0018BA@\u0003\u0005%1uN]7biR,'/\u0003\u0002}K\"a\u0011Q\u00012\u0003\u0002\u0003\u0006I!a\u0002\u0002\u0014\u0005)A.\u001a<fYB)q\"!\u0003\u0002\u000e%\u0019\u00111\u0002\t\u0003\r=\u0003H/[8o!\rQ\u0011qB\u0005\u0004\u0003#\u0011!!\u0002'fm\u0016d\u0017bAA\u0003K\"Q\u0011q\u00032\u0003\u0002\u0003\u0006I!!\u0007\u0002\u001bM$\u0018\r^:SK\u000e,\u0017N^3s!\u0011\tY\"!\n\u000e\u0005\u0005u!\u0002BA\u0010\u0003C\tQa\u001d;biNT1!a\t\u0005\u0003\u001d1\u0017N\\1hY\u0016LA!a\n\u0002\u001e\ti1\u000b^1ugJ+7-Z5wKJDa!\u00062\u0005\u0002\u0005-B#F1\u0002.\u0005=\u0012\u0011GA\u001a\u0003k\t9$!\u000f\u0002<\u0005u\u0012q\b\u0005\u0007Q\u0006%\u0002\u0019A5\t\rA\fI\u00031\u0001\u001b\u0011\u0019\u0011\u0018\u0011\u0006a\u0001S\"1A/!\u000bA\u0002mBaA^A\u0015\u0001\u0004Y\u0004B\u0002=\u0002*\u0001\u0007!\u0004\u0003\u0004{\u0003S\u0001\rA\u0007\u0005\u0007y\u0006%\u0002\u0019A?\t\u0011\u0005\u0015\u0011\u0011\u0006a\u0001\u0003\u000fA\u0001\"a\u0006\u0002*\u0001\u0007\u0011\u0011\u0004\u0005\u0007+\t$\t!a\u0011\u0015'\u0005\f)%a\u0012\u0002J\u0005-\u0013QJA(\u0003#\n\u0019&!\u0016\t\r!\f\t\u00051\u0001j\u0011\u0019\u0001\u0018\u0011\ta\u00015!1!/!\u0011A\u0002%Da\u0001^A!\u0001\u0004Y\u0004B\u0002<\u0002B\u0001\u00071\b\u0003\u0004y\u0003\u0003\u0002\rA\u0007\u0005\u0007u\u0006\u0005\u0003\u0019\u0001\u000e\t\rq\f\t\u00051\u0001~\u0011!\t)!!\u0011A\u0002\u0005\u001d\u0001\u0002CA\u0010E\u0002\u0006I!!\u0017\u0011\t\u0005m\u0013QL\u0007\u0002E\u001a1\u0011q\f2\u0005\u0003C\u0012!cU2sS\n,\u0007*\u00198eY\u0016\u00148\u000b^1ugN\u0019\u0011Q\f\b\t\u0017\u0005]\u0011Q\fB\u0001B\u0003%\u0011\u0011\u0004\u0005\b+\u0005uC\u0011AA4)\u0011\tI&!\u001b\t\u0011\u0005]\u0011Q\ra\u0001\u00033A!\"!\u001c\u0002^\u0001\u0007I\u0011BA8\u00035yF.Y:u\u0019><7\u000b^1ugV\u0011\u0011\u0011\u000f\t\u0004y\u0005M\u0014bAA;{\t!A+[7f\u0011)\tI(!\u0018A\u0002\u0013%\u00111P\u0001\u0012?2\f7\u000f\u001e'pON#\u0018\r^:`I\u0015\fH\u0003BA?\u0003\u0007\u00032aDA@\u0013\r\t\t\t\u0005\u0002\u0005+:LG\u000f\u0003\u0006\u0002\u0006\u0006]\u0014\u0011!a\u0001\u0003c\n1\u0001\u001f\u00132\u0011%\tI)!\u0018!B\u0013\t\t(\u0001\b`Y\u0006\u001cH\u000fT8h'R\fGo\u001d\u0011\t\u0015\u00055\u0015Q\fb\u0001\n\u0013\ty)A\u0006tK:$(+Z2pe\u0012\u001cXCAAI!\u0011\t\u0019*a(\u000e\u0005\u0005U%\u0002BAL\u00033\u000ba!\u0019;p[&\u001c'\u0002BAN\u0003;\u000b!bY8oGV\u0014(/\u001a8u\u0015\tq$&\u0003\u0003\u0002\"\u0006U%AC!u_6L7\rT8oO\"I\u0011QUA/A\u0003%\u0011\u0011S\u0001\rg\u0016tGOU3d_J$7\u000f\t\u0005\u000b\u0003S\u000biF1A\u0005\n\u0005=\u0015A\u00043s_B\u0004X\r\u001a*fG>\u0014Hm\u001d\u0005\n\u0003[\u000bi\u0006)A\u0005\u0003#\u000bq\u0002\u001a:paB,GMU3d_J$7\u000f\t\u0005\u000b\u0003c\u000biF1A\u0005\n\u0005=\u0015!E2p]:,7\r^5p]\u001a\u000b\u0017\u000e\\;sK\"I\u0011QWA/A\u0003%\u0011\u0011S\u0001\u0013G>tg.Z2uS>tg)Y5mkJ,\u0007\u0005\u0003\u0006\u0002:\u0006u#\u0019!C\u0005\u0003\u001f\u000b\u0011cY8o]\u0016\u001cG/[8o'.L\u0007\u000f]3e\u0011%\ti,!\u0018!\u0002\u0013\t\t*\u0001\nd_:tWm\u0019;j_:\u001c6.\u001b9qK\u0012\u0004\u0003BCAa\u0003;\u0012\r\u0011\"\u0001\u0002D\u0006\u0001Bo\u001c;bYN+g\u000e\u001e*fG>\u0014Hm]\u000b\u0003\u0003\u000b\u0004B!a\u0007\u0002H&!\u0011\u0011ZA\u000f\u0005\u001d\u0019u.\u001e8uKJD\u0011\"!4\u0002^\u0001\u0006I!!2\u0002#Q|G/\u00197TK:$(+Z2pe\u0012\u001c\b\u0005\u0003\u0006\u0002R\u0006u#\u0019!C\u0001\u0003\u0007\f1\u0003^8uC2$%o\u001c9qK\u0012\u0014VmY8sIND\u0011\"!6\u0002^\u0001\u0006I!!2\u0002)Q|G/\u00197Ee>\u0004\b/\u001a3SK\u000e|'\u000fZ:!\u0011)\tI.!\u0018C\u0002\u0013\u0005\u00111Y\u0001\u0017i>$\u0018\r\\\"p]:,7\r^5p]\u001a\u000b\u0017\u000e\\;sK\"I\u0011Q\\A/A\u0003%\u0011QY\u0001\u0018i>$\u0018\r\\\"p]:,7\r^5p]\u001a\u000b\u0017\u000e\\;sK\u0002B!\"!9\u0002^\t\u0007I\u0011AAb\u0003Y!x\u000e^1m\u0007>tg.Z2uS>t7k[5qa\u0016$\u0007\"CAs\u0003;\u0002\u000b\u0011BAc\u0003]!x\u000e^1m\u0007>tg.Z2uS>t7k[5qa\u0016$\u0007\u0005\u0003\u0006\u0002j\u0006u#\u0019!C\u0001\u0003\u0007\fQ\u0002^8uC2\u001cuN\u001c8fGR\u001c\b\"CAw\u0003;\u0002\u000b\u0011BAc\u00039!x\u000e^1m\u0007>tg.Z2ug\u0002B!\"!=\u0002^\t\u0007I\u0011AAb\u00039!x\u000e^1m!V\u0014G.[:iK\u0012D\u0011\"!>\u0002^\u0001\u0006I!!2\u0002\u001fQ|G/\u00197Qk\nd\u0017n\u001d5fI\u0002B!\"!?\u0002^\t\u0007I\u0011AAb\u0003-!x\u000e^1m\u00072|7/Z:\t\u0013\u0005u\u0018Q\fQ\u0001\n\u0005\u0015\u0017\u0001\u0004;pi\u0006d7\t\\8tKN\u0004\u0003B\u0003B\u0001\u0003;\u0012\r\u0011\"\u0001\u0003\u0004\u0005I\u0011N\\:uC:\u001cWm]\u000b\u0003\u0005\u000b\u0001B!a\u0007\u0003\b%!!\u0011BA\u000f\u0005\u00159\u0015-^4f\u0011%\u0011i!!\u0018!\u0002\u0013\u0011)!\u0001\u0006j]N$\u0018M\\2fg\u0002B!B!\u0005\u0002^\t\u0007I\u0011\u0001B\u0002\u0003-)hn]3oiF+X-^3\t\u0013\tU\u0011Q\fQ\u0001\n\t\u0015\u0011\u0001D;og\u0016tG/U;fk\u0016\u0004\u0003\u0002\u0003B\r\u0003;\"\tAa\u0007\u0002\u001f%t7M]*f]R\u0014VmY8sIN$B!! \u0003\u001e!9!q\u0004B\f\u0001\u0004Q\u0012!B2pk:$\b\u0002\u0003B\u0012\u0003;\"\tA!\n\u0002%%t7M\u001d#s_B\u0004X\r\u001a*fG>\u0014Hm\u001d\u000b\u0005\u0003{\u00129\u0003C\u0005\u0003 \t\u0005\u0002\u0013!a\u00015!A!1FA/\t\u0003\u0011i#A\u000bj]\u000e\u00148i\u001c8oK\u000e$\u0018n\u001c8GC&dWO]3\u0015\u0005\u0005u\u0004\u0002\u0003B\u0019\u0003;\"\tA!\f\u0002+%t7M]\"p]:,7\r^5p]N[\u0017\u000e\u001d9fI\"A!QGA/\t\u0003\u0011i#A\u0007j]\u000e\u0014\b+\u001e2mSNDW\r\u001a\u0005\t\u0005s\ti\u0006\"\u0001\u0003.\u0005q\u0011N\\2s\u0007>tg.Z2uS>t\u0007\u0002\u0003B\u001f\u0003;\"\tA!\f\u0002\u0015%t7M]\"m_N,7\u000fC\u0004U\u0003;\"\tA!\f\t\u0015\t\r\u0013QLI\u0001\n\u0003\u0011)%\u0001\u000fj]\u000e\u0014HI]8qa\u0016$'+Z2pe\u0012\u001cH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\t\u001d#f\u0001\u000e\u0003J-\u0012!1\n\t\u0005\u0005\u001b\u00129&\u0004\u0002\u0003P)!!\u0011\u000bB*\u0003%)hn\u00195fG.,GMC\u0002\u0003VA\t!\"\u00198o_R\fG/[8o\u0013\u0011\u0011IFa\u0014\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r\u0003\u0005\u0003^\t\u0014\r\u0011\"\u0003&\u0003)awnZ4fe:\u000bW.\u001a\u0005\b\u0005C\u0012\u0007\u0015!\u0003'\u0003-awnZ4fe:\u000bW.\u001a\u0011\t\u0013\t\u0015$\r1A\u0005\n\u0005=\u0014A\u00057bgR\u001cuN\u001c8fGR\fE\u000f^3naRD\u0011B!\u001bc\u0001\u0004%IAa\u001b\u0002-1\f7\u000f^\"p]:,7\r^!ui\u0016l\u0007\u000f^0%KF$B!! \u0003n!Q\u0011Q\u0011B4\u0003\u0003\u0005\r!!\u001d\t\u0011\tE$\r)Q\u0005\u0003c\n1\u0003\\1ti\u000e{gN\\3di\u0006#H/Z7qi\u0002B\u0011B!\u001ec\u0001\u0004%I!a\u001c\u0002#}c\u0017m\u001d;Ue\u0006t7/\\5tg&|g\u000eC\u0005\u0003z\t\u0004\r\u0011\"\u0003\u0003|\u0005)r\f\\1tiR\u0013\u0018M\\:nSN\u001c\u0018n\u001c8`I\u0015\fH\u0003BA?\u0005{B!\"!\"\u0003x\u0005\u0005\t\u0019AA9\u0011!\u0011\tI\u0019Q!\n\u0005E\u0014AE0mCN$HK]1og6L7o]5p]\u0002BCAa \u0003\u0006B\u0019qBa\"\n\u0007\t%\u0005C\u0001\u0005w_2\fG/\u001b7f\u0011!\u0011iI\u0019C\u0001\u0005\t5\u0012AF;qI\u0006$X\rT1tiR\u0013\u0018M\\:nSN\u001c\u0018n\u001c8\t\u0013\tE%\r1A\u0005\n\tM\u0015AB:pG.,G/\u0006\u0002\u0003\u0016B)q\"!\u0003\u0003\u0018B!!\u0011\u0014BP\u001b\t\u0011YJC\u0002\u0003\u001e*\n1A\\3u\u0013\u0011\u0011\tKa'\u0003\rM{7m[3u\u0011%\u0011)K\u0019a\u0001\n\u0013\u00119+\u0001\u0006t_\u000e\\W\r^0%KF$B!! \u0003*\"Q\u0011Q\u0011BR\u0003\u0003\u0005\rA!&\t\u0011\t5&\r)Q\u0005\u0005+\u000bqa]8dW\u0016$\b\u0005C\u0005\u00032\n\u0004\r\u0011\"\u0003\u00034\u0006i\u0011M]2iC&\u001c7+\u001a:wKJ,\"A!.\u0011\u0007=\u00119,C\u0002\u0003:B\u0011qAQ8pY\u0016\fg\u000eC\u0005\u0003>\n\u0004\r\u0011\"\u0003\u0003@\u0006\t\u0012M]2iC&\u001c7+\u001a:wKJ|F%Z9\u0015\t\u0005u$\u0011\u0019\u0005\u000b\u0003\u000b\u0013Y,!AA\u0002\tU\u0006\u0002\u0003BcE\u0002\u0006KA!.\u0002\u001d\u0005\u00148\r[1jGN+'O^3sA!Q!\u0011\u001a2C\u0002\u0013\u0005!Aa3\u0002\u000f\u0019dWo\u001d5feV\u0011!Q\u001a\t\u0005\u0005\u001f\u0014\t.\u0004\u0002\u0002\u001a&!!1[AM\u0005I!\u0006N]3bIB{w\u000e\\#yK\u000e,Ho\u001c:\t\u0011\t]'\r)A\u0005\u0005\u001b\f\u0001B\u001a7vg\",'\u000f\t\u0005\u000b\u00057\u0014'\u0019!C\u0001\u0005\tu\u0017!B9vKV,WC\u0001Bp!\u0019\u0011yM!9\u0003f&!!1]AM\u0005Ma\u0015N\\6fI\ncwnY6j]\u001e\fV/Z;f!\u0015y!q\u001dBv\u0013\r\u0011I\u000f\u0005\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0004\u001f\t5\u0018b\u0001Bx!\t!!)\u001f;f\u0011!\u0011\u0019P\u0019Q\u0001\n\t}\u0017AB9vKV,\u0007\u0005\u0003\u0004\u0003x\n$\t!G\u0001\ncV,W/Z*ju\u0016DqAa?c\t\u0003\u0012i#A\u0003gYV\u001c\b\u000e\u0003\u0005\u0003\u0000\n$\tAAB\u0001\u0003)i\u0017m[3Ck\u001a4WM\u001d\u000b\u0005\u0007\u0007\u0019y\u0001\u0005\u0003\u0004\u0006\r-QBAB\u0004\u0015\r\u0019IAK\u0001\u0004]&|\u0017\u0002BB\u0007\u0007\u000f\u0011!BQ=uK\n+hMZ3s\u0011\u001d\u0011yB!@A\u0002iAqaa\u0005c\t\u0013\u0011i#A\u0006dY>\u001cXmU8dW\u0016$\bbBB\fE\u0012\u0005#QF\u0001\u0006G2|7/\u001a\u0005\b\u00077\u0011G\u0011IB\u000f\u0003\u001d\u0001XO\u00197jg\"$B!! \u0004 !A1\u0011EB\r\u0001\u0004\u0019\u0019#\u0001\u0004sK\u000e|'\u000f\u001a\t\u0005\u0007K\u0019I#\u0004\u0002\u0004()\u00191!!(\n\t\r-2q\u0005\u0002\n\u0019><'+Z2pe\u0012Dqaa\u0007c\t\u0003\u0019y\u0003\u0006\u0003\u0002~\rE\u0002\u0002CB\u0011\u0007[\u0001\rA!:\t\u000f\rU\"\r\"\u0011\u00048\u0005AAo\\*ue&tw\rF\u0001j\u0011!\u0019YD\u0019Q\u0001\n\t\u0015\u0018!D*D%&\u0013Ui\u0018)S\u000b\u001aK\u0005\f\u0003\u0005\u0004@\t\u0004\u000b\u0011\u0002Bs\u0003EyE\nR0T\u0007JK%)R0Q%\u00163\u0015\n\u0017\u0005\t\u0007\u0007\u0012\u0007\u0015!\u0003\u0003f\u0006a1k\u0011*J\u0005\u0016{&+\u0012)M3\"A1q\t2!\u0002\u0013\u0011)/\u0001\tP\u0019\u0012{6k\u0011*J\u0005\u0016{&+\u0012)M3\"9\u0001n\u0017I\u0001\u0002\u0004I\u0007b\u00029\\!\u0003\u0005\rA\u0007\u0005\ben\u0003\n\u00111\u0001j\u0011\u001d!8\f%AA\u0002mBqA^.\u0011\u0002\u0003\u00071\bC\u0004y7B\u0005\t\u0019\u0001\u000e\t\u000fi\\\u0006\u0013!a\u00015!9Ap\u0017I\u0001\u0002\u0004i\b\"CA\u00037B\u0005\t\u0019AA\u0004\u0011%\t9b\u0017I\u0001\u0002\u0004\tI\u0002\u0003\u0004]\u0017\u0011\u00051q\f\u000b\u0014=\u000e\u000541MB3\u0007O\u001aIga\u001b\u0004n\r=4\u0011\u000f\u0005\u0007Q\u000eu\u0003\u0019A5\t\rA\u001ci\u00061\u0001\u001b\u0011\u0019\u00118Q\fa\u0001S\"1Ao!\u0018A\u0002mBaA^B/\u0001\u0004Y\u0004B\u0002=\u0004^\u0001\u0007!\u0004\u0003\u0004{\u0007;\u0002\rA\u0007\u0005\u0007y\u000eu\u0003\u0019A?\t\u0011\u0005\u00151Q\fa\u0001\u0003\u000fA\u0011b!\u001e\f#\u0003%\taa\u001e\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uIE*\"a!\u001f+\u0007%\u0014I\u0005C\u0005\u0004~-\t\n\u0011\"\u0001\u0003F\u0005y\u0011\r\u001d9ms\u0012\"WMZ1vYR$#\u0007C\u0005\u0004\u0002.\t\n\u0011\"\u0001\u0004x\u0005y\u0011\r\u001d9ms\u0012\"WMZ1vYR$3\u0007C\u0005\u0004\u0006.\t\n\u0011\"\u0001\u0004\b\u0006y\u0011\r\u001d9ms\u0012\"WMZ1vYR$C'\u0006\u0002\u0004\n*\u001a1H!\u0013\t\u0013\r55\"%A\u0005\u0002\r\u001d\u0015aD1qa2LH\u0005Z3gCVdG\u000fJ\u001b\t\u0013\rE5\"%A\u0005\u0002\t\u0015\u0013aD1qa2LH\u0005Z3gCVdG\u000f\n\u001c\t\u0013\rU5\"%A\u0005\u0002\t\u0015\u0013aD1qa2LH\u0005Z3gCVdG\u000fJ\u001c\t\u0013\re5\"%A\u0005\u0002\rm\u0015aD1qa2LH\u0005Z3gCVdG\u000f\n\u001d\u0016\u0005\ru%fA?\u0003J!I1\u0011U\u0006\u0012\u0002\u0013\u000511U\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%sU\u00111Q\u0015\u0016\u0005\u0003\u000f\u0011I\u0005C\u0005\u0004*.\t\n\u0011\"\u0001\u0004,\u0006\u0001\u0012\r\u001d9ms\u0012\"WMZ1vYR$\u0013\u0007M\u000b\u0003\u0007[SC!!\u0007\u0003J\u0001")
public class ScribeHandler
extends Handler {
    public final String com$twitter$logging$ScribeHandler$$hostname;
    public final int com$twitter$logging$ScribeHandler$$port;
    public final String com$twitter$logging$ScribeHandler$$category;
    private final Duration bufferTime;
    private final Duration connectBackoff;
    public final int com$twitter$logging$ScribeHandler$$maxMessagesPerTransaction;
    public final ScribeHandlerStats com$twitter$logging$ScribeHandler$$stats;
    private final String loggerName;
    private Time com$twitter$logging$ScribeHandler$$lastConnectAttempt;
    private volatile Time _lastTransmission;
    private Option<Socket> com$twitter$logging$ScribeHandler$$socket;
    private boolean com$twitter$logging$ScribeHandler$$archaicServer;
    private final ThreadPoolExecutor flusher;
    private final LinkedBlockingQueue<byte[]> queue;
    private final byte[] SCRIBE_PREFIX;
    private final byte[] OLD_SCRIBE_PREFIX;
    public final byte[] com$twitter$logging$ScribeHandler$$SCRIBE_REPLY;
    public final byte[] com$twitter$logging$ScribeHandler$$OLD_SCRIBE_REPLY;

    public static StatsReceiver apply$default$10() {
        return ScribeHandler$.MODULE$.apply$default$10();
    }

    public static Option<Level> apply$default$9() {
        return ScribeHandler$.MODULE$.apply$default$9();
    }

    public static Formatter apply$default$8() {
        return ScribeHandler$.MODULE$.apply$default$8();
    }

    public static int apply$default$7() {
        return ScribeHandler$.MODULE$.apply$default$7();
    }

    public static int apply$default$6() {
        return ScribeHandler$.MODULE$.apply$default$6();
    }

    public static Duration apply$default$5() {
        return ScribeHandler$.MODULE$.apply$default$5();
    }

    public static Duration apply$default$4() {
        return ScribeHandler$.MODULE$.apply$default$4();
    }

    public static String apply$default$3() {
        return ScribeHandler$.MODULE$.apply$default$3();
    }

    public static int apply$default$2() {
        return ScribeHandler$.MODULE$.apply$default$2();
    }

    public static String apply$default$1() {
        return ScribeHandler$.MODULE$.apply$default$1();
    }

    public static Function0<ScribeHandler> apply(String string, int n, String string2, Duration duration, Duration duration2, int n2, int n3, Formatter formatter, Option<Level> option) {
        return ScribeHandler$.MODULE$.apply(string, n, string2, duration, duration2, n2, n3, formatter, option);
    }

    public static Function0<ScribeHandler> apply(String string, int n, String string2, Duration duration, Duration duration2, int n2, int n3, Formatter formatter, Option<Level> option, StatsReceiver statsReceiver) {
        return ScribeHandler$.MODULE$.apply(string, n, string2, duration, duration2, n2, n3, formatter, option, statsReceiver);
    }

    public static Logger log() {
        return ScribeHandler$.MODULE$.log();
    }

    public static Duration DefaultStatsReportPeriod() {
        return ScribeHandler$.MODULE$.DefaultStatsReportPeriod();
    }

    public static int DefaultMaxMessagesToBuffer() {
        return ScribeHandler$.MODULE$.DefaultMaxMessagesToBuffer();
    }

    public static int DefaultMaxMessagesPerTransaction() {
        return ScribeHandler$.MODULE$.DefaultMaxMessagesPerTransaction();
    }

    public static Duration DefaultConnectBackoff() {
        return ScribeHandler$.MODULE$.DefaultConnectBackoff();
    }

    public static Duration DefaultBufferTime() {
        return ScribeHandler$.MODULE$.DefaultBufferTime();
    }

    public static String DefaultCategory() {
        return ScribeHandler$.MODULE$.DefaultCategory();
    }

    public static int DefaultPort() {
        return ScribeHandler$.MODULE$.DefaultPort();
    }

    public static String DefaultHostname() {
        return ScribeHandler$.MODULE$.DefaultHostname();
    }

    public static int TRY_LATER() {
        return ScribeHandler$.MODULE$.TRY_LATER();
    }

    public static int OK() {
        return ScribeHandler$.MODULE$.OK();
    }

    private String loggerName() {
        return this.loggerName;
    }

    private Time com$twitter$logging$ScribeHandler$$lastConnectAttempt() {
        return this.com$twitter$logging$ScribeHandler$$lastConnectAttempt;
    }

    public void com$twitter$logging$ScribeHandler$$lastConnectAttempt_$eq(Time x$1) {
        this.com$twitter$logging$ScribeHandler$$lastConnectAttempt = x$1;
    }

    private Time _lastTransmission() {
        return this._lastTransmission;
    }

    private void _lastTransmission_$eq(Time x$1) {
        this._lastTransmission = x$1;
    }

    public void updateLastTransmission() {
        this._lastTransmission_$eq(Time$.MODULE$.now());
    }

    public Option<Socket> com$twitter$logging$ScribeHandler$$socket() {
        return this.com$twitter$logging$ScribeHandler$$socket;
    }

    private void com$twitter$logging$ScribeHandler$$socket_$eq(Option<Socket> x$1) {
        this.com$twitter$logging$ScribeHandler$$socket = x$1;
    }

    public boolean com$twitter$logging$ScribeHandler$$archaicServer() {
        return this.com$twitter$logging$ScribeHandler$$archaicServer;
    }

    public void com$twitter$logging$ScribeHandler$$archaicServer_$eq(boolean x$1) {
        this.com$twitter$logging$ScribeHandler$$archaicServer = x$1;
    }

    public ThreadPoolExecutor flusher() {
        return this.flusher;
    }

    public LinkedBlockingQueue<byte[]> queue() {
        return this.queue;
    }

    public int queueSize() {
        return this.queue().size();
    }

    @Override
    public void flush() {
        this.flusher().execute(new Runnable(this){
            private final /* synthetic */ ScribeHandler $outer;

            public void run() {
                this.$outer.com$twitter$logging$ScribeHandler$$sendBatch$1();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public ByteBuffer makeBuffer(int count) {
        IndexedSeq texts = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), count).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ScribeHandler $outer;

            public final byte[] apply(int i) {
                return this.$outer.queue().poll();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        ByteBuffer recordHeader = ByteBuffer.wrap(new byte[10 + this.com$twitter$logging$ScribeHandler$$category.length()]);
        recordHeader.order(ByteOrder.BIG_ENDIAN);
        recordHeader.put((byte)11);
        recordHeader.putShort((short)1);
        recordHeader.putInt(this.com$twitter$logging$ScribeHandler$$category.length());
        recordHeader.put(this.com$twitter$logging$ScribeHandler$$category.getBytes(Charsets$.MODULE$.Iso8859_1()));
        recordHeader.put((byte)11);
        recordHeader.putShort((short)2);
        byte[] prefix = this.com$twitter$logging$ScribeHandler$$archaicServer() ? this.OLD_SCRIBE_PREFIX : this.SCRIBE_PREFIX;
        int messageSize = count * (recordHeader.capacity() + 5) + BoxesRunTime.unboxToInt((Object)texts.foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(int x$1, byte[] x$2) {
                return x$1 + x$2.length;
            }
        })) + prefix.length + 5;
        ByteBuffer buffer = ByteBuffer.wrap(new byte[messageSize + 4]);
        buffer.order(ByteOrder.BIG_ENDIAN);
        buffer.putInt(messageSize);
        buffer.put(prefix);
        buffer.putInt(count);
        texts.foreach((Function1)new Serializable(this, recordHeader, buffer){
            public static final long serialVersionUID = 0L;
            private final ByteBuffer recordHeader$1;
            private final ByteBuffer buffer$1;

            public final ByteBuffer apply(byte[] text) {
                this.buffer$1.put(this.recordHeader$1.array());
                this.buffer$1.putInt(text.length);
                this.buffer$1.put(text);
                return this.buffer$1.put((byte)0);
            }
            {
                this.recordHeader$1 = recordHeader$1;
                this.buffer$1 = buffer$1;
            }
        });
        buffer.put((byte)0);
        return buffer;
    }

    public synchronized void com$twitter$logging$ScribeHandler$$closeSocket() {
        this.com$twitter$logging$ScribeHandler$$socket().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Socket s) {
                try {
                    s.close();
                }
                catch (Throwable throwable) {}
            }
        });
        this.com$twitter$logging$ScribeHandler$$socket_$eq((Option<Socket>)None$.MODULE$);
    }

    @Override
    public void close() {
        this.com$twitter$logging$ScribeHandler$$stats.incrCloses();
        this.com$twitter$logging$ScribeHandler$$closeSocket();
        this.flusher().shutdown();
    }

    @Override
    public void publish(LogRecord record) {
        String string = record.getLoggerName();
        String string2 = this.loggerName();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            return;
        }
        this.publish(this.getFormatter().format(record).getBytes("UTF-8"));
    }

    public void publish(byte[] record) {
        this.com$twitter$logging$ScribeHandler$$stats.incrPublished();
        if (!this.queue().offer(record)) {
            this.com$twitter$logging$ScribeHandler$$stats.incrDroppedRecords(this.com$twitter$logging$ScribeHandler$$stats.incrDroppedRecords$default$1());
        }
        if (Time$.MODULE$.now().since(this._lastTransmission()).$greater$eq((Object)this.bufferTime)) {
            this.flush();
        }
    }

    @Override
    public String toString() {
        return new StringOps(Predef$.MODULE$.augmentString("<%s level=%s hostname=%s port=%d scribe_buffer=%s scribe_backoff=%s scribe_max_packet_size=%d formatter=%s>")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.getClass().getName(), this.getLevel(), this.com$twitter$logging$ScribeHandler$$hostname, BoxesRunTime.boxToInteger((int)this.com$twitter$logging$ScribeHandler$$port), this.bufferTime, this.connectBackoff, BoxesRunTime.boxToInteger((int)this.com$twitter$logging$ScribeHandler$$maxMessagesPerTransaction), super.formatter().toString()}));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void connect$1() {
        if (this.com$twitter$logging$ScribeHandler$$socket().isDefined()) return;
        if (!Time$.MODULE$.now().since(this.com$twitter$logging$ScribeHandler$$lastConnectAttempt()).$greater((Object)this.connectBackoff)) {
            this.com$twitter$logging$ScribeHandler$$stats.incrConnectionSkipped();
            return;
        }
        try {
            this.com$twitter$logging$ScribeHandler$$lastConnectAttempt_$eq(Time$.MODULE$.now());
            this.com$twitter$logging$ScribeHandler$$socket_$eq((Option<Socket>)new Some((Object)new Socket(this.com$twitter$logging$ScribeHandler$$hostname, this.com$twitter$logging$ScribeHandler$$port)));
            this.com$twitter$logging$ScribeHandler$$stats.incrConnection();
            return;
        }
        catch (Exception exception) {
            ScribeHandler$.MODULE$.log().error("Unable to open socket to scribe server at %s:%d: %s", (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.com$twitter$logging$ScribeHandler$$hostname, BoxesRunTime.boxToInteger((int)this.com$twitter$logging$ScribeHandler$$port), exception}));
            this.com$twitter$logging$ScribeHandler$$stats.incrConnectionFailure();
        }
    }

    public final synchronized void com$twitter$logging$ScribeHandler$$sendBatch$1() {
        this.connect$1();
        this.com$twitter$logging$ScribeHandler$$socket().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ScribeHandler $outer;

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * WARNING - void declaration
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public final void apply(Socket s) {
                OutputStream outStream = s.getOutputStream();
                InputStream inStream = s.getInputStream();
                int remaining = this.$outer.queue().size();
                while (remaining > 0 && this.$outer.com$twitter$logging$ScribeHandler$$socket().isDefined()) {
                    int count = RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(this.$outer.com$twitter$logging$ScribeHandler$$maxMessagesPerTransaction), remaining);
                    ByteBuffer buffer = this.$outer.makeBuffer(count);
                    int offset = 0;
                    try {
                        outStream.write(buffer.array());
                        byte[] expectedReply = this.$outer.com$twitter$logging$ScribeHandler$$archaicServer() ? this.$outer.com$twitter$logging$ScribeHandler$$OLD_SCRIBE_REPLY : this.$outer.com$twitter$logging$ScribeHandler$$SCRIBE_REPLY;
                        byte[] response = new byte[expectedReply.length];
                        while (offset < response.length) {
                            int n = inStream.read(response, offset, response.length - offset);
                            if (n < 0) {
                                throw new IOException("End of stream");
                            }
                            if (this.$outer.com$twitter$logging$ScribeHandler$$archaicServer() || (offset += n) <= 0 || response[0] != 0) continue;
                            this.$outer.com$twitter$logging$ScribeHandler$$archaicServer_$eq(true);
                            this.$outer.com$twitter$logging$ScribeHandler$$lastConnectAttempt_$eq(Time$.MODULE$.epoch());
                            ScribeHandler$.MODULE$.log().debug("Scribe server is archaic; changing to old protocol for future requests.", (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
                            throw new Retry();
                        }
                        if (!Arrays.equals(response, expectedReply)) {
                            void var10_10;
                            throw new IOException(new StringBuilder().append((Object)"Error response from scribe server: ").append((Object)string$.MODULE$.byteArrayToConfiggyByteArray((byte[])var10_10).hexlify()).toString());
                        }
                        this.$outer.com$twitter$logging$ScribeHandler$$stats.incrSentRecords(count);
                        remaining -= count;
                    }
                    catch (Exception exception) {
                        this.$outer.com$twitter$logging$ScribeHandler$$stats.incrDroppedRecords(count);
                        ScribeHandler$.MODULE$.log().error((Throwable)exception, "Failed to send %s %d log entries to scribe server at %s:%d", (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.com$twitter$logging$ScribeHandler$$category, BoxesRunTime.boxToInteger((int)count), this.$outer.com$twitter$logging$ScribeHandler$$hostname, BoxesRunTime.boxToInteger((int)this.$outer.com$twitter$logging$ScribeHandler$$port)}));
                        this.$outer.com$twitter$logging$ScribeHandler$$closeSocket();
                    }
                }
                this.$outer.updateLastTransmission();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.com$twitter$logging$ScribeHandler$$stats.log();
    }

    public ScribeHandler(String hostname, int port, String category, Duration bufferTime, Duration connectBackoff, int maxMessagesPerTransaction, int maxMessagesToBuffer, Formatter formatter, Option<Level> level, StatsReceiver statsReceiver) {
        this.com$twitter$logging$ScribeHandler$$hostname = hostname;
        this.com$twitter$logging$ScribeHandler$$port = port;
        this.com$twitter$logging$ScribeHandler$$category = category;
        this.bufferTime = bufferTime;
        this.connectBackoff = connectBackoff;
        this.com$twitter$logging$ScribeHandler$$maxMessagesPerTransaction = maxMessagesPerTransaction;
        super(formatter, level);
        this.com$twitter$logging$ScribeHandler$$stats = new ScribeHandlerStats(statsReceiver);
        this.loggerName = this.getClass().toString();
        this.com$twitter$logging$ScribeHandler$$lastConnectAttempt = Time$.MODULE$.epoch();
        this._lastTransmission = Time$.MODULE$.epoch();
        this.com$twitter$logging$ScribeHandler$$socket = None$.MODULE$;
        this.com$twitter$logging$ScribeHandler$$archaicServer = false;
        NamedPoolThreadFactory threadFactory = new NamedPoolThreadFactory(new StringBuilder().append((Object)"ScribeFlusher-").append((Object)category).toString(), true);
        ArrayBlockingQueue<Runnable> queue = new ArrayBlockingQueue<Runnable>(5);
        ThreadPoolExecutor.DiscardPolicy rejectionHandler = new ThreadPoolExecutor.DiscardPolicy();
        this.flusher = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, queue, (ThreadFactory)threadFactory, rejectionHandler);
        this.queue = new LinkedBlockingQueue(maxMessagesToBuffer);
        this.SCRIBE_PREFIX = (byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{(byte)128, 1, 0, 1, 0, 0, 0, 3, (byte)76, (byte)111, (byte)103, 0, 0, 0, 0, 15, 0, 1, 12}), ClassTag$.MODULE$.Byte());
        this.OLD_SCRIBE_PREFIX = (byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{0, 0, 0, 3, (byte)76, (byte)111, (byte)103, 1, 0, 0, 0, 0, 15, 0, 1, 12}), ClassTag$.MODULE$.Byte());
        this.com$twitter$logging$ScribeHandler$$SCRIBE_REPLY = (byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{(byte)128, 1, 0, 2, 0, 0, 0, 3, (byte)76, (byte)111, (byte)103, 0, 0, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0}), ClassTag$.MODULE$.Byte());
        this.com$twitter$logging$ScribeHandler$$OLD_SCRIBE_REPLY = (byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{0, 0, 0, 20, 0, 0, 0, 3, (byte)76, (byte)111, (byte)103, 2, 0, 0, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0}), ClassTag$.MODULE$.Byte());
    }

    public ScribeHandler(String hostname, int port, String category, Duration bufferTime, Duration connectBackoff, int maxMessagesPerTransaction, int maxMessagesToBuffer, Formatter formatter, Option<Level> level) {
        this(hostname, port, category, bufferTime, connectBackoff, maxMessagesPerTransaction, maxMessagesToBuffer, formatter, level, (StatsReceiver)NullStatsReceiver$.MODULE$);
    }

    public class ScribeHandlerStats {
        private Time _lastLogStats;
        private final AtomicLong sentRecords;
        private final AtomicLong droppedRecords;
        private final AtomicLong connectionFailure;
        private final AtomicLong connectionSkipped;
        private final Counter totalSentRecords;
        private final Counter totalDroppedRecords;
        private final Counter totalConnectionFailure;
        private final Counter totalConnectionSkipped;
        private final Counter totalConnects;
        private final Counter totalPublished;
        private final Counter totalCloses;
        private final Gauge instances;
        private final Gauge unsentQueue;

        private Time _lastLogStats() {
            return this._lastLogStats;
        }

        private void _lastLogStats_$eq(Time x$1) {
            this._lastLogStats = x$1;
        }

        private AtomicLong sentRecords() {
            return this.sentRecords;
        }

        private AtomicLong droppedRecords() {
            return this.droppedRecords;
        }

        private AtomicLong connectionFailure() {
            return this.connectionFailure;
        }

        private AtomicLong connectionSkipped() {
            return this.connectionSkipped;
        }

        public Counter totalSentRecords() {
            return this.totalSentRecords;
        }

        public Counter totalDroppedRecords() {
            return this.totalDroppedRecords;
        }

        public Counter totalConnectionFailure() {
            return this.totalConnectionFailure;
        }

        public Counter totalConnectionSkipped() {
            return this.totalConnectionSkipped;
        }

        public Counter totalConnects() {
            return this.totalConnects;
        }

        public Counter totalPublished() {
            return this.totalPublished;
        }

        public Counter totalCloses() {
            return this.totalCloses;
        }

        public Gauge instances() {
            return this.instances;
        }

        public Gauge unsentQueue() {
            return this.unsentQueue;
        }

        public void incrSentRecords(int count) {
            this.sentRecords().addAndGet(count);
            this.totalSentRecords().incr(count);
        }

        public void incrDroppedRecords(int count) {
            this.droppedRecords().incrementAndGet();
            this.totalDroppedRecords().incr();
        }

        public int incrDroppedRecords$default$1() {
            return 1;
        }

        public void incrConnectionFailure() {
            this.connectionFailure().incrementAndGet();
            this.totalConnectionFailure().incr();
        }

        public void incrConnectionSkipped() {
            this.connectionSkipped().incrementAndGet();
            this.totalConnectionSkipped().incr();
        }

        public void incrPublished() {
            this.totalPublished().incr();
        }

        public void incrConnection() {
            this.totalConnects().incr();
        }

        public void incrCloses() {
            this.totalCloses().incr();
        }

        public synchronized void log() {
            Duration period = Time$.MODULE$.now().since(this._lastLogStats());
            if (period.$greater((Object)ScribeHandler$.MODULE$.DefaultStatsReportPeriod())) {
                long sent = this.sentRecords().getAndSet(0L);
                long dropped = this.droppedRecords().getAndSet(0L);
                long failed = this.connectionFailure().getAndSet(0L);
                long skipped = this.connectionSkipped().getAndSet(0L);
                ScribeHandler$.MODULE$.log().info("sent records: %d, per second: %d, dropped records: %d, reconnection failures: %d, reconnection skipped: %d", (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)sent), BoxesRunTime.boxToLong((long)(sent / (long)period.inSeconds())), BoxesRunTime.boxToLong((long)dropped), BoxesRunTime.boxToLong((long)failed), BoxesRunTime.boxToLong((long)skipped)}));
                this._lastLogStats_$eq(Time$.MODULE$.now());
            }
        }

        public /* synthetic */ ScribeHandler com$twitter$logging$ScribeHandler$ScribeHandlerStats$$$outer() {
            return ScribeHandler.this;
        }

        public ScribeHandlerStats(StatsReceiver statsReceiver) {
            if (ScribeHandler.this == null) {
                throw null;
            }
            this._lastLogStats = Time$.MODULE$.epoch();
            this.sentRecords = new AtomicLong();
            this.droppedRecords = new AtomicLong();
            this.connectionFailure = new AtomicLong();
            this.connectionSkipped = new AtomicLong();
            this.totalSentRecords = statsReceiver.counter((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"sent_records"}));
            this.totalDroppedRecords = statsReceiver.counter((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"dropped_records"}));
            this.totalConnectionFailure = statsReceiver.counter((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"connection_failed"}));
            this.totalConnectionSkipped = statsReceiver.counter((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"connection_skipped"}));
            this.totalConnects = statsReceiver.counter((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"connects"}));
            this.totalPublished = statsReceiver.counter((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"published"}));
            this.totalCloses = statsReceiver.counter((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"closes"}));
            this.instances = statsReceiver.addGauge((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"instances"}), (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final float apply() {
                    return this.apply$mcF$sp();
                }

                public float apply$mcF$sp() {
                    return 1.0f;
                }
            });
            this.unsentQueue = statsReceiver.addGauge((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"unsent_queue"}), (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ScribeHandlerStats $outer;

                public final float apply() {
                    return this.apply$mcF$sp();
                }

                public float apply$mcF$sp() {
                    return this.$outer.com$twitter$logging$ScribeHandler$ScribeHandlerStats$$$outer().queueSize();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        }
    }
}

