/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.logging;

import com.twitter.logging.Handler;
import com.twitter.logging.Logger;
import com.twitter.logging.Logger$;
import com.twitter.logging.QueueingHandler$;
import com.twitter.util.Time$;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.LogRecord;
import scala.Console$;
import scala.Function0;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005}q!B\u0001\u0003\u0011\u0003I\u0011aD)vKV,\u0017N\\4IC:$G.\u001a:\u000b\u0005\r!\u0011a\u00027pO\u001eLgn\u001a\u0006\u0003\u000b\u0019\tq\u0001^<jiR,'OC\u0001\b\u0003\r\u0019w.\\\u0002\u0001!\tQ1\"D\u0001\u0003\r\u0015a!\u0001#\u0001\u000e\u0005=\tV/Z;fS:<\u0007*\u00198eY\u0016\u00148CA\u0006\u000f!\ty!#D\u0001\u0011\u0015\u0005\t\u0012!B:dC2\f\u0017BA\n\u0011\u0005\u0019\te.\u001f*fM\")Qc\u0003C\u0001-\u00051A(\u001b8jiz\"\u0012!\u0003\u0005\u00061-!\t!G\u0001\u0006CB\u0004H.\u001f\u000b\u00045]|\bcA\b\u001c;%\u0011A\u0004\u0005\u0002\n\rVt7\r^5p]B\u0002\"A\u0003\u0010\u0007\t1\u0011\u0001aH\n\u0003=\u0001\u0002\"AC\u0011\n\u0005\t\u0012!a\u0002%b]\u0012dWM\u001d\u0005\tIy\u0011)\u0019!C\u0001K\u00059\u0001.\u00198eY\u0016\u0014X#\u0001\u0011\t\u0011\u001dr\"\u0011!Q\u0001\n\u0001\n\u0001\u0002[1oI2,'\u000f\t\u0005\tSy\u0011)\u0019!C\u0001U\u0005aQ.\u0019=Rk\u0016,XmU5{KV\t1\u0006\u0005\u0002\u0010Y%\u0011Q\u0006\u0005\u0002\u0004\u0013:$\b\u0002C\u0018\u001f\u0005\u0003\u0005\u000b\u0011B\u0016\u0002\u001b5\f\u00070U;fk\u0016\u001c\u0016N_3!\u0011\u0015)b\u0004\"\u00012)\ri\"g\r\u0005\u0006IA\u0002\r\u0001\t\u0005\bSA\u0002\n\u00111\u0001,\u0011\u001d)dD1A\u0005\u0012Y\n1\u0002\u001a:pa2{wMT8eKV\tq\u0007\u0005\u00029w9\u0011q\"O\u0005\u0003uA\ta\u0001\u0015:fI\u00164\u0017B\u0001\u001f>\u0005\u0019\u0019FO]5oO*\u0011!\b\u0005\u0005\u0007\u007fy\u0001\u000b\u0011B\u001c\u0002\u0019\u0011\u0014x\u000e\u001d'pO:{G-\u001a\u0011\t\u000f\u0005s\"\u0019!C\t\u0005\u0006\u0019An\\4\u0016\u0003\r\u0003\"A\u0003#\n\u0005\u0015\u0013!A\u0002'pO\u001e,'\u000f\u0003\u0004H=\u0001\u0006IaQ\u0001\u0005Y><\u0007\u0005\u0003\u0004J=\u0001\u0006IAS\u0001\u0006cV,W/\u001a\t\u0004\u0017J#V\"\u0001'\u000b\u00055s\u0015AC2p]\u000e,(O]3oi*\u0011q\nU\u0001\u0005kRLGNC\u0001R\u0003\u0011Q\u0017M^1\n\u0005Mc%a\u0005'j].,GM\u00117pG.LgnZ)vKV,\u0007CA+X\u001b\u00051&BA\u0002O\u0013\tAfKA\u0005M_\u001e\u0014VmY8sI\"1!L\bQ\u0001\nm\u000ba\u0001\u001e5sK\u0006$\u0007C\u0001/`\u001b\u0005i&B\u00010Q\u0003\u0011a\u0017M\\4\n\u0005\u0001l&A\u0002+ie\u0016\fG\r\u0003\u0004c=\u0001\u0006IaY\u0001\u000bG2|7/\u001a'bi\u000eD\u0007CA&e\u0013\t)GJ\u0001\bD_VtG\u000fR8x]2\u000bGo\u00195\t\u000b\u001dtB\u0011\u00015\u0002\u000fA,(\r\\5tQR\u0011\u0011\u000e\u001c\t\u0003\u001f)L!a\u001b\t\u0003\tUs\u0017\u000e\u001e\u0005\u0006[\u001a\u0004\r\u0001V\u0001\u0007e\u0016\u001cwN\u001d3\t\u000b=tB\u0011\u00019\u0002\u000b\rdwn]3\u0015\u0003%DQA\u001d\u0010\u0005\u0002A\fQA\u001a7vg\"DQ\u0001\u001e\u0010\u0005\u0012U\f!b\u001c8Pm\u0016\u0014h\r\\8x)\tIg\u000fC\u0003ng\u0002\u0007A\u000bC\u0003%/\u0001\u0007\u0001\u0010\u0005\u0002zy:\u0011!B_\u0005\u0003w\n\tq\u0001]1dW\u0006<W-\u0003\u0002~}\nq\u0001*\u00198eY\u0016\u0014h)Y2u_JL(BA>\u0003\u0011\u001dIs\u0003%AA\u0002-B\u0011\"a\u0001\f#\u0003%\t!!\u0002\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uII*\"!a\u0002+\u0007-\nIa\u000b\u0002\u0002\fA!\u0011QBA\f\u001b\t\tyA\u0003\u0003\u0002\u0012\u0005M\u0011!C;oG\",7m[3e\u0015\r\t)\u0002E\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\r\u0003\u001f\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011%\tibCI\u0001\n\u0003\t)!A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HE\r")
public class QueueingHandler
extends Handler {
    private final Handler handler;
    private final int maxQueueSize;
    private final String dropLogNode;
    private final Logger log;
    public final LinkedBlockingQueue<LogRecord> com$twitter$logging$QueueingHandler$$queue;
    private final Thread thread;
    public final CountDownLatch com$twitter$logging$QueueingHandler$$closeLatch;

    public static int $lessinit$greater$default$2() {
        return QueueingHandler$.MODULE$.$lessinit$greater$default$2();
    }

    public static int apply$default$2() {
        return QueueingHandler$.MODULE$.apply$default$2();
    }

    public static Function0<QueueingHandler> apply(Function0<Handler> function0, int n) {
        return QueueingHandler$.MODULE$.apply(function0, n);
    }

    public Handler handler() {
        return this.handler;
    }

    public int maxQueueSize() {
        return this.maxQueueSize;
    }

    public String dropLogNode() {
        return this.dropLogNode;
    }

    public Logger log() {
        return this.log;
    }

    @Override
    public void publish(LogRecord record) {
        if (!this.com$twitter$logging$QueueingHandler$$queue.offer(record)) {
            this.onOverflow(record);
        }
    }

    @Override
    public void close() {
        this.thread.interrupt();
        this.com$twitter$logging$QueueingHandler$$closeLatch.await();
        this.handler().close();
    }

    @Override
    public void flush() {
        LogRecord record = this.com$twitter$logging$QueueingHandler$$queue.poll();
        while (record != null) {
            this.handler().publish(record);
            record = this.com$twitter$logging$QueueingHandler$$queue.poll();
        }
        this.handler().flush();
    }

    public void onOverflow(LogRecord record) {
        Console$.MODULE$.err().println(String.format("[%s] log queue overflow - record dropped", Time$.MODULE$.now().toString()));
    }

    public QueueingHandler(Handler handler, int maxQueueSize) {
        this.handler = handler;
        this.maxQueueSize = maxQueueSize;
        super(handler.formatter(), handler.level());
        this.dropLogNode = "";
        this.log = Logger$.MODULE$.apply(this.dropLogNode());
        this.com$twitter$logging$QueueingHandler$$queue = new LinkedBlockingQueue(maxQueueSize);
        this.thread = new $anon$1(this);
        this.com$twitter$logging$QueueingHandler$$closeLatch = new CountDownLatch(1);
        this.thread.setDaemon(true);
        this.thread.setName("QueueingHandler");
        this.thread.start();
    }
}

