/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.hashing;

import com.twitter.hashing.ConsistentHashingDistributor$;
import com.twitter.hashing.Distributor;
import com.twitter.hashing.HashNode;
import java.io.Serializable;
import java.security.MessageDigest;
import java.util.Map;
import java.util.TreeMap;
import scala.Function1;
import scala.Function2;
import scala.Int$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.Scala3RunTime$;

public class ConsistentHashingDistributor<A>
implements Distributor<A> {
    private final Seq<HashNode<A>> hashNodes;
    private final TreeMap<Object, HashNode<A>> continuum;

    public static <A> boolean $lessinit$greater$default$3() {
        return ConsistentHashingDistributor$.MODULE$.$lessinit$greater$default$3();
    }

    public ConsistentHashingDistributor(Seq<HashNode<A>> hashNodes, int numReps, boolean oldLibMemcachedVersionComplianceMode) {
        this.hashNodes = hashNodes;
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        TreeMap<Long, HashNode> underlying = new TreeMap<Long, HashNode>();
        byte dash = (byte)45;
        int nodeCount = hashNodes.size();
        int totalWeight = BoxesRunTime.unboxToInt((Object)hashNodes.foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2 & Serializable)(_$1, _$2) -> ConsistentHashingDistributor.$anonfun$1(BoxesRunTime.unboxToInt((Object)_$1), (HashNode)_$2)));
        for (HashNode node : hashNodes) {
            int n;
            if (oldLibMemcachedVersionComplianceMode) {
                float percent = (float)node.weight() / (float)totalWeight;
                n = (int)((double)(percent * (float)numReps / (float)4 * (float)nodeCount) + 1.0E-10);
            } else {
                double percent = (double)node.weight() / (double)totalWeight;
                n = (int)(percent * (double)nodeCount * (double)(numReps / 4) + 1.0E-10);
            }
            int pointsOnRing = n;
            byte[] prefix = node.identifier().getBytes("UTF-8");
            for (int i = 0; i < pointsOnRing; ++i) {
                md5.update(prefix);
                md5.update(dash);
                this.hashInt(i, md5);
                byte[] buffer = md5.digest();
                underlying.put(BoxesRunTime.boxToLong((long)((long)this.byteArrayToLE(buffer, 0) & 0xFFFFFFFFL)), node);
                underlying.put(BoxesRunTime.boxToLong((long)((long)this.byteArrayToLE(buffer, 4) & 0xFFFFFFFFL)), node);
                underlying.put(BoxesRunTime.boxToLong((long)((long)this.byteArrayToLE(buffer, 8) & 0xFFFFFFFFL)), node);
                underlying.put(BoxesRunTime.boxToLong((long)((long)this.byteArrayToLE(buffer, 12) & 0xFFFFFFFFL)), node);
            }
        }
        if (!oldLibMemcachedVersionComplianceMode) {
            if (underlying.size() > numReps * nodeCount) {
                throw Scala3RunTime$.MODULE$.assertFailed();
            }
            if (underlying.size() < numReps * (nodeCount - 1)) {
                throw Scala3RunTime$.MODULE$.assertFailed();
            }
        }
        this.continuum = underlying;
    }

    public int byteArrayToLE(byte[] bytes, int offset) {
        return bytes[3 + offset] << 24 | (bytes[2 + offset] & 0xFF) << 16 | (bytes[1 + offset] & 0xFF) << 8 | bytes[0 + offset] & 0xFF;
    }

    public void hashInt(int i, MessageDigest md) {
        int j = i;
        for (int div = (int)Math.pow(10.0, Int$.MODULE$.int2double((int)Math.log10(Int$.MODULE$.int2double(i)))); j > 9 || div >= 10; div /= 10) {
            int d = j / div;
            if (d != 0) {
                md.update((byte)(48 + d));
                j %= div;
                continue;
            }
            if (j == i) continue;
            md.update((byte)48);
        }
        md.update((byte)(48 + j));
    }

    @Override
    public Seq<A> nodes() {
        return (Seq)this.hashNodes.map((Function1 & Serializable)_$3 -> _$3.handle());
    }

    @Override
    public int nodeCount() {
        return this.hashNodes.size();
    }

    private long truncateHash(long hash) {
        return hash & 0xFFFFFFFFL;
    }

    private Map.Entry<Object, HashNode<A>> mapEntryForHash(long hash) {
        long truncatedHash = this.truncateHash(hash);
        Map.Entry<Object, HashNode<A>> entry = this.continuum.ceilingEntry(BoxesRunTime.boxToLong((long)truncatedHash));
        return entry == null ? this.continuum.firstEntry() : entry;
    }

    @Override
    public long partitionIdForHash(long hash) {
        return BoxesRunTime.unboxToLong((Object)this.mapEntryForHash(hash).getKey());
    }

    @Override
    public Tuple2<Object, A> entryForHash(long hash) {
        Map.Entry<Object, HashNode<A>> entry = this.mapEntryForHash(hash);
        return Tuple2$.MODULE$.apply(entry.getKey(), entry.getValue().handle());
    }

    @Override
    public A nodeForHash(long hash) {
        return this.mapEntryForHash(hash).getValue().handle();
    }

    private static final /* synthetic */ int $anonfun$1(int _$1, HashNode _$2) {
        return _$1 + _$2.weight();
    }
}

