/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.hashing;

import com.twitter.hashing.Distributor;
import com.twitter.hashing.KetamaDistributor$;
import com.twitter.hashing.KetamaNode;
import java.security.MessageDigest;
import java.util.Map;
import java.util.TreeMap;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\rd\u0001B\n\u0015\u0001mA\u0001B\r\u0001\u0003\u0002\u0003\u0006Ia\r\u0005\t\u0005\u0002\u0011\t\u0011)A\u0005\u0007\"Aa\t\u0001B\u0001B\u0003%q\tC\u0003K\u0001\u0011\u00051\n\u0003\u0004Q\u0001\u0011\u0005A#\u0015\u0005\u0007A\u0002!\t\u0001F1\t\rI\u0004\u0001\u0015!\u0003t\u0011\u0015a\b\u0001\"\u0001~\u0011\u0019y\b\u0001\"\u0001\u0002\u0002!A\u00111\u0001\u0001!\n\u0013\t)\u0001C\u0004\u0002\f\u0001!I!!\u0004\t\u000f\u0005\u001d\u0002\u0001\"\u0001\u0002*!9\u0011Q\u0006\u0001\u0005\u0002\u0005=\u0002bBA\u001d\u0001\u0011\u0005\u00111H\u0004\n\u0003\u007f!\u0012\u0011!E\u0001\u0003\u00032\u0001b\u0005\u000b\u0002\u0002#\u0005\u00111\t\u0005\u0007\u0015B!\t!!\u0012\t\u0013\u0005\u001d\u0003#%A\u0005\u0002\u0005%#!E&fi\u0006l\u0017\rR5tiJL'-\u001e;pe*\u0011QCF\u0001\bQ\u0006\u001c\b.\u001b8h\u0015\t9\u0002$A\u0004uo&$H/\u001a:\u000b\u0003e\t1aY8n\u0007\u0001)\"\u0001H\u0015\u0014\u0007\u0001i2\u0005\u0005\u0002\u001fC5\tqDC\u0001!\u0003\u0015\u00198-\u00197b\u0013\t\u0011sD\u0001\u0004B]f\u0014VM\u001a\t\u0004I\u0015:S\"\u0001\u000b\n\u0005\u0019\"\"a\u0003#jgR\u0014\u0018NY;u_J\u0004\"\u0001K\u0015\r\u0001\u0011)!\u0006\u0001b\u0001W\t\t\u0011)\u0005\u0002-_A\u0011a$L\u0005\u0003]}\u0011qAT8uQ&tw\r\u0005\u0002\u001fa%\u0011\u0011g\b\u0002\u0004\u0003:L\u0018aC6fi\u0006l\u0017MT8eKN\u00042\u0001\u000e\u001f@\u001d\t)$H\u0004\u00027s5\tqG\u0003\u000295\u00051AH]8pizJ\u0011\u0001I\u0005\u0003w}\tq\u0001]1dW\u0006<W-\u0003\u0002>}\t\u00191+Z9\u000b\u0005mz\u0002c\u0001\u0013AO%\u0011\u0011\t\u0006\u0002\u000b\u0017\u0016$\u0018-\\1O_\u0012,\u0017a\u00028v[J+\u0007o\u001d\t\u0003=\u0011K!!R\u0010\u0003\u0007%sG/\u0001\u0013pY\u0012d\u0015NY'f[\u000e\f7\r[3e-\u0016\u00148/[8o\u0007>l\u0007\u000f\\5b]\u000e,Wj\u001c3f!\tq\u0002*\u0003\u0002J?\t9!i\\8mK\u0006t\u0017A\u0002\u001fj]&$h\b\u0006\u0003M\u001b:{\u0005c\u0001\u0013\u0001O!)!\u0007\u0002a\u0001g!)!\t\u0002a\u0001\u0007\"9a\t\u0002I\u0001\u0002\u00049\u0015!\u00042zi\u0016\f%O]1z)>dU\tF\u0002D%jCQaU\u0003A\u0002Q\u000bQAY=uKN\u00042AH+X\u0013\t1vDA\u0003BeJ\f\u0017\u0010\u0005\u0002\u001f1&\u0011\u0011l\b\u0002\u0005\u0005f$X\rC\u0003\\\u000b\u0001\u00071)\u0001\u0004pM\u001a\u001cX\r\u001e\u0015\u0003\u000bu\u0003\"A\b0\n\u0005}{\"AB5oY&tW-A\u0004iCND\u0017J\u001c;\u0015\u0007\t,w\r\u0005\u0002\u001fG&\u0011Am\b\u0002\u0005+:LG\u000fC\u0003g\r\u0001\u00071)A\u0001j\u0011\u0015Ag\u00011\u0001j\u0003\tiG\r\u0005\u0002k_6\t1N\u0003\u0002m[\u0006A1/Z2ve&$\u0018PC\u0001o\u0003\u0011Q\u0017M^1\n\u0005A\\'!D'fgN\fw-\u001a#jO\u0016\u001cH\u000f\u000b\u0002\u0007;\u0006I1m\u001c8uS:,X/\u001c\t\u0005i^Lx(D\u0001v\u0015\t1X.\u0001\u0003vi&d\u0017B\u0001=v\u0005\u001d!&/Z3NCB\u0004\"A\b>\n\u0005m|\"\u0001\u0002'p]\u001e\fQA\\8eKN,\u0012A \t\u0004iq:\u0013!\u00038pI\u0016\u001cu.\u001e8u+\u0005\u0019\u0015\u0001\u0004;sk:\u001c\u0017\r^3ICNDGcA=\u0002\b!1\u0011\u0011\u0002\u0006A\u0002e\fA\u0001[1tQ\u0006yQ.\u00199F]R\u0014\u0018PR8s\u0011\u0006\u001c\b\u000e\u0006\u0003\u0002\u0010\u0005\u0015\u0002CBA\t\u0003?IxH\u0004\u0003\u0002\u0014\u0005ma\u0002BA\u000b\u00033q1ANA\f\u0013\u0005q\u0017B\u0001<n\u0013\r\ti\"^\u0001\u0004\u001b\u0006\u0004\u0018\u0002BA\u0011\u0003G\u0011Q!\u00128uefT1!!\bv\u0011\u0019\tIa\u0003a\u0001s\u0006\u0011\u0002/\u0019:uSRLwN\\%e\r>\u0014\b*Y:i)\rI\u00181\u0006\u0005\u0007\u0003\u0013a\u0001\u0019A=\u0002\u0019\u0015tGO]=G_JD\u0015m\u001d5\u0015\t\u0005E\u0012q\u0007\t\u0006=\u0005M\u0012pJ\u0005\u0004\u0003ky\"A\u0002+va2,'\u0007\u0003\u0004\u0002\n5\u0001\r!_\u0001\f]>$WMR8s\u0011\u0006\u001c\b\u000eF\u0002(\u0003{Aa!!\u0003\u000f\u0001\u0004I\u0018!E&fi\u0006l\u0017\rR5tiJL'-\u001e;peB\u0011A\u0005E\n\u0003!u!\"!!\u0011\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00134+\u0011\tY%!\u0019\u0016\u0005\u00055#fA$\u0002P-\u0012\u0011\u0011\u000b\t\u0005\u0003'\ni&\u0004\u0002\u0002V)!\u0011qKA-\u0003%)hn\u00195fG.,GMC\u0002\u0002\\}\t!\"\u00198o_R\fG/[8o\u0013\u0011\ty&!\u0016\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rB\u0003+%\t\u00071\u0006")
public class KetamaDistributor<A>
implements Distributor<A> {
    private final Seq<KetamaNode<A>> ketamaNodes;
    private final TreeMap<Object, KetamaNode<A>> continuum;

    public static <A> boolean $lessinit$greater$default$3() {
        return KetamaDistributor$.MODULE$.$lessinit$greater$default$3();
    }

    public int byteArrayToLE(byte[] bytes, int offset) {
        return bytes[3 + offset] << 24 | (bytes[2 + offset] & 0xFF) << 16 | (bytes[1 + offset] & 0xFF) << 8 | bytes[0 + offset] & 0xFF;
    }

    public void hashInt(int i, MessageDigest md) {
        int j = i;
        for (int div = (int)Math.pow(10.0, (int)Math.log10(i)); j > 9 || div >= 10; div /= 10) {
            int d = j / div;
            if (d != 0) {
                md.update((byte)(48 + d));
                j %= div;
                continue;
            }
            if (j == i) continue;
            md.update((byte)48);
        }
        md.update((byte)(48 + j));
    }

    @Override
    public Seq<A> nodes() {
        return (Seq)this.ketamaNodes.map((Function1 & java.io.Serializable & Serializable)x$3 -> x$3.handle(), Seq$.MODULE$.canBuildFrom());
    }

    @Override
    public int nodeCount() {
        return this.ketamaNodes.size();
    }

    private long truncateHash(long hash) {
        return hash & 0xFFFFFFFFL;
    }

    private Map.Entry<Object, KetamaNode<A>> mapEntryForHash(long hash) {
        long truncatedHash = this.truncateHash(hash);
        Map.Entry<Object, KetamaNode<A>> entry = this.continuum.ceilingEntry(BoxesRunTime.boxToLong((long)truncatedHash));
        return entry == null ? this.continuum.firstEntry() : entry;
    }

    @Override
    public long partitionIdForHash(long hash) {
        return BoxesRunTime.unboxToLong((Object)this.mapEntryForHash(hash).getKey());
    }

    @Override
    public Tuple2<Object, A> entryForHash(long hash) {
        Map.Entry<Object, KetamaNode<A>> entry = this.mapEntryForHash(hash);
        return new Tuple2(entry.getKey(), entry.getValue().handle());
    }

    @Override
    public A nodeForHash(long hash) {
        return this.mapEntryForHash(hash).getValue().handle();
    }

    public static final /* synthetic */ int $anonfun$continuum$1(int x$1, KetamaNode x$2) {
        return x$1 + x$2.weight();
    }

    public KetamaDistributor(Seq<KetamaNode<A>> ketamaNodes, int numReps, boolean oldLibMemcachedVersionComplianceMode) {
        this.ketamaNodes = ketamaNodes;
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        TreeMap<Long, KetamaNode> underlying = new TreeMap<Long, KetamaNode>();
        byte dash = (byte)45;
        int nodeCount = ketamaNodes.size();
        int totalWeight = BoxesRunTime.unboxToInt((Object)ketamaNodes.foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2 & java.io.Serializable & Serializable)(x$1, x$2) -> BoxesRunTime.boxToInteger((int)KetamaDistributor.$anonfun$continuum$1(BoxesRunTime.unboxToInt((Object)x$1), x$2))));
        for (KetamaNode node : ketamaNodes) {
            int n;
            if (oldLibMemcachedVersionComplianceMode) {
                float percent = (float)node.weight() / (float)totalWeight;
                n = (int)((double)(percent * (float)numReps / (float)4 * (float)nodeCount) + 1.0E-10);
            } else {
                double percent = (double)node.weight() / (double)totalWeight;
                n = (int)(percent * (double)nodeCount * (double)(numReps / 4) + 1.0E-10);
            }
            int pointsOnRing = n;
            byte[] prefix = node.identifier().getBytes("UTF-8");
            for (int i = 0; i < pointsOnRing; ++i) {
                md5.update(prefix);
                md5.update(dash);
                this.hashInt(i, md5);
                byte[] buffer = md5.digest();
                underlying.put(BoxesRunTime.boxToLong((long)((long)this.byteArrayToLE(buffer, 0) & 0xFFFFFFFFL)), node);
                underlying.put(BoxesRunTime.boxToLong((long)((long)this.byteArrayToLE(buffer, 4) & 0xFFFFFFFFL)), node);
                underlying.put(BoxesRunTime.boxToLong((long)((long)this.byteArrayToLE(buffer, 8) & 0xFFFFFFFFL)), node);
                underlying.put(BoxesRunTime.boxToLong((long)((long)this.byteArrayToLE(buffer, 12) & 0xFFFFFFFFL)), node);
            }
        }
        if (!oldLibMemcachedVersionComplianceMode) {
            Predef$.MODULE$.assert(underlying.size() <= numReps * nodeCount);
            Predef$.MODULE$.assert(underlying.size() >= numReps * (nodeCount - 1));
        }
        this.continuum = underlying;
    }
}

