/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.hashing;

import com.twitter.hashing.Distributor;
import com.twitter.hashing.KetamaDistributor$;
import com.twitter.hashing.KetamaNode;
import java.security.MessageDigest;
import java.util.Map;
import java.util.TreeMap;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Mc\u0001B\u0001\u0003\u0001%\u0011\u0011cS3uC6\fG)[:ue&\u0014W\u000f^8s\u0015\t\u0019A!A\u0004iCND\u0017N\\4\u000b\u0005\u00151\u0011a\u0002;xSR$XM\u001d\u0006\u0002\u000f\u0005\u00191m\\7\u0004\u0001U\u0011!bF\n\u0004\u0001-\t\u0002C\u0001\u0007\u0010\u001b\u0005i!\"\u0001\b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Ai!AB!osJ+g\rE\u0002\u0013'Ui\u0011AA\u0005\u0003)\t\u00111\u0002R5tiJL'-\u001e;peB\u0011ac\u0006\u0007\u0001\t\u0015A\u0002A1\u0001\u001a\u0005\u0005\t\u0015C\u0001\u000e\u001e!\ta1$\u0003\u0002\u001d\u001b\t9aj\u001c;iS:<\u0007C\u0001\u0007\u001f\u0013\tyRBA\u0002B]fD\u0001\"\t\u0001\u0003\u0002\u0003\u0006IAI\u0001\fW\u0016$\u0018-\\1O_\u0012,7\u000fE\u0002$W9r!\u0001J\u0015\u000f\u0005\u0015BS\"\u0001\u0014\u000b\u0005\u001dB\u0011A\u0002\u001fs_>$h(C\u0001\u000f\u0013\tQS\"A\u0004qC\u000e\\\u0017mZ3\n\u00051j#aA*fc*\u0011!&\u0004\t\u0004%=*\u0012B\u0001\u0019\u0003\u0005)YU\r^1nC:{G-\u001a\u0005\te\u0001\u0011\t\u0011)A\u0005g\u00059a.^7SKB\u001c\bC\u0001\u00075\u0013\t)TBA\u0002J]RD\u0001b\u000e\u0001\u0003\u0002\u0003\u0006I\u0001O\u0001%_2$G*\u001b2NK6\u001c\u0017m\u00195fIZ+'o]5p]\u000e{W\u000e\u001d7jC:\u001cW-T8eKB\u0011A\"O\u0005\u0003u5\u0011qAQ8pY\u0016\fg\u000eC\u0003=\u0001\u0011\u0005Q(\u0001\u0004=S:LGO\u0010\u000b\u0005}}\u0002\u0015\tE\u0002\u0013\u0001UAQ!I\u001eA\u0002\tBQAM\u001eA\u0002MBqaN\u001e\u0011\u0002\u0003\u0007\u0001\b\u0003\u0004D\u0001\u0011\u0005!\u0001R\u0001\u000eEf$X-\u0011:sCf$v\u000eT#\u0015\u0007M*U\nC\u0003G\u0005\u0002\u0007q)A\u0003csR,7\u000fE\u0002\r\u0011*K!!S\u0007\u0003\u000b\u0005\u0013(/Y=\u0011\u00051Y\u0015B\u0001'\u000e\u0005\u0011\u0011\u0015\u0010^3\t\u000b9\u0013\u0005\u0019A\u001a\u0002\r=4gm]3uQ\t\u0011\u0005\u000b\u0005\u0002\r#&\u0011!+\u0004\u0002\u0007S:d\u0017N\\3\t\rQ\u0003A\u0011\u0001\u0002V\u0003\u001dA\u0017m\u001d5J]R$2AV-\\!\taq+\u0003\u0002Y\u001b\t!QK\\5u\u0011\u0015Q6\u000b1\u00014\u0003\u0005I\u0007\"\u0002/T\u0001\u0004i\u0016AA7e!\tq6-D\u0001`\u0015\t\u0001\u0017-\u0001\u0005tK\u000e,(/\u001b;z\u0015\u0005\u0011\u0017\u0001\u00026bm\u0006L!\u0001Z0\u0003\u001b5+7o]1hK\u0012Kw-Z:uQ\t\u0019\u0006\u000b\u0003\u0004h\u0001\u0001\u0006I\u0001[\u0001\nG>tG/\u001b8vk6\u0004B!\u001b7o]5\t!N\u0003\u0002lC\u0006!Q\u000f^5m\u0013\ti'NA\u0004Ue\u0016,W*\u00199\u0011\u00051y\u0017B\u00019\u000e\u0005\u0011auN\\4\t\u000bI\u0004A\u0011A:\u0002\u000b9|G-Z:\u0016\u0003Q\u00042aI\u0016\u0016\u0011\u00151\b\u0001\"\u0001x\u0003%qw\u000eZ3D_VtG/F\u00014\u0011\u0015I\b\u0001\"\u0003{\u0003=i\u0017\r]#oiJLhi\u001c:ICNDGcA>\u0002\u000eA)A0a\u0002o]9\u0019Q0a\u0001\u000f\u0007y\f\tA\u0004\u0002&\u007f&\t!-\u0003\u0002lC&\u0019\u0011Q\u00016\u0002\u00075\u000b\u0007/\u0003\u0003\u0002\n\u0005-!!B#oiJL(bAA\u0003U\"1\u0011q\u0002=A\u00029\fA\u0001[1tQ\"9\u00111\u0003\u0001\u0005\u0002\u0005U\u0011\u0001D3oiJLhi\u001c:ICNDG\u0003BA\f\u0003;\u0001R\u0001DA\r]VI1!a\u0007\u000e\u0005\u0019!V\u000f\u001d7fe!9\u0011qBA\t\u0001\u0004q\u0007bBA\u0011\u0001\u0011\u0005\u00111E\u0001\f]>$WMR8s\u0011\u0006\u001c\b\u000eF\u0002\u0016\u0003KAq!a\u0004\u0002 \u0001\u0007anB\u0005\u0002*\t\t\t\u0011#\u0001\u0002,\u0005\t2*\u001a;b[\u0006$\u0015n\u001d;sS\n,Ho\u001c:\u0011\u0007I\tiC\u0002\u0005\u0002\u0005\u0005\u0005\t\u0012AA\u0018'\r\tic\u0003\u0005\by\u00055B\u0011AA\u001a)\t\tY\u0003\u0003\u0006\u00028\u00055\u0012\u0013!C\u0001\u0003s\t1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u001aT\u0003BA\u001e\u0003#*\"!!\u0010+\u0007a\nyd\u000b\u0002\u0002BA!\u00111IA'\u001b\t\t)E\u0003\u0003\u0002H\u0005%\u0013!C;oG\",7m[3e\u0015\r\tY%D\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA(\u0003\u000b\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\t\u0019A\u0012Q\u0007b\u00013\u0001")
public class KetamaDistributor<A>
implements Distributor<A> {
    private final Seq<KetamaNode<A>> ketamaNodes;
    private final TreeMap<Object, KetamaNode<A>> continuum;

    public static <A> boolean $lessinit$greater$default$3() {
        return KetamaDistributor$.MODULE$.$lessinit$greater$default$3();
    }

    public int byteArrayToLE(byte[] bytes, int offset) {
        return bytes[3 + offset] << 24 | (bytes[2 + offset] & 0xFF) << 16 | (bytes[1 + offset] & 0xFF) << 8 | bytes[0 + offset] & 0xFF;
    }

    public void hashInt(int i, MessageDigest md) {
        int j = i;
        for (int div = (int)Math.pow(10.0, (int)Math.log10(i)); j > 9 || div >= 10; div /= 10) {
            int d = j / div;
            if (d != 0) {
                md.update((byte)(48 + d));
                j %= div;
                continue;
            }
            if (j == i) continue;
            md.update((byte)48);
        }
        md.update((byte)(48 + j));
    }

    @Override
    public Seq<A> nodes() {
        return (Seq)this.ketamaNodes.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final A apply(KetamaNode<A> x$3) {
                return x$3.handle();
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    @Override
    public int nodeCount() {
        return this.ketamaNodes.size();
    }

    private Map.Entry<Object, KetamaNode<A>> mapEntryForHash(long hash) {
        long truncatedHash = hash & 0xFFFFFFFFL;
        Map.Entry<Object, KetamaNode<A>> entry = this.continuum.ceilingEntry(BoxesRunTime.boxToLong((long)truncatedHash));
        return entry == null ? this.continuum.firstEntry() : entry;
    }

    @Override
    public Tuple2<Object, A> entryForHash(long hash) {
        Map.Entry<Object, KetamaNode<A>> entry = this.mapEntryForHash(hash);
        return new Tuple2(entry.getKey(), entry.getValue().handle());
    }

    @Override
    public A nodeForHash(long hash) {
        return this.mapEntryForHash(hash).getValue().handle();
    }

    public KetamaDistributor(Seq<KetamaNode<A>> ketamaNodes, int numReps, boolean oldLibMemcachedVersionComplianceMode) {
        this.ketamaNodes = ketamaNodes;
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        TreeMap<Long, KetamaNode> underlying = new TreeMap<Long, KetamaNode>();
        byte dash = (byte)45;
        int nodeCount = ketamaNodes.size();
        int totalWeight = BoxesRunTime.unboxToInt((Object)ketamaNodes.foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(int x$1, KetamaNode<A> x$2) {
                return x$1 + x$2.weight();
            }
        }));
        for (KetamaNode node : ketamaNodes) {
            int n;
            if (oldLibMemcachedVersionComplianceMode) {
                float percent = (float)node.weight() / (float)totalWeight;
                n = (int)((double)(percent * (float)numReps / (float)4 * (float)nodeCount) + 1.0E-10);
            } else {
                double percent = (double)node.weight() / (double)totalWeight;
                n = (int)(percent * (double)nodeCount * (double)(numReps / 4) + 1.0E-10);
            }
            int pointsOnRing = n;
            byte[] prefix = node.identifier().getBytes("UTF-8");
            for (int i = 0; i < pointsOnRing; ++i) {
                md5.update(prefix);
                md5.update(dash);
                this.hashInt(i, md5);
                byte[] buffer = md5.digest();
                underlying.put(BoxesRunTime.boxToLong((long)((long)this.byteArrayToLE(buffer, 0) & 0xFFFFFFFFL)), node);
                underlying.put(BoxesRunTime.boxToLong((long)((long)this.byteArrayToLE(buffer, 4) & 0xFFFFFFFFL)), node);
                underlying.put(BoxesRunTime.boxToLong((long)((long)this.byteArrayToLE(buffer, 8) & 0xFFFFFFFFL)), node);
                underlying.put(BoxesRunTime.boxToLong((long)((long)this.byteArrayToLE(buffer, 12) & 0xFFFFFFFFL)), node);
            }
        }
        if (!oldLibMemcachedVersionComplianceMode) {
            Predef$.MODULE$.assert(underlying.size() <= numReps * nodeCount);
            Predef$.MODULE$.assert(underlying.size() >= numReps * (nodeCount - 1));
        }
        this.continuum = underlying;
    }
}

