/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.app;

import com.twitter.app.ClassPath;
import com.twitter.app.LoadService;
import com.twitter.app.LoadServiceClassPath;
import com.twitter.finagle.util.loadServiceDenied$;
import com.twitter.util.registry.GlobalRegistry$;
import java.io.Serializable;
import java.util.ServiceConfigurationError;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.SeqOps;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.io.Source;
import scala.io.Source$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag;
import scala.runtime.BoxedUnit;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.control.NonFatal$;

public final class LoadService$
implements Serializable {
    private static final Logger log;
    private static final ConcurrentHashMap<ClassLoader, Seq<ClassPath.LoadServiceInfo>> cache;
    private static final Map<Class<?>, Seq<?>> binds;
    private static final Map<Class<?>, BoxedUnit> loaded;
    private static final ConcurrentHashMap<Class<?>, BoxedUnit> bindDupes;
    public static final LoadService$ MODULE$;

    private LoadService$() {
    }

    static {
        MODULE$ = new LoadService$();
        log = Logger.getLogger("com.twitter.app.LoadService");
        cache = new ConcurrentHashMap();
        binds = (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        loaded = (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        bindDupes = new ConcurrentHashMap();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(LoadService$.class);
    }

    public void bind(LoadService.Binding<?> binding) {
        Option option;
        Map<Class<?>, Seq<?>> map = binds;
        synchronized (map) {
            if (loaded.contains(binding.iface())) {
                throw new IllegalStateException("LoadService.apply has already been called for " + binding.iface().getName() + ".");
            }
            option = binds.put(binding.iface(), binding.implementations());
        }
        Option prevs = option;
        prevs.foreach((Function1)(JProcedure1 & Serializable)ps -> {
            bindDupes.put(binding.iface(), BoxedUnit.UNIT);
            log.warning("Replaced existing `LoadService.bind` for `" + binding.iface().getName() + "`, " + ("old='" + ps + "', new='" + binding.implementations() + "'"));
        });
    }

    public Set<Class<?>> duplicateBindings() {
        return CollectionConverters$.MODULE$.SetHasAsScala(bindDupes.keySet()).asScala().toSet();
    }

    private void addToRegistry(String ifaceName, Seq<String> implClassNames) {
        GlobalRegistry$.MODULE$.get().put((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"loadservice", ifaceName})), implClassNames.mkString(","));
    }

    public <T> Seq<T> apply(Class<T> iface) {
        Seq<T> seq;
        Option allowed;
        Option option;
        String ifaceName = iface.getName();
        Map<Class<?>, Seq<?>> map = binds;
        synchronized (map) {
            loaded.put(iface, (Object)BoxedUnit.UNIT);
            option = binds.get(iface);
        }
        Option option2 = allowed = option;
        if (option2 instanceof Some) {
            Seq<T> as;
            seq = as = (Seq<T>)((Some)option2).value();
        } else if (None$.MODULE$.equals(option2)) {
            seq = this.loadImpls(iface, ifaceName);
        } else {
            throw new MatchError((Object)option2);
        }
        Seq<T> impls = seq;
        this.addToRegistry(ifaceName, (Seq<String>)((Seq)impls.map((Function1 & Serializable)_$1 -> _$1.getClass().getName())));
        return impls;
    }

    public <T> Seq<T> apply(ClassTag<T> evidence$1) {
        Class iface = ((ClassTag)Predef$.MODULE$.implicitly(evidence$1)).runtimeClass();
        return this.apply(iface);
    }

    private <T> Seq<T> loadImpls(Class<T> iface, String ifaceName) {
        ClassLoader loader = iface.getClassLoader();
        Set denied = (Set)loadServiceDenied$.MODULE$.apply();
        LoadServiceClassPath cp = new LoadServiceClassPath();
        Function<ClassLoader, Seq<ClassPath.LoadServiceInfo>> whenAbsent = new Function<ClassLoader, Seq<ClassPath.LoadServiceInfo>>(cp){
            private final LoadServiceClassPath cp$1;
            {
                this.cp$1 = cp$3;
            }

            public Seq apply(ClassLoader loader) {
                return this.cp$1.browse(loader).toSeq();
            }
        };
        Seq classNames = (Seq)((IterableOps)cache.computeIfAbsent(loader, whenAbsent)).withFilter((Function1 & Serializable)info -> {
            String string = info.iface();
            String string2 = ifaceName;
            return !(string != null ? !string.equals(string2) : string2 != null);
        }).flatMap((Function1 & Serializable)info -> (IterableOnce)info.lines().map((Function1 & Serializable)className -> className));
        Iterator classNamesFromResources = CollectionConverters$.MODULE$.EnumerationHasAsScala(loader.getResources("META-INF/services/" + ifaceName)).asScala().flatMap((Function1 & Serializable)rsc -> (IterableOnce)cp.readLines((Source)Source$.MODULE$.fromURL(rsc, "UTF-8")).map((Function1 & Serializable)line -> line));
        return (Seq)((IterableOps)((IterableOps)((SeqOps)classNames.$plus$plus((IterableOnce)classNamesFromResources)).distinct()).filterNot((Function1 & Serializable)className -> {
            void var3_3;
            boolean isDenied = denied.contains(className);
            if (isDenied) {
                log.info("LoadService: skipped " + className + " due to deny list flag");
            }
            return (boolean)var3_3;
        })).flatMap((Function1 & Serializable)className -> {
            Class<?> cls = Class.forName(className);
            if (!iface.isAssignableFrom(cls)) {
                throw new ServiceConfigurationError("" + className + " not a subclass of " + ifaceName);
            }
            log.log(Level.FINE, "LoadService: loaded instance of class " + className + " for requested service " + ifaceName);
            return this.liftedTree1$1(ifaceName, (String)className, cls);
        });
    }

    private final Option liftedTree1$1(String ifaceName$3, String className$1, Class cls$1) {
        Some some;
        try {
            Object instance = cls$1.newInstance();
            some = Some$.MODULE$.apply(instance);
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable ex = throwable3 = (Throwable)option.get();
                log.log(Level.SEVERE, "LoadService: failed to instantiate '" + className$1 + "' for the requested " + ("service '" + ifaceName$3 + "'"), ex);
                some = None$.MODULE$;
            }
            throw throwable;
        }
        return some;
    }
}

