/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.clientlib.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.twitter.clientlib.JSON;
import com.twitter.clientlib.model.Variant;
import com.twitter.clientlib.model.VideoAllOfNonPublicMetrics;
import com.twitter.clientlib.model.VideoAllOfOrganicMetrics;
import com.twitter.clientlib.model.VideoAllOfPromotedMetrics;
import com.twitter.clientlib.model.VideoAllOfPublicMetrics;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

public class VideoAllOf {
    public static final String SERIALIZED_NAME_DURATION_MS = "duration_ms";
    @SerializedName(value="duration_ms")
    private Integer durationMs;
    public static final String SERIALIZED_NAME_NON_PUBLIC_METRICS = "non_public_metrics";
    @SerializedName(value="non_public_metrics")
    private VideoAllOfNonPublicMetrics nonPublicMetrics;
    public static final String SERIALIZED_NAME_ORGANIC_METRICS = "organic_metrics";
    @SerializedName(value="organic_metrics")
    private VideoAllOfOrganicMetrics organicMetrics;
    public static final String SERIALIZED_NAME_PREVIEW_IMAGE_URL = "preview_image_url";
    @SerializedName(value="preview_image_url")
    private URL previewImageUrl;
    public static final String SERIALIZED_NAME_PROMOTED_METRICS = "promoted_metrics";
    @SerializedName(value="promoted_metrics")
    private VideoAllOfPromotedMetrics promotedMetrics;
    public static final String SERIALIZED_NAME_PUBLIC_METRICS = "public_metrics";
    @SerializedName(value="public_metrics")
    private VideoAllOfPublicMetrics publicMetrics;
    public static final String SERIALIZED_NAME_VARIANTS = "variants";
    @SerializedName(value="variants")
    private List<Variant> variants = null;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public VideoAllOf durationMs(Integer durationMs) {
        this.durationMs = durationMs;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Integer getDurationMs() {
        return this.durationMs;
    }

    public void setDurationMs(Integer durationMs) {
        this.durationMs = durationMs;
    }

    public VideoAllOf nonPublicMetrics(VideoAllOfNonPublicMetrics nonPublicMetrics) {
        this.nonPublicMetrics = nonPublicMetrics;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public VideoAllOfNonPublicMetrics getNonPublicMetrics() {
        return this.nonPublicMetrics;
    }

    public void setNonPublicMetrics(VideoAllOfNonPublicMetrics nonPublicMetrics) {
        this.nonPublicMetrics = nonPublicMetrics;
    }

    public VideoAllOf organicMetrics(VideoAllOfOrganicMetrics organicMetrics) {
        this.organicMetrics = organicMetrics;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public VideoAllOfOrganicMetrics getOrganicMetrics() {
        return this.organicMetrics;
    }

    public void setOrganicMetrics(VideoAllOfOrganicMetrics organicMetrics) {
        this.organicMetrics = organicMetrics;
    }

    public VideoAllOf previewImageUrl(URL previewImageUrl) {
        this.previewImageUrl = previewImageUrl;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public URL getPreviewImageUrl() {
        return this.previewImageUrl;
    }

    public void setPreviewImageUrl(URL previewImageUrl) {
        this.previewImageUrl = previewImageUrl;
    }

    public VideoAllOf promotedMetrics(VideoAllOfPromotedMetrics promotedMetrics) {
        this.promotedMetrics = promotedMetrics;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public VideoAllOfPromotedMetrics getPromotedMetrics() {
        return this.promotedMetrics;
    }

    public void setPromotedMetrics(VideoAllOfPromotedMetrics promotedMetrics) {
        this.promotedMetrics = promotedMetrics;
    }

    public VideoAllOf publicMetrics(VideoAllOfPublicMetrics publicMetrics) {
        this.publicMetrics = publicMetrics;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public VideoAllOfPublicMetrics getPublicMetrics() {
        return this.publicMetrics;
    }

    public void setPublicMetrics(VideoAllOfPublicMetrics publicMetrics) {
        this.publicMetrics = publicMetrics;
    }

    public VideoAllOf variants(List<Variant> variants) {
        this.variants = variants;
        return this;
    }

    public VideoAllOf addVariantsItem(Variant variantsItem) {
        if (this.variants == null) {
            this.variants = new ArrayList<Variant>();
        }
        this.variants.add(variantsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An array of all available variants of the media.")
    public List<Variant> getVariants() {
        return this.variants;
    }

    public void setVariants(List<Variant> variants) {
        this.variants = variants;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VideoAllOf videoAllOf = (VideoAllOf)o;
        return Objects.equals(this.durationMs, videoAllOf.durationMs) && Objects.equals(this.nonPublicMetrics, videoAllOf.nonPublicMetrics) && Objects.equals(this.organicMetrics, videoAllOf.organicMetrics) && Objects.equals(this.previewImageUrl, videoAllOf.previewImageUrl) && Objects.equals(this.promotedMetrics, videoAllOf.promotedMetrics) && Objects.equals(this.publicMetrics, videoAllOf.publicMetrics) && Objects.equals(this.variants, videoAllOf.variants);
    }

    public int hashCode() {
        return Objects.hash(this.durationMs, this.nonPublicMetrics, this.organicMetrics, this.previewImageUrl, this.promotedMetrics, this.publicMetrics, this.variants);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class VideoAllOf {\n");
        sb.append("    durationMs: ").append(this.toIndentedString(this.durationMs)).append("\n");
        sb.append("    nonPublicMetrics: ").append(this.toIndentedString(this.nonPublicMetrics)).append("\n");
        sb.append("    organicMetrics: ").append(this.toIndentedString(this.organicMetrics)).append("\n");
        sb.append("    previewImageUrl: ").append(this.toIndentedString(this.previewImageUrl)).append("\n");
        sb.append("    promotedMetrics: ").append(this.toIndentedString(this.promotedMetrics)).append("\n");
        sb.append("    publicMetrics: ").append(this.toIndentedString(this.publicMetrics)).append("\n");
        sb.append("    variants: ").append(this.toIndentedString(this.variants)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        JsonArray jsonArrayvariants;
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_NON_PUBLIC_METRICS) != null) {
            VideoAllOfNonPublicMetrics.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_NON_PUBLIC_METRICS));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_ORGANIC_METRICS) != null) {
            VideoAllOfOrganicMetrics.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_ORGANIC_METRICS));
        }
        if (jsonObj.get(SERIALIZED_NAME_PREVIEW_IMAGE_URL) != null && !jsonObj.get(SERIALIZED_NAME_PREVIEW_IMAGE_URL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `preview_image_url` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PREVIEW_IMAGE_URL).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_PROMOTED_METRICS) != null) {
            VideoAllOfPromotedMetrics.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_PROMOTED_METRICS));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_PUBLIC_METRICS) != null) {
            VideoAllOfPublicMetrics.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_PUBLIC_METRICS));
        }
        if ((jsonArrayvariants = jsonObj.getAsJsonArray(SERIALIZED_NAME_VARIANTS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_VARIANTS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `variants` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_VARIANTS).toString()));
            }
            for (int i = 0; i < jsonArrayvariants.size(); ++i) {
                Variant.validateJsonObject(jsonArrayvariants.get(i).getAsJsonObject());
            }
        }
    }

    public static VideoAllOf fromJson(String jsonString) throws IOException {
        return (VideoAllOf)JSON.getGson().fromJson(jsonString, VideoAllOf.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_DURATION_MS);
        openapiFields.add(SERIALIZED_NAME_NON_PUBLIC_METRICS);
        openapiFields.add(SERIALIZED_NAME_ORGANIC_METRICS);
        openapiFields.add(SERIALIZED_NAME_PREVIEW_IMAGE_URL);
        openapiFields.add(SERIALIZED_NAME_PROMOTED_METRICS);
        openapiFields.add(SERIALIZED_NAME_PUBLIC_METRICS);
        openapiFields.add(SERIALIZED_NAME_VARIANTS);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!VideoAllOf.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(VideoAllOf.class));
            return new TypeAdapter<VideoAllOf>(){

                public void write(JsonWriter out, VideoAllOf value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public VideoAllOf read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    VideoAllOf.validateJsonObject(jsonObj);
                    return (VideoAllOf)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

