/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.clientlib.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.twitter.clientlib.JSON;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@ApiModel(description="Media information being attached to created Tweet. This is mutually exclusive from Quote Tweet Id and Poll.")
public class TweetCreateRequestMedia {
    public static final String SERIALIZED_NAME_MEDIA_IDS = "media_ids";
    @SerializedName(value="media_ids")
    private List<String> mediaIds = new ArrayList<String>();
    public static final String SERIALIZED_NAME_TAGGED_USER_IDS = "tagged_user_ids";
    @SerializedName(value="tagged_user_ids")
    private List<String> taggedUserIds = null;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public TweetCreateRequestMedia mediaIds(List<String> mediaIds) {
        this.mediaIds = mediaIds;
        return this;
    }

    public TweetCreateRequestMedia addMediaIdsItem(String mediaIdsItem) {
        this.mediaIds.add(mediaIdsItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="A list of Media Ids to be attached to a created Tweet.")
    public List<String> getMediaIds() {
        return this.mediaIds;
    }

    public void setMediaIds(List<String> mediaIds) {
        this.mediaIds = mediaIds;
    }

    public TweetCreateRequestMedia taggedUserIds(List<String> taggedUserIds) {
        this.taggedUserIds = taggedUserIds;
        return this;
    }

    public TweetCreateRequestMedia addTaggedUserIdsItem(String taggedUserIdsItem) {
        if (this.taggedUserIds == null) {
            this.taggedUserIds = new ArrayList<String>();
        }
        this.taggedUserIds.add(taggedUserIdsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A list of User Ids to be tagged in the media for created Tweet.")
    public List<String> getTaggedUserIds() {
        return this.taggedUserIds;
    }

    public void setTaggedUserIds(List<String> taggedUserIds) {
        this.taggedUserIds = taggedUserIds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TweetCreateRequestMedia tweetCreateRequestMedia = (TweetCreateRequestMedia)o;
        return Objects.equals(this.mediaIds, tweetCreateRequestMedia.mediaIds) && Objects.equals(this.taggedUserIds, tweetCreateRequestMedia.taggedUserIds);
    }

    public int hashCode() {
        return Objects.hash(this.mediaIds, this.taggedUserIds);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TweetCreateRequestMedia {\n");
        sb.append("    mediaIds: ").append(this.toIndentedString(this.mediaIds)).append("\n");
        sb.append("    taggedUserIds: ").append(this.toIndentedString(this.taggedUserIds)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_MEDIA_IDS) != null && !jsonObj.get(SERIALIZED_NAME_MEDIA_IDS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `media_ids` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MEDIA_IDS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TAGGED_USER_IDS) != null && !jsonObj.get(SERIALIZED_NAME_TAGGED_USER_IDS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `tagged_user_ids` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TAGGED_USER_IDS).toString()));
        }
    }

    public static TweetCreateRequestMedia fromJson(String jsonString) throws IOException {
        return (TweetCreateRequestMedia)JSON.getGson().fromJson(jsonString, TweetCreateRequestMedia.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_MEDIA_IDS);
        openapiFields.add(SERIALIZED_NAME_TAGGED_USER_IDS);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_MEDIA_IDS);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!TweetCreateRequestMedia.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(TweetCreateRequestMedia.class));
            return new TypeAdapter<TweetCreateRequestMedia>(){

                public void write(JsonWriter out, TweetCreateRequestMedia value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public TweetCreateRequestMedia read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    TweetCreateRequestMedia.validateJsonObject(jsonObj);
                    return (TweetCreateRequestMedia)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

