/*
 * Decompiled with CFR 0.152.
 */
package parquet.bytes;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import parquet.Log;
import parquet.bytes.BytesUtils;
import parquet.bytes.CapacityByteArrayOutputStream;

public abstract class BytesInput {
    private static final Log LOG = Log.getLog(BytesInput.class);
    private static final boolean DEBUG = false;
    private static final EmptyBytesInput EMPTY_BYTES_INPUT = new EmptyBytesInput();

    public static BytesInput concat(BytesInput ... inputs) {
        return new SequenceBytesIn(Arrays.asList(inputs));
    }

    public static BytesInput concat(List<BytesInput> inputs) {
        return new SequenceBytesIn(inputs);
    }

    public static BytesInput from(InputStream in, int bytes) {
        return new StreamBytesInput(in, bytes);
    }

    public static BytesInput from(byte[] in) {
        return new ByteArrayBytesInput(in, 0, in.length);
    }

    public static BytesInput from(byte[] in, int offset, int length) {
        return new ByteArrayBytesInput(in, offset, length);
    }

    public static BytesInput fromInt(int intValue) {
        return new IntBytesInput(intValue);
    }

    public static BytesInput from(CapacityByteArrayOutputStream arrayOut) {
        return new CapacityBAOSBytesInput(arrayOut);
    }

    public static BytesInput from(ByteArrayOutputStream baos) {
        return new BAOSBytesInput(baos);
    }

    public static BytesInput empty() {
        return EMPTY_BYTES_INPUT;
    }

    public static BytesInput copy(BytesInput bytesInput) throws IOException {
        return BytesInput.from(bytesInput.toByteArray());
    }

    public abstract void writeAllTo(OutputStream var1) throws IOException;

    public byte[] toByteArray() throws IOException {
        BAOS baos = new BAOS((int)this.size());
        this.writeAllTo(baos);
        return baos.getBuf();
    }

    public abstract long size();

    private static class ByteArrayBytesInput
    extends BytesInput {
        private final byte[] in;
        private final int offset;
        private final int length;

        private ByteArrayBytesInput(byte[] in, int offset, int length) {
            this.in = in;
            this.offset = offset;
            this.length = length;
        }

        @Override
        public void writeAllTo(OutputStream out) throws IOException {
            out.write(this.in, this.offset, this.length);
        }

        @Override
        public long size() {
            return this.length;
        }
    }

    private static class BAOSBytesInput
    extends BytesInput {
        private final ByteArrayOutputStream arrayOut;

        private BAOSBytesInput(ByteArrayOutputStream arrayOut) {
            this.arrayOut = arrayOut;
        }

        @Override
        public void writeAllTo(OutputStream out) throws IOException {
            this.arrayOut.writeTo(out);
        }

        @Override
        public long size() {
            return this.arrayOut.size();
        }
    }

    private static class CapacityBAOSBytesInput
    extends BytesInput {
        private final CapacityByteArrayOutputStream arrayOut;

        private CapacityBAOSBytesInput(CapacityByteArrayOutputStream arrayOut) {
            this.arrayOut = arrayOut;
        }

        @Override
        public void writeAllTo(OutputStream out) throws IOException {
            this.arrayOut.writeTo(out);
        }

        @Override
        public long size() {
            return this.arrayOut.size();
        }
    }

    private static class EmptyBytesInput
    extends BytesInput {
        private EmptyBytesInput() {
        }

        @Override
        public void writeAllTo(OutputStream out) throws IOException {
        }

        @Override
        public long size() {
            return 0L;
        }
    }

    private static class IntBytesInput
    extends BytesInput {
        private final int intValue;

        public IntBytesInput(int intValue) {
            this.intValue = intValue;
        }

        @Override
        public void writeAllTo(OutputStream out) throws IOException {
            BytesUtils.writeIntLittleEndian((OutputStream)out, (int)this.intValue);
        }

        @Override
        public long size() {
            return 4L;
        }
    }

    private static class SequenceBytesIn
    extends BytesInput {
        private static final Log LOG = Log.getLog(SequenceBytesIn.class);
        private final List<BytesInput> inputs;
        private final long size;

        private SequenceBytesIn(List<BytesInput> inputs) {
            this.inputs = inputs;
            long total = 0L;
            for (BytesInput input : inputs) {
                total += input.size();
            }
            this.size = total;
        }

        @Override
        public void writeAllTo(OutputStream out) throws IOException {
            for (BytesInput input : this.inputs) {
                input.writeAllTo(out);
            }
        }

        @Override
        public long size() {
            return this.size;
        }
    }

    private static class StreamBytesInput
    extends BytesInput {
        private static final Log LOG = Log.getLog(StreamBytesInput.class);
        private final InputStream in;
        private final int byteCount;

        private StreamBytesInput(InputStream in, int byteCount) {
            this.in = in;
            this.byteCount = byteCount;
        }

        @Override
        public void writeAllTo(OutputStream out) throws IOException {
            out.write(this.toByteArray());
        }

        @Override
        public byte[] toByteArray() throws IOException {
            byte[] buf = new byte[this.byteCount];
            new DataInputStream(this.in).readFully(buf);
            return buf;
        }

        @Override
        public long size() {
            return this.byteCount;
        }
    }

    private static final class BAOS
    extends ByteArrayOutputStream {
        private BAOS(int size) {
            super(size);
        }

        public byte[] getBuf() {
            return this.buf;
        }
    }
}

