/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.voice;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import com.twilio.voice.Constants;
import com.twilio.voice.Utils;
import org.json.JSONException;
import org.json.JSONObject;

class EventMetadata {
    String timeStamp;
    String productName;
    Constants.SeverityLevel level;
    String groupName;
    String eventName;
    String callSid;
    String payloadType;
    long timestampMS;
    boolean isPrivate = false;

    EventMetadata() {
    }

    String getTimeStamp() {
        return this.timeStamp;
    }

    Object getPayloadType() {
        return this.payloadType;
    }

    String getProductName() {
        return this.productName;
    }

    Constants.SeverityLevel getLevel() {
        return this.level;
    }

    boolean isPrivate() {
        return this.isPrivate;
    }

    String getGroupName() {
        return this.groupName;
    }

    String getEventName() {
        return this.eventName;
    }

    String getCallSid() {
        return this.callSid;
    }

    long getTimestampMillis() {
        return this.timestampMS;
    }

    JSONObject jsonEnvelopePreparation(String productName, String eventName, String groupName) throws JSONException {
        JSONObject envelope = new JSONObject();
        envelope.put("name", (Object)this.eventName);
        envelope.put("group", (Object)this.groupName);
        envelope.put("timestamp", (Object)this.timeStamp);
        envelope.put("level", (Object)this.level);
        envelope.put("private", this.isPrivate);
        envelope.put("payload_type", (Object)this.payloadType);
        envelope.put("publisher", (Object)this.productName);
        return envelope;
    }

    JSONObject jsonPublisherMetadataPreparation(Context context) throws JSONException {
        JSONObject publisherMetadata = new JSONObject();
        publisherMetadata.put("client_address", (Object)Utils.getIPAddress(false));
        publisherMetadata.put("os_name", (Object)"android");
        publisherMetadata.put("os_version", (Object)Build.VERSION.RELEASE);
        publisherMetadata.put("device_model", (Object)Build.MODEL);
        publisherMetadata.put("device_vendor", (Object)Build.MANUFACTURER);
        publisherMetadata.put("device_type", (Object)Build.MODEL);
        publisherMetadata.put("cpu_architecture", (Object)Build.CPU_ABI);
        if (context != null) {
            PackageManager packageManager = context.getPackageManager();
            PackageInfo packageInfo = null;
            try {
                packageInfo = packageManager.getPackageInfo(context.getPackageName(), 0);
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                // empty catch block
            }
            String appVersion = packageInfo.versionName;
            String appBuildNumber = String.valueOf(packageInfo.versionCode);
            ApplicationInfo applicationInfo = context.getApplicationInfo();
            int appNameStringId = applicationInfo.labelRes;
            if (appNameStringId != 0) {
                publisherMetadata.put("app_name", (Object)context.getString(appNameStringId));
            }
            publisherMetadata.put("app_id", (Object)applicationInfo.packageName);
            publisherMetadata.put("app_version", (Object)appVersion);
            publisherMetadata.put("app_build_number", (Object)appBuildNumber);
            if (Build.VERSION.SDK_INT >= 24) {
                publisherMetadata.put("app_min_os_version", applicationInfo.minSdkVersion);
            }
            publisherMetadata.put("app_target_os_version", applicationInfo.targetSdkVersion);
        }
        return publisherMetadata;
    }
}

