/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.voice;

import androidx.annotation.NonNull;
import com.twilio.voice.Preconditions;

public class CallMessage {
    private final String messageType;
    private String voiceEventSid;
    private final String contentType;
    private final String content;

    @NonNull
    public String getMessageType() {
        return this.messageType;
    }

    @NonNull
    public String getMessageContentType() {
        return this.contentType;
    }

    @NonNull
    public String getContent() {
        return this.content;
    }

    @NonNull
    public String getVoiceEventSID() {
        return this.voiceEventSid;
    }

    private CallMessage(String messageType, String contentType, String content, String voiceEventSid) {
        this.messageType = messageType;
        this.contentType = contentType;
        this.content = content;
        this.voiceEventSid = voiceEventSid;
    }

    public static class Builder {
        private String messageType;
        private String contentType;
        private String content;

        public Builder(@NonNull String messageType) {
            Preconditions.checkNotNull(messageType, "messageType must not be null");
            Preconditions.checkArgument(messageType.length() > 0, "messageType must not be empty");
            this.messageType = messageType;
            this.contentType = "application/json";
            this.content = "";
        }

        public Builder contentType(@NonNull String contentType) {
            Preconditions.checkNotNull(contentType, "contentType must not be null");
            this.contentType = contentType;
            return this;
        }

        public Builder content(@NonNull String content) {
            Preconditions.checkNotNull(content, "content must not be null");
            this.content = content;
            return this;
        }

        public CallMessage build() {
            return new CallMessage(this.messageType, this.contentType, this.content, "");
        }
    }
}

