/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.voice;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.os.Handler;
import android.util.Pair;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.twilio.voice.Call;
import com.twilio.voice.CallException;
import com.twilio.voice.CallInvite;
import com.twilio.voice.CallMessage;
import com.twilio.voice.CancelledCallInvite;
import com.twilio.voice.ConnectivityReceiver;
import com.twilio.voice.Constants;
import com.twilio.voice.EventPayload;
import com.twilio.voice.EventPublisher;
import com.twilio.voice.InsightsUtils;
import com.twilio.voice.Logger;
import com.twilio.voice.MediaFactory;
import com.twilio.voice.MessageListener;
import com.twilio.voice.Preconditions;
import com.twilio.voice.ThreadUtils;
import com.twilio.voice.Utils;
import com.twilio.voice.Voice;
import java.util.Map;

class CallInviteProxy
implements MessageListener {
    private static final Logger logger = Logger.getLogger(CallInviteProxy.class);
    private final ThreadUtils.ThreadChecker threadChecker;
    private final Context context;
    long nativeCallInviteProxy;
    private final Handler handler;
    private final MessageListener messageListener;
    private final MediaFactory mediaFactory;
    @Nullable
    private Call.EventListener eventListener;
    private boolean released = false;
    private ConnectivityReceiver connectivityReceiver = null;
    private Call call;
    private CallInvite callInvite;
    private String selectedRegion = Voice.region;
    private String gateway;
    private String region;
    String codecParams;
    String selectedCodec;
    private EventPublisher publisher;
    private String tempCallSid;
    private final Call.EventListener eventListenerProxy = new Call.EventListener(){

        @Override
        public void onEvent(Map<String, Pair<String, Class>> data) {
            CallInviteProxy.this.handler.post(() -> {
                CallInviteProxy.this.threadChecker.checkIsOnValidThread();
                logger.d("CallInviteProxy::eventListenerProxy::onEvent(...)");
                if (((String)((Pair)data.get((Object)"group")).first).equals("registration") && ((String)((Pair)data.get((Object)"name")).first).equals("unsupported-cancel-message-error")) {
                    CallInviteProxy.this.release((String)((Pair)data.get((Object)"call-sid")).first);
                }
                if (CallInviteProxy.this.eventListener != null) {
                    CallInviteProxy.this.eventListener.onEvent(data);
                }
                CallInviteProxy.this.publishEvent(data);
            });
        }

        @Override
        public void onMetric(Map<String, Pair<String, Class>> data) {
            CallInviteProxy.this.handler.post(() -> {
                CallInviteProxy.this.threadChecker.checkIsOnValidThread();
                logger.d("onMetric");
                if (CallInviteProxy.this.eventListener != null) {
                    CallInviteProxy.this.eventListener.onMetric(data);
                }
                if (((String)((Pair)data.get((Object)"group")).first).equals("quality-metrics-samples")) {
                    CallInviteProxy.this.call.onSample(InsightsUtils.createRtcSample(data));
                }
            });
        }
    };

    @Override
    public void onCallInvite(@NonNull CallInvite callInvite) {
        this.handler.post(() -> {
            this.threadChecker.checkIsOnValidThread();
            this.threadChecker.checkIsOnValidThread();
            logger.d("onCallInvite");
            Voice.callInviteProxyMap.put(callInvite.getCallSid(), this);
            this.registerConnectivityBroadcastReceiver();
            this.messageListener.onCallInvite(callInvite);
        });
    }

    @Override
    public void onCancelledCallInvite(@NonNull CancelledCallInvite cancelledCallInvite, @Nullable CallException callException) {
        this.handler.post(() -> {
            this.threadChecker.checkIsOnValidThread();
            logger.d("onCancelledCallInvite: CallException code: " + (callException == null ? "null" : Integer.valueOf(callException.getErrorCode())));
            boolean wasReleased = this.released;
            this.release(cancelledCallInvite.getCallSid());
            if (!wasReleased) {
                this.messageListener.onCancelledCallInvite(cancelledCallInvite, callException);
            }
        });
    }

    synchronized void setEventListener(Call.EventListener eventListener) {
        this.threadChecker.checkIsOnValidThread();
        this.eventListener = eventListener;
    }

    synchronized void setCall(Call call) {
        this.threadChecker.checkIsOnValidThread();
        this.call = call;
    }

    synchronized void setTempCallSid(String tempCallSid) {
        this.threadChecker.checkIsOnValidThread();
        this.tempCallSid = tempCallSid;
    }

    synchronized EventPublisher getPublisher() {
        this.threadChecker.checkIsOnValidThread();
        return this.publisher;
    }

    void networkChange(Voice.NetworkChangeEvent networkChangeEvent) {
        this.threadChecker.checkIsOnValidThread();
        if (!this.released && this.nativeCallInviteProxy != 0L) {
            this.nativeNetworkChange(this.nativeCallInviteProxy, networkChangeEvent);
        } else {
            logger.d("Ignoring networkChangeEvent: " + networkChangeEvent.name() + " because CallInviteProxy is either released or is not set.");
        }
    }

    synchronized void release(String callSid) {
        logger.d("CallInviteProxy::release");
        this.threadChecker.checkIsOnValidThread();
        if (!this.released) {
            this.unregisterConnectivityBroadcastReceiver();
            Voice.callInviteProxyMap.remove(callSid);
            if (this.nativeCallInviteProxy != 0L) {
                this.nativeRelease(this.nativeCallInviteProxy);
                this.nativeCallInviteProxy = 0L;
            }
            this.mediaFactory.release(this);
            this.released = true;
        }
    }

    String sendMessage(CallMessage message) {
        if (!this.released && this.nativeCallInviteProxy != 0L) {
            return this.nativeSendMessage(this.nativeCallInviteProxy, message);
        }
        logger.d("Ignoring sendMessage:" + message.getContent() + " because CallInviteProxy is either released or is not set.");
        return "";
    }

    CallInviteProxy(Context context, Handler handler, MessageListener messageListener, Call.EventListener eventListener, CallInvite callInvite) {
        Preconditions.checkApplicationContext(context, "must create Call with application context");
        this.context = context;
        this.handler = handler;
        this.threadChecker = new ThreadUtils.ThreadChecker(handler.getLooper().getThread());
        this.messageListener = messageListener;
        this.eventListener = eventListener;
        this.mediaFactory = MediaFactory.instance(this, context);
        this.callInvite = callInvite;
        String bridgeToken = null;
        if (Voice.callSidBridgeTokenPair != null) {
            String string = bridgeToken = ((String)Voice.callSidBridgeTokenPair.first).equals(callInvite.getCallSid()) ? (String)Voice.callSidBridgeTokenPair.second : null;
        }
        if (bridgeToken != null) {
            this.publisher = new EventPublisher(context, Constants.getClientSdkProductName(), bridgeToken);
            this.publisher.addListener(voiceException -> logger.e("Error publishing data : " + voiceException.getMessage() + ":" + voiceException.getErrorCode()));
        }
    }

    private void registerConnectivityBroadcastReceiver() {
        this.connectivityReceiver = new ConnectivityReceiver();
        this.context.registerReceiver((BroadcastReceiver)this.connectivityReceiver, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
    }

    private void unregisterConnectivityBroadcastReceiver() {
        if (this.connectivityReceiver != null) {
            this.context.unregisterReceiver((BroadcastReceiver)this.connectivityReceiver);
        }
    }

    private void publishEvent(Map<String, Pair<String, Class>> data) {
        if (((String)data.get((Object)"group").first).equals("settings")) {
            if (((String)data.get((Object)"name").first).equals("codec")) {
                this.codecParams = (String)data.get((Object)"codec_params").first;
                this.selectedCodec = (String)data.get((Object)"selected_codec").first;
            } else if (((String)data.get((Object)"name").first).equals("edge")) {
                this.gateway = (String)data.get((Object)"edge-host-name").first;
                this.region = (String)data.get((Object)"edge").first;
            }
            InsightsUtils.processEvent(data, this.createEventPayloadBuilderForSettingsEvent(), this.publisher, Constants.Direction.INCOMING);
        } else {
            InsightsUtils.processEvent(data, this.createEventPayloadBuilder(), this.publisher, Constants.Direction.INCOMING);
        }
    }

    private EventPayload.Builder createEventPayloadBuilder() {
        return new EventPayload.Builder().callSid(this.callInvite.getCallSid()).tempCallSid(this.tempCallSid).messageSid(this.callInvite.getMessageSid()).direction(Constants.Direction.INCOMING).selectedRegion(this.selectedRegion).gateway(this.gateway).region(this.region).productName(Constants.getClientSdkProductName()).clientName(Utils.parseClientIdentity(this.callInvite.getTo())).payLoadType("application/json");
    }

    EventPayload.Builder createEventPayloadBuilderForSettingsEvent() {
        return this.createEventPayloadBuilder().codecParams(this.codecParams).selectedCodec(this.selectedCodec);
    }

    private native void nativeNetworkChange(long var1, Voice.NetworkChangeEvent var3);

    private native void nativeRelease(long var1);

    private native String nativeSendMessage(long var1, CallMessage var3);
}

