/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.video;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Handler;
import android.os.Looper;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.twilio.video.EglBaseProvider;
import com.twilio.video.Logger;
import com.twilio.video.R;
import com.twilio.video.UtilKt;
import com.twilio.video.VideoScaleType;
import com.twilio.video.VideoSinkHintsConsumer;
import com.twilio.video.VideoSinkHintsProducer;
import tvi.webrtc.RendererCommon;
import tvi.webrtc.SurfaceViewRenderer;
import tvi.webrtc.VideoFrame;

public class VideoView
extends SurfaceViewRenderer {
    private static final Logger logger = Logger.getLogger(VideoView.class);
    private final Handler uiThreadHandler = new Handler(Looper.getMainLooper());
    @VisibleForTesting
    VideoSinkHintsProducer videoSinkHintsProducer;
    private View.OnAttachStateChangeListener onAttachStateChangeListener = new View.OnAttachStateChangeListener(){

        public void onViewDetachedFromWindow(View v) {
            if (VideoView.this.videoSinkHintsProducer != null) {
                VideoView.this.videoSinkHintsProducer.produceSinkHints(8);
            }
        }

        public void onViewAttachedToWindow(View v) {
            if (VideoView.this.videoSinkHintsProducer != null) {
                VideoView.this.videoSinkHintsProducer.produceSinkHints(0);
            }
        }
    };
    private final RendererCommon.RendererEvents internalEventListener = new RendererCommon.RendererEvents(){

        public void onFirstFrameRendered() {
            VideoView.this.refreshRenderer();
            if (VideoView.this.listener != null) {
                VideoView.this.listener.onFirstFrameRendered();
            }
        }

        public void onFrameResolutionChanged(int videoWidth, int videoHeight, int rotation) {
            VideoView.this.refreshRenderer();
            if (VideoView.this.listener != null) {
                VideoView.this.listener.onFrameResolutionChanged(videoWidth, videoHeight, rotation);
            }
        }
    };
    private boolean mirror;
    private boolean overlaySurface;
    private VideoScaleType videoScaleType;
    private RendererCommon.RendererEvents listener;
    private EglBaseProvider eglBaseProvider;

    public VideoView(@NonNull Context context) {
        this(context, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VideoView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.VideoView, 0, 0);
        try {
            this.mirror = a.getBoolean(R.styleable.VideoView_tviMirror, false);
            this.videoScaleType = VideoScaleType.fromInt(a.getInteger(R.styleable.VideoView_tviScaleType, 0));
            this.overlaySurface = a.getBoolean(R.styleable.VideoView_tviOverlaySurface, false);
        }
        finally {
            a.recycle();
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (!this.isInEditMode()) {
            this.eglBaseProvider = EglBaseProvider.instance((Object)this);
            this.setupRenderer();
        }
    }

    public void onFrame(VideoFrame frame) {
        frame.retain();
        super.onFrame(frame);
        frame.release();
    }

    protected void onDetachedFromWindow() {
        super.release();
        this.eglBaseProvider.release((Object)this);
        super.onDetachedFromWindow();
    }

    protected void onVisibilityChanged(View changedView, int visibility) {
        super.onVisibilityChanged(changedView, visibility);
        if (this.videoSinkHintsProducer != null) {
            this.videoSinkHintsProducer.produceSinkHints(visibility);
        }
    }

    protected void onSizeChanged(int width, int height, int oldWidth, int oldHeight) {
        super.onSizeChanged(width, height, oldWidth, oldHeight);
        if (this.videoSinkHintsProducer != null) {
            int widthDp = UtilKt.convertPixelsToDp(this.getContext(), width);
            int heightDp = UtilKt.convertPixelsToDp(this.getContext(), height);
            this.videoSinkHintsProducer.produceSinkHints(widthDp, heightDp);
        }
    }

    public boolean getMirror() {
        return this.mirror;
    }

    public void setMirror(boolean mirror) {
        if (this.mirror != mirror) {
            this.mirror = mirror;
            super.setMirror(mirror);
            this.refreshRenderer();
        }
    }

    @NonNull
    public VideoScaleType getVideoScaleType() {
        return this.videoScaleType;
    }

    public void setVideoScaleType(@NonNull VideoScaleType videoScaleType) {
        ViewGroup.LayoutParams layoutParams = this.getLayoutParams();
        if (layoutParams != null && (layoutParams.width == -1 || layoutParams.height == -1)) {
            VideoScaleType widthScaleType = layoutParams.width == -1 ? VideoScaleType.ASPECT_FILL : videoScaleType;
            VideoScaleType heightScaleType = layoutParams.height == -1 ? VideoScaleType.ASPECT_FILL : videoScaleType;
            logger.w(String.format("Scale type may not be applied as expected because video view uses MATCH_PARENT. Scaling will be applied as follows: width=%s, height=%s", widthScaleType.name(), heightScaleType.name()));
        }
        this.videoScaleType = videoScaleType;
        this.setScalingType(this.convertToWebRtcScaleType(videoScaleType));
        this.refreshRenderer();
    }

    public void setListener(@Nullable RendererCommon.RendererEvents listener) {
        this.listener = listener;
    }

    public void applyZOrder(boolean overlaySurface) {
        this.overlaySurface = overlaySurface;
        this.setZOrderMediaOverlay(overlaySurface);
    }

    void setupVideoSinkHintsProducer(VideoSinkHintsConsumer videoSinkHintsConsumer, long sinkHintsId) {
        this.videoSinkHintsProducer = new VideoSinkHintsProducer(this.getContext().getResources().getDisplayMetrics().densityDpi, videoSinkHintsConsumer, sinkHintsId, this.getVisibility(), UtilKt.convertPixelsToDp(this.getContext(), this.getWidth()), UtilKt.convertPixelsToDp(this.getContext(), this.getHeight()));
        this.addOnAttachStateChangeListener(this.onAttachStateChangeListener);
    }

    void removeVideoSinkHintsProducer() {
        this.videoSinkHintsProducer = null;
        this.removeOnAttachStateChangeListener(this.onAttachStateChangeListener);
    }

    long getSinkHintsId() {
        return this.videoSinkHintsProducer.getSinkHintsId();
    }

    private void setupRenderer() {
        this.init(this.eglBaseProvider.getRootEglBase().getEglBaseContext(), this.internalEventListener);
        this.setScalingType(this.convertToWebRtcScaleType(this.videoScaleType));
        this.setZOrderMediaOverlay(this.overlaySurface);
        super.setMirror(this.mirror);
        this.refreshRenderer();
    }

    private void refreshRenderer() {
        this.uiThreadHandler.post(() -> ((VideoView)this).requestLayout());
    }

    private RendererCommon.ScalingType convertToWebRtcScaleType(VideoScaleType videoScaleType) {
        switch (videoScaleType) {
            case ASPECT_FILL: {
                return RendererCommon.ScalingType.SCALE_ASPECT_FILL;
            }
            case ASPECT_BALANCED: {
                return RendererCommon.ScalingType.SCALE_ASPECT_BALANCED;
            }
        }
        return RendererCommon.ScalingType.SCALE_ASPECT_FIT;
    }
}

