package com.twilio.video;

import androidx.annotation.NonNull;

/**
 * The preferences that are used to specify the render dimensions of a {@link RemoteVideoTrack} when
 * using {@link VideoContentPreferencesMode#MANUAL}.
 */
public class VideoContentPreferences {
    private final VideoDimensions renderDimensions;

    /**
     * Constructs an instance of this class.
     *
     * @param renderDimensions the render dimensions to specify in the {@link RemoteVideoTrack}.
     * @throws NullPointerException if renderDimensions is null.
     */
    public VideoContentPreferences(@NonNull VideoDimensions renderDimensions) {
        Preconditions.checkNotNull(renderDimensions);
        this.renderDimensions = renderDimensions;
    }

    @NonNull
    public VideoDimensions getRenderDimensions() {
        return renderDimensions;
    }

    @Override
    public String toString() {
        return "VideoContentPreferences{" + "renderDimensions=" + renderDimensions + '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        VideoContentPreferences that = (VideoContentPreferences) o;

        return renderDimensions.equals(that.renderDimensions);
    }

    @Override
    public int hashCode() {
        return renderDimensions.hashCode();
    }
}
