package com.twilio.video;

import androidx.annotation.NonNull;
import java.util.List;
import tvi.webrtc.RTCStatsReport;

/**
 * Interface that provides event related to {@link Room#getRtcStats(RtcStatsListener)}. This
 * interface is package private.
 */
interface RtcStatsListener {
    /**
     * Notifies when the RTC stats reports for all the Peer Connections in the Room are ready. The
     * WebRTC stats spec can be found here: https://w3c.github.io/webrtc-stats
     *
     * @param statsReports RTC stats reports for all Peer Connections in the Room.
     */
    void onRtcStats(@NonNull List<RTCStatsReport> statsReports);
}
