/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.video;

import android.content.Context;
import android.content.res.AssetManager;
import androidx.annotation.VisibleForTesting;
import com.twilio.video.Logger;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Properties;

class GlobalConfiguration {
    public static final String SYSPROP_GLOBAL_CONFIG_FILE = "com.twilio.video.Video.configPath";
    public static final String DEFAULT_CONFIG_FILE = "twilio-video-config.properties";
    private final Properties _configuration = new Properties(System.getProperties());
    private static GlobalConfiguration _instance = null;
    private static final Logger _logger = Logger.getLogger(GlobalConfiguration.class);

    public static GlobalConfiguration getInstance(Context context) {
        if (null == _instance) {
            _instance = new GlobalConfiguration(context);
        }
        return _instance;
    }

    public Properties getConfig() {
        return this._configuration;
    }

    @VisibleForTesting(otherwise=5)
    static void release() {
        _instance = null;
    }

    private GlobalConfiguration(Context context) {
        AssetManager assetManager = context.getAssets();
        try {
            String configFilePath = System.getProperty(SYSPROP_GLOBAL_CONFIG_FILE, DEFAULT_CONFIG_FILE);
            InputStream inputStream = assetManager.open(configFilePath);
            this._configuration.load(inputStream);
            inputStream.close();
        }
        catch (FileNotFoundException fnfe) {
            _logger.i("There is no Global Configuration override file: twilio-video-config.properties");
        }
        catch (Exception e) {
            _logger.e("Global Configuration override file: com.twilio.video.Video.configPath failed to load. Error:" + e.getMessage());
            e.printStackTrace();
        }
    }
}

