package com.twilio.video;

import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Handler;
import android.os.Looper;

// TODO Move everything to Util.kt
/*
 * Junk drawer of utility methods needed throughout SDK.
 */
final class Util {
    /*
     * Return a handler on the thread looper, or the main thread looper if the calling thread
     * does not have a looper. If neither are available this handler will return null.
     */
    static Handler createCallbackHandler() {
        Handler handler = null;
        Looper looper;

        if ((looper = Looper.myLooper()) != null) {
            handler = new Handler(looper);
        } else if ((looper = Looper.getMainLooper()) != null) {
            handler = new Handler(looper);
        }
        if (handler == null) {
            throw new IllegalThreadStateException("This thread must be able to obtain a Looper");
        }

        return handler;
    }

    static boolean permissionGranted(Context context, String permission) {
        int permissionCheck = context.checkCallingOrSelfPermission(permission);

        return permissionCheck == PackageManager.PERMISSION_GRANTED;
    }

    /*
     * Replace with the java.util.Objects.equals() method once API 19 is the minimum.
     */
    static boolean equals(Object a, Object b) {
        return (a == b) || (a != null && a.equals(b));
    }
}
