/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.video;

import androidx.annotation.NonNull;
import java.nio.ByteBuffer;
import tvi.webrtc.JavaI420Buffer;
import tvi.webrtc.VideoFrame;

public class Argb8888Buffer
implements VideoFrame.Buffer {
    private final ByteBuffer data;
    private final int width;
    private final int height;

    public Argb8888Buffer(@NonNull ByteBuffer data, int width, int height) {
        this.data = data;
        this.width = width;
        this.height = height;
    }

    public Argb8888Buffer(@NonNull VideoFrame.I420Buffer buffer) {
        this.width = buffer.getWidth();
        this.height = buffer.getHeight();
        this.data = ByteBuffer.allocateDirect(this.width * this.height * 4);
        Argb8888Buffer.native420ToARGB(this.width, this.height, buffer.getStrideY(), buffer.getStrideU(), buffer.getStrideV(), this.data, buffer.getDataY(), buffer.getDataV(), buffer.getDataU());
    }

    public ByteBuffer getData() {
        return this.data;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public VideoFrame.I420Buffer toI420() {
        return (VideoFrame.I420Buffer)this.cropAndScale(0, 0, this.width, this.height, this.width, this.height);
    }

    public void retain() {
    }

    public void release() {
    }

    public VideoFrame.Buffer cropAndScale(int cropX, int cropY, int cropWidth, int cropHeight, int scaleWidth, int scaleHeight) {
        JavaI420Buffer newBuffer = JavaI420Buffer.allocate((int)scaleWidth, (int)scaleHeight);
        Argb8888Buffer.nativeCropAndScale(cropX, cropY, cropWidth, cropHeight, scaleWidth, scaleHeight, this.data.array(), this.width, this.height, newBuffer.getDataY(), newBuffer.getStrideY(), newBuffer.getDataU(), newBuffer.getStrideU(), newBuffer.getDataV(), newBuffer.getStrideV());
        return newBuffer;
    }

    private static native void nativeCropAndScale(int var0, int var1, int var2, int var3, int var4, int var5, byte[] var6, int var7, int var8, ByteBuffer var9, int var10, ByteBuffer var11, int var12, ByteBuffer var13, int var14);

    private static native void native420ToARGB(int var0, int var1, int var2, int var3, int var4, ByteBuffer var5, ByteBuffer var6, ByteBuffer var7, ByteBuffer var8);
}

