/*
 * Decompiled with CFR 0.152.
 */
package tvi.webrtc;

import android.support.annotation.Nullable;
import android.util.Log;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import tvi.webrtc.EglBase;
import tvi.webrtc.HardwareVideoEncoderFactory;
import tvi.webrtc.SoftwareVideoEncoderFactory;
import tvi.webrtc.VideoCodecInfo;
import tvi.webrtc.VideoCodecMimeType;
import tvi.webrtc.VideoEncoder;
import tvi.webrtc.VideoEncoderFactory;
import tvi.webrtc.VideoEncoderFallback;

public class DefaultVideoEncoderFactory
implements VideoEncoderFactory {
    public static final String PROP_ENABLE_HARDWARE_ENCODING = "tvi.webrtc.DefaultVideoEncoderFactory.enableHWEncoding";
    public static final String PROP_ENABLE_HARDWARE_VP8_ENCODING = "tvi.webrtc.DefaultVideoEncoderFactory.enableHWVP8Encoding";
    public static final String PROP_ENABLE_HARDWARE_VP9_ENCODING = "tvi.webrtc.DefaultVideoEncoderFactory.enableHWVP9Encoding";
    public static final String PROP_ENABLE_HARDWARE_H264_ENCODING = "tvi.webrtc.DefaultVideoEncoderFactory.enableHWH264Encoding";
    public static final String PROP_ENABLE_HARDWARE_H264_HIGH_PROFILE = "tvi.webrtc.HardwareVideoEncoderFactory.enableH264HighProfile";
    public static final String PROP_ENABLE_HARDWARE_VP8_INTEL_ENCODER = "tvi.webrtc.HardwareVideoEncoderFactory.enableIntelVP8Encoder";
    public static final String PROP_ENABLE_HARDWARE_H264_HUAWEI_ENCODER = "tvi.webrtc.HardwareVideoEncoderFactory.enableH264HuaweiSupport";
    private static final String TAG = "DefaultVideoEncoderFactory";
    private final VideoEncoderFactory hardwareVideoEncoderFactory;
    private final VideoEncoderFactory softwareVideoEncoderFactory = new SoftwareVideoEncoderFactory();
    private final boolean enableHardwareEncoding;
    private final Map<String, Boolean> HardwareCodecInclusionTbl;

    public DefaultVideoEncoderFactory(EglBase.Context eglContext, boolean enableIntelVp8Encoder, boolean enableH264HighProfile) {
        this(DefaultVideoEncoderFactory.createHardwareVideoEncoderFactory(eglContext, enableIntelVp8Encoder, enableH264HighProfile, false), true, DefaultVideoEncoderFactory.createHardwareEncoderInclusionList(new Properties()));
    }

    public DefaultVideoEncoderFactory(EglBase.Context eglContext, boolean enableIntelVp8Encoder, boolean enableH264HighProfile, boolean enableH264HuaweiSupport) {
        this(DefaultVideoEncoderFactory.createHardwareVideoEncoderFactory(eglContext, enableIntelVp8Encoder, enableH264HighProfile, enableH264HuaweiSupport), true, DefaultVideoEncoderFactory.createHardwareEncoderInclusionList(new Properties()));
    }

    public DefaultVideoEncoderFactory(EglBase.Context eglContext, Properties config) {
        this(DefaultVideoEncoderFactory.createHardwareVideoEncoderFactory(eglContext, Boolean.valueOf(config.getProperty(PROP_ENABLE_HARDWARE_VP8_INTEL_ENCODER, "true")), Boolean.valueOf(config.getProperty(PROP_ENABLE_HARDWARE_H264_HIGH_PROFILE, "false")), Boolean.valueOf(config.getProperty(PROP_ENABLE_HARDWARE_H264_HUAWEI_ENCODER, "false"))), (boolean)Boolean.valueOf(config.getProperty(PROP_ENABLE_HARDWARE_ENCODING, "true")), DefaultVideoEncoderFactory.createHardwareEncoderInclusionList(config));
    }

    DefaultVideoEncoderFactory(VideoEncoderFactory hardwareVideoEncoderFactory) {
        this(hardwareVideoEncoderFactory, true, DefaultVideoEncoderFactory.createHardwareEncoderInclusionList(new Properties()));
    }

    private DefaultVideoEncoderFactory(VideoEncoderFactory hardwareVideoEncoderFactory, boolean enableHardwareEncoding, Map<String, Boolean> inclusionTbl) {
        this.hardwareVideoEncoderFactory = hardwareVideoEncoderFactory;
        this.enableHardwareEncoding = enableHardwareEncoding;
        this.HardwareCodecInclusionTbl = inclusionTbl;
        Log.i((String)TAG, (String)("tvi.webrtc.DefaultVideoEncoderFactory.enableHWEncoding:" + enableHardwareEncoding));
        for (String key : this.HardwareCodecInclusionTbl.keySet()) {
            Log.i((String)TAG, (String)(key + ": " + this.HardwareCodecInclusionTbl.get(key)));
        }
    }

    @Override
    @Nullable
    public VideoEncoder createEncoder(VideoCodecInfo info) {
        VideoEncoder hardwareEncoder = null;
        VideoEncoder softwareEncoder = this.softwareVideoEncoderFactory.createEncoder(info);
        VideoCodecMimeType type = VideoCodecMimeType.valueOf(info.name);
        try {
            if (this.isHardwareEnabled(info)) {
                hardwareEncoder = this.hardwareVideoEncoderFactory.createEncoder(info);
                if (hardwareEncoder != null && softwareEncoder != null) {
                    Log.i((String)TAG, (String)("VideoEncoderFallback encoder used (" + type.mimeType() + ")"));
                    return new VideoEncoderFallback(softwareEncoder, hardwareEncoder);
                }
                Log.i((String)TAG, (String)((hardwareEncoder != null ? "Hardware" : "Software") + " encoder used (" + type.mimeType() + ")"));
                return hardwareEncoder != null ? hardwareEncoder : softwareEncoder;
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("Failed to create hardware video encoder for " + type.mimeType()), (Throwable)e);
        }
        Log.i((String)TAG, (String)("Software encoder used (" + type.mimeType() + ")"));
        return softwareEncoder;
    }

    @Override
    public VideoCodecInfo[] getSupportedCodecs() {
        LinkedHashSet<VideoCodecInfo> supportedCodecInfos = new LinkedHashSet<VideoCodecInfo>();
        supportedCodecInfos.addAll(Arrays.asList(this.softwareVideoEncoderFactory.getSupportedCodecs()));
        for (VideoCodecInfo info : this.hardwareVideoEncoderFactory.getSupportedCodecs()) {
            if (!this.isHardwareEnabled(info)) continue;
            supportedCodecInfos.add(info);
        }
        return supportedCodecInfos.toArray(new VideoCodecInfo[supportedCodecInfos.size()]);
    }

    private boolean isHardwareEnabled(VideoCodecInfo info) {
        VideoCodecMimeType type = VideoCodecMimeType.valueOf(info.name);
        Log.i((String)TAG, (String)("enableHardwareEncoding:" + this.enableHardwareEncoding + ", isHardwareEnabledForMimetype(): " + this.isHardwareEnabledForMimetype(type.mimeType())));
        return this.enableHardwareEncoding && this.isHardwareEnabledForMimetype(type.mimeType());
    }

    private boolean isHardwareEnabledForMimetype(String mimeType) {
        return this.HardwareCodecInclusionTbl.containsKey(mimeType) ? this.HardwareCodecInclusionTbl.get(mimeType) : true;
    }

    private static HardwareVideoEncoderFactory createHardwareVideoEncoderFactory(EglBase.Context eglContext, boolean enableIntelVp8Encoder, boolean enableH264HighProfile, boolean enableH264HuaweiSupport) {
        Log.i((String)TAG, (String)("HardwareVideoEncoderFactory Constructed:\n\tenableIntelVp8Encoder:" + enableIntelVp8Encoder + "\n\tenableH264HuaweiSupport:" + enableH264HuaweiSupport));
        return new HardwareVideoEncoderFactory(eglContext, enableIntelVp8Encoder, enableH264HighProfile, enableH264HuaweiSupport);
    }

    private static Map<String, Boolean> createHardwareEncoderInclusionList(final Properties config) {
        return new HashMap<String, Boolean>(){
            {
                this.put(VideoCodecMimeType.VP8.mimeType(), Boolean.valueOf(config.getProperty(DefaultVideoEncoderFactory.PROP_ENABLE_HARDWARE_VP8_ENCODING, "true")));
                this.put(VideoCodecMimeType.VP9.mimeType(), Boolean.valueOf(config.getProperty(DefaultVideoEncoderFactory.PROP_ENABLE_HARDWARE_VP9_ENCODING, "true")));
                this.put(VideoCodecMimeType.H264.mimeType(), Boolean.valueOf(config.getProperty(DefaultVideoEncoderFactory.PROP_ENABLE_HARDWARE_H264_ENCODING, "true")));
            }
        };
    }
}

