package com.twilio.video;

import androidx.annotation.NonNull;

public class LocalAudioTrackStats extends LocalTrackStats {
    /** Audio input level */
    public final int audioLevel;

    /** Packet jitter measured in milliseconds */
    public final int jitter;

    LocalAudioTrackStats(
            @NonNull String trackSid,
            int packetsLost,
            @NonNull String codec,
            @NonNull String ssrc,
            double timestamp,
            long bytesSent,
            int packetsSent,
            long roundTripTime,
            int audioLevel,
            int jitter) {
        super(trackSid, packetsLost, codec, ssrc, timestamp, bytesSent, packetsSent, roundTripTime);
        this.audioLevel = audioLevel;
        this.jitter = jitter;
    }
}
