package com.twilio.video;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

/**
 * Statistics of ICE candidate as defined in <a
 * href="https://www.w3.org/TR/webrtc-stats/#icecandidate-dict*">Identifiers for WebRTC's Statistics
 * API</a>
 */
public class IceCandidateStats {
    /** Unique identifier of the underlying candidate. */
    @NonNull public final String transportId;

    /** True indicates remote candidate and false indicates local candidate. */
    public final boolean isRemote;

    /** IP address of the candidate. */
    @NonNull public final String ip;

    /** Port number of the candidate. */
    public final int port;

    /** Transport of the candidate, valid values are udp or tcp. */
    @NonNull public final String protocol;

    /**
     * Candidate type. It can be host (host candidate), srflx (server reflexive candidate), prflx
     * (peer reflexive candidate) and relay (relay candidate).
     */
    @NonNull public final String candidateType;

    /** Priority as defined in <a href="https://tools.ietf.org/html/rfc5245">RFC 5245</a>. */
    public final int priority;

    /** The URL of the TURN or STUN server. */
    @Nullable public final String url;

    /** The candidate is no longer active. */
    public final boolean deleted;

    public IceCandidateStats(
            @NonNull final String transportId,
            final boolean isRemote,
            @NonNull final String ip,
            final int port,
            @NonNull final String protocol,
            @NonNull final String candidateType,
            final int priority,
            @Nullable final String url,
            final boolean deleted) {
        this.transportId = transportId;
        this.isRemote = isRemote;
        this.ip = ip;
        this.port = port;
        this.protocol = protocol;
        this.candidateType = candidateType;
        this.priority = priority;
        this.url = url;
        this.deleted = deleted;
    }
}
