package com.twilio.video;

import androidx.annotation.NonNull;

public class LocalVideoTrackStats extends LocalTrackStats {
    /** Captured frame dimensions */
    @NonNull public final VideoDimensions captureDimensions;

    /** Captured frame rate */
    public final int capturedFrameRate;

    /** Sent frame dimensions */
    @NonNull public final VideoDimensions dimensions;

    /** Sent frame rate */
    public final int frameRate;

    LocalVideoTrackStats(
            String trackSid,
            int packetsLost,
            String codec,
            String ssrc,
            double timestamp,
            long bytesSent,
            int packetsSent,
            long roundTripTime,
            @NonNull VideoDimensions captureDimensions,
            @NonNull VideoDimensions dimensions,
            int capturedFrameRate,
            int frameRate) {
        super(trackSid, packetsLost, codec, ssrc, timestamp, bytesSent, packetsSent, roundTripTime);
        this.captureDimensions = captureDimensions;
        this.dimensions = dimensions;
        this.frameRate = frameRate;
        this.capturedFrameRate = capturedFrameRate;
    }
}
