/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.video;

import android.os.Handler;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.twilio.video.AudioTrackPublication;
import com.twilio.video.DataTrackPublication;
import com.twilio.video.EncodingParameters;
import com.twilio.video.LocalAudioTrack;
import com.twilio.video.LocalAudioTrackPublication;
import com.twilio.video.LocalDataTrack;
import com.twilio.video.LocalDataTrackPublication;
import com.twilio.video.LocalTrackPublicationOptions;
import com.twilio.video.LocalVideoTrack;
import com.twilio.video.LocalVideoTrackPublication;
import com.twilio.video.Logger;
import com.twilio.video.NetworkQualityLevel;
import com.twilio.video.Participant;
import com.twilio.video.Preconditions;
import com.twilio.video.Track;
import com.twilio.video.TrackPriority;
import com.twilio.video.TrackPublication;
import com.twilio.video.TwilioException;
import com.twilio.video.VideoTrackPublication;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

public class LocalParticipant
implements Participant {
    private static final Logger logger = Logger.getLogger(LocalParticipant.class);
    private long nativeLocalParticipantHandle;
    private final String sid;
    private final String identity;
    private final String signalingRegion;
    private NetworkQualityLevel networkQualityLevel = NetworkQualityLevel.NETWORK_QUALITY_LEVEL_UNKNOWN;
    private final List<AudioTrackPublication> audioTrackPublications;
    private final List<LocalAudioTrackPublication> localAudioTrackPublications;
    private final List<VideoTrackPublication> videoTrackPublications;
    private final List<LocalVideoTrackPublication> localVideoTrackPublications;
    private final List<DataTrackPublication> dataTrackPublications;
    private final List<LocalDataTrackPublication> localDataTrackPublications;
    private final Handler handler;
    private final AtomicReference<Listener> listenerReference = new AtomicReference<Object>(null);
    final Listener localParticipantListenerProxy = new Listener(){

        @Override
        public void onAudioTrackPublished(@NonNull LocalParticipant localParticipant, @NonNull LocalAudioTrackPublication localAudioTrackPublication) {
            this.checkPublishedCallback(localParticipant, localAudioTrackPublication, "onAudioTrackPublished");
            LocalParticipant.this.handler.post(() -> {
                logger.d("onAudioTrackPublished");
                LocalParticipant.this.audioTrackPublications.add(localAudioTrackPublication);
                LocalParticipant.this.localAudioTrackPublications.add(localAudioTrackPublication);
                Listener listener = LocalParticipant.this.listenerReference.get();
                if (listener != null) {
                    listener.onAudioTrackPublished(localParticipant, localAudioTrackPublication);
                }
            });
        }

        @Override
        public void onAudioTrackPublicationFailed(@NonNull LocalParticipant localParticipant, @NonNull LocalAudioTrack localAudioTrack, @NonNull TwilioException twilioException) {
            this.checkPublicationFailedCallback(localParticipant, localAudioTrack, twilioException, "onAudioTrackPublicationFailed");
            LocalParticipant.this.handler.post(() -> {
                logger.d("onAudioTrackPublicationFailed");
                Listener listener = LocalParticipant.this.listenerReference.get();
                if (listener != null) {
                    listener.onAudioTrackPublicationFailed(localParticipant, localAudioTrack, twilioException);
                }
            });
        }

        @Override
        public void onVideoTrackPublished(@NonNull LocalParticipant localParticipant, @NonNull LocalVideoTrackPublication localVideoTrackPublication) {
            this.checkPublishedCallback(localParticipant, localVideoTrackPublication, "onVideoTrackPublished");
            LocalParticipant.this.handler.post(() -> {
                logger.d("onAudioTrackPublished");
                LocalParticipant.this.videoTrackPublications.add(localVideoTrackPublication);
                LocalParticipant.this.localVideoTrackPublications.add(localVideoTrackPublication);
                Listener listener = LocalParticipant.this.listenerReference.get();
                if (listener != null) {
                    listener.onVideoTrackPublished(localParticipant, localVideoTrackPublication);
                }
            });
        }

        @Override
        public void onVideoTrackPublicationFailed(@NonNull LocalParticipant localParticipant, @NonNull LocalVideoTrack localVideoTrack, @NonNull TwilioException twilioException) {
            this.checkPublicationFailedCallback(localParticipant, localVideoTrack, twilioException, "onVideoTrackPublicationFailed");
            LocalParticipant.this.handler.post(() -> {
                logger.d("onVideoTrackPublicationFailed");
                Listener listener = LocalParticipant.this.listenerReference.get();
                if (listener != null) {
                    listener.onVideoTrackPublicationFailed(localParticipant, localVideoTrack, twilioException);
                }
            });
        }

        @Override
        public void onDataTrackPublished(@NonNull LocalParticipant localParticipant, @NonNull LocalDataTrackPublication localDataTrackPublication) {
            this.checkPublishedCallback(localParticipant, localDataTrackPublication, "onDataTrackPublished");
            LocalParticipant.this.handler.post(() -> {
                logger.d("onDataTrackPublished");
                LocalParticipant.this.dataTrackPublications.add(localDataTrackPublication);
                LocalParticipant.this.localDataTrackPublications.add(localDataTrackPublication);
                Listener listener = LocalParticipant.this.listenerReference.get();
                if (listener != null) {
                    listener.onDataTrackPublished(localParticipant, localDataTrackPublication);
                }
            });
        }

        @Override
        public void onDataTrackPublicationFailed(@NonNull LocalParticipant localParticipant, @NonNull LocalDataTrack localDataTrack, @NonNull TwilioException twilioException) {
            this.checkPublicationFailedCallback(localParticipant, localDataTrack, twilioException, "onDataTrackPublicationFailed");
            LocalParticipant.this.handler.post(() -> {
                logger.d("onDataTrackPublicationFailed");
                Listener listener = LocalParticipant.this.listenerReference.get();
                if (listener != null) {
                    listener.onDataTrackPublicationFailed(localParticipant, localDataTrack, twilioException);
                }
            });
        }

        @Override
        public void onNetworkQualityLevelChanged(@NonNull LocalParticipant localParticipant, @NonNull NetworkQualityLevel networkQualityLevel) {
            LocalParticipant.this.handler.post(() -> {
                logger.d("onNetworkQualityLevelChanged");
                Listener listener = LocalParticipant.this.listenerReference.get();
                localParticipant.networkQualityLevel = networkQualityLevel;
                if (listener != null) {
                    listener.onNetworkQualityLevelChanged(localParticipant, networkQualityLevel);
                }
            });
        }

        private void checkPublishedCallback(LocalParticipant localParticipant, TrackPublication trackPublication, String callback) {
            Preconditions.checkState(localParticipant != null, "Received null local participant in %s", (Object)callback);
            Preconditions.checkState(trackPublication != null, "Received null track publication in %s", (Object)callback);
        }

        private void checkPublicationFailedCallback(LocalParticipant localParticipant, Track track, TwilioException twilioException, String callback) {
            Preconditions.checkState(localParticipant != null, "Received null local participant in %s", (Object)callback);
            Preconditions.checkState(track != null, "Received null track in %s", (Object)callback);
            Preconditions.checkState(twilioException != null, "Received null exception in %s", (Object)callback);
        }
    };

    @Override
    @NonNull
    public String getSid() {
        return this.sid;
    }

    @Override
    @NonNull
    public String getIdentity() {
        return this.identity;
    }

    @Override
    @NonNull
    public synchronized Participant.State getState() {
        if (this.isReleased()) {
            return Participant.State.DISCONNECTED;
        }
        return this.nativeGetState(this.nativeLocalParticipantHandle);
    }

    @Override
    @NonNull
    public NetworkQualityLevel getNetworkQualityLevel() {
        return this.networkQualityLevel;
    }

    @NonNull
    public String getSignalingRegion() {
        return this.signalingRegion;
    }

    @Override
    @NonNull
    public synchronized List<AudioTrackPublication> getAudioTracks() {
        return Collections.unmodifiableList(this.audioTrackPublications);
    }

    @Override
    @NonNull
    public synchronized List<VideoTrackPublication> getVideoTracks() {
        return Collections.unmodifiableList(this.videoTrackPublications);
    }

    @Override
    @NonNull
    public synchronized List<DataTrackPublication> getDataTracks() {
        return Collections.unmodifiableList(this.dataTrackPublications);
    }

    @NonNull
    public synchronized List<LocalAudioTrackPublication> getLocalAudioTracks() {
        return Collections.unmodifiableList(this.localAudioTrackPublications);
    }

    @NonNull
    public synchronized List<LocalVideoTrackPublication> getLocalVideoTracks() {
        return Collections.unmodifiableList(this.localVideoTrackPublications);
    }

    @NonNull
    public synchronized List<LocalDataTrackPublication> getLocalDataTracks() {
        return Collections.unmodifiableList(this.localDataTrackPublications);
    }

    public synchronized boolean publishTrack(@NonNull LocalAudioTrack localAudioTrack) {
        return this.publishTrack(localAudioTrack, new LocalTrackPublicationOptions(TrackPriority.STANDARD));
    }

    public synchronized boolean publishTrack(@NonNull LocalAudioTrack localAudioTrack, @NonNull LocalTrackPublicationOptions localTrackPublicationOptions) {
        Preconditions.checkNotNull(localAudioTrack, "LocalAudioTrack must not be null");
        Preconditions.checkNotNull(localTrackPublicationOptions, "LocalTrackPublicationOptions must not be null");
        Preconditions.checkArgument(!localAudioTrack.isReleased(), "LocalAudioTrack must not be released");
        return !this.isReleased() && this.nativePublishAudioTrack(this.nativeLocalParticipantHandle, localAudioTrack, localTrackPublicationOptions, localAudioTrack.getNativeHandle());
    }

    public synchronized boolean publishTrack(@NonNull LocalVideoTrack localVideoTrack) {
        return this.publishTrack(localVideoTrack, new LocalTrackPublicationOptions(TrackPriority.STANDARD));
    }

    public synchronized boolean publishTrack(@NonNull LocalVideoTrack localVideoTrack, @NonNull LocalTrackPublicationOptions localTrackPublicationOptions) {
        Preconditions.checkNotNull(localVideoTrack, "LocalVideoTrack must not be null");
        Preconditions.checkNotNull(localTrackPublicationOptions, "LocalTrackPublicationOptions must not be null");
        Preconditions.checkArgument(!localVideoTrack.isReleased(), "LocalVideoTrack must not be released");
        return !this.isReleased() && this.nativePublishVideoTrack(this.nativeLocalParticipantHandle, localVideoTrack, localTrackPublicationOptions, localVideoTrack.getNativeHandle());
    }

    public synchronized boolean publishTrack(@NonNull LocalDataTrack localDataTrack) {
        return this.publishTrack(localDataTrack, new LocalTrackPublicationOptions(TrackPriority.STANDARD));
    }

    public synchronized boolean publishTrack(@NonNull LocalDataTrack localDataTrack, @NonNull LocalTrackPublicationOptions localTrackPublicationOptions) {
        Preconditions.checkNotNull(localDataTrack, "LocalDataTrack must not be null");
        Preconditions.checkNotNull(localTrackPublicationOptions, "LocalTrackPublicationOptions must not be null");
        Preconditions.checkArgument(!localDataTrack.isReleased(), "LocalDataTrack must not be released");
        return !this.isReleased() && this.nativePublishDataTrack(this.nativeLocalParticipantHandle, localDataTrack, localTrackPublicationOptions, localDataTrack.getNativeHandle());
    }

    public synchronized boolean unpublishTrack(@NonNull LocalAudioTrack localAudioTrack) {
        Preconditions.checkNotNull(localAudioTrack, "LocalAudioTrack must not be null");
        Preconditions.checkArgument(!localAudioTrack.isReleased(), "LocalAudioTrack must not be released");
        if (this.isReleased()) {
            return false;
        }
        this.removePublishedAudioTrack(localAudioTrack);
        return this.nativeUnpublishAudioTrack(this.nativeLocalParticipantHandle, localAudioTrack.getNativeHandle());
    }

    public synchronized boolean unpublishTrack(@NonNull LocalVideoTrack localVideoTrack) {
        Preconditions.checkNotNull(localVideoTrack, "LocalVideoTrack must not be null");
        Preconditions.checkArgument(!localVideoTrack.isReleased(), "LocalVideoTrack must not be released");
        if (this.isReleased()) {
            return false;
        }
        this.removePublishedVideoTrack(localVideoTrack);
        return this.nativeUnpublishVideoTrack(this.nativeLocalParticipantHandle, localVideoTrack.getNativeHandle());
    }

    public synchronized boolean unpublishTrack(@NonNull LocalDataTrack localDataTrack) {
        Preconditions.checkNotNull(localDataTrack, "LocalDataTrack must not be null");
        Preconditions.checkArgument(!localDataTrack.isReleased(), "LocalDataTrack must not be released");
        if (this.isReleased()) {
            return false;
        }
        this.removePublishedDataTrack(localDataTrack);
        return this.nativeUnpublishDataTrack(this.nativeLocalParticipantHandle, localDataTrack.getNativeHandle());
    }

    public void setListener(@NonNull Listener listener) {
        Preconditions.checkNotNull(listener, "Listener must not be null");
        this.listenerReference.set(listener);
    }

    public synchronized void setEncodingParameters(@Nullable EncodingParameters encodingParameters) {
        if (!this.isReleased()) {
            this.nativeSetEncodingParameters(this.nativeLocalParticipantHandle, encodingParameters);
        } else {
            logger.w("Cannot set encoding parameters after disconnected from a room");
        }
    }

    LocalParticipant(long nativeLocalParticipantHandle, @NonNull String sid, @NonNull String identity, @NonNull String signalingRegion, @NonNull List<LocalAudioTrackPublication> localAudioTrackPublications, @NonNull List<LocalVideoTrackPublication> localVideoTrackPublications, @NonNull List<LocalDataTrackPublication> localDataTrackPublications, @NonNull Handler handler) {
        Preconditions.checkNotNull(sid, "SID must not be null");
        Preconditions.checkArgument(!sid.isEmpty(), "SID must not be empty");
        Preconditions.checkNotNull(identity, "Identity must not be null");
        Preconditions.checkNotNull(signalingRegion, "Signaling region must not be null");
        this.nativeLocalParticipantHandle = nativeLocalParticipantHandle;
        this.sid = sid;
        this.identity = identity;
        this.signalingRegion = signalingRegion;
        this.localAudioTrackPublications = localAudioTrackPublications;
        this.audioTrackPublications = new ArrayList<AudioTrackPublication>(localAudioTrackPublications.size());
        this.addAudioTracks(localAudioTrackPublications);
        this.localVideoTrackPublications = localVideoTrackPublications;
        this.videoTrackPublications = new ArrayList<VideoTrackPublication>(localVideoTrackPublications.size());
        this.addVideoTracks(localVideoTrackPublications);
        this.localDataTrackPublications = localDataTrackPublications;
        this.dataTrackPublications = new ArrayList<DataTrackPublication>(localDataTrackPublications.size());
        this.addDataTracks(localDataTrackPublications);
        this.handler = handler;
    }

    synchronized void release() {
        if (!this.isReleased()) {
            for (LocalAudioTrackPublication localAudioTrackPublication : this.localAudioTrackPublications) {
                localAudioTrackPublication.release();
            }
            for (LocalDataTrackPublication localDataTrackPublication : this.localDataTrackPublications) {
                localDataTrackPublication.release();
            }
            for (LocalVideoTrackPublication localVideoTrackPublication : this.localVideoTrackPublications) {
                localVideoTrackPublication.release();
            }
            this.nativeRelease(this.nativeLocalParticipantHandle);
            this.nativeLocalParticipantHandle = 0L;
        }
    }

    boolean isReleased() {
        return this.nativeLocalParticipantHandle == 0L;
    }

    private void addAudioTracks(List<LocalAudioTrackPublication> localAudioTrackPublications) {
        this.audioTrackPublications.addAll(localAudioTrackPublications);
    }

    private void addVideoTracks(List<LocalVideoTrackPublication> localVideoTrackPublications) {
        this.videoTrackPublications.addAll(localVideoTrackPublications);
    }

    private void addDataTracks(List<LocalDataTrackPublication> localDataTrackPublications) {
        this.dataTrackPublications.addAll(localDataTrackPublications);
    }

    private void removePublishedAudioTrack(LocalAudioTrack localAudioTrack) {
        for (LocalAudioTrackPublication localAudioTrackPublication : this.localAudioTrackPublications) {
            if (!localAudioTrack.equals(localAudioTrackPublication.getLocalAudioTrack())) continue;
            this.audioTrackPublications.remove(localAudioTrackPublication);
            this.localAudioTrackPublications.remove(localAudioTrackPublication);
            localAudioTrackPublication.release();
            return;
        }
    }

    private void removePublishedVideoTrack(LocalVideoTrack localVideoTrack) {
        for (LocalVideoTrackPublication localVideoTrackPublication : this.localVideoTrackPublications) {
            if (!localVideoTrack.equals(localVideoTrackPublication.getLocalVideoTrack())) continue;
            this.videoTrackPublications.remove(localVideoTrackPublication);
            this.localVideoTrackPublications.remove(localVideoTrackPublication);
            localVideoTrackPublication.release();
            return;
        }
    }

    private void removePublishedDataTrack(LocalDataTrack localDataTrack) {
        for (LocalDataTrackPublication localDataTrackPublication : this.localDataTrackPublications) {
            if (!localDataTrack.equals(localDataTrackPublication.getLocalDataTrack())) continue;
            this.dataTrackPublications.remove(localDataTrackPublication);
            this.localDataTrackPublications.remove(localDataTrackPublication);
            localDataTrackPublication.release();
            return;
        }
    }

    private native Participant.State nativeGetState(long var1);

    private native boolean nativePublishAudioTrack(long var1, LocalAudioTrack var3, LocalTrackPublicationOptions var4, long var5);

    private native boolean nativePublishVideoTrack(long var1, LocalVideoTrack var3, LocalTrackPublicationOptions var4, long var5);

    private native boolean nativePublishDataTrack(long var1, LocalDataTrack var3, LocalTrackPublicationOptions var4, long var5);

    private native boolean nativeUnpublishAudioTrack(long var1, long var3);

    private native boolean nativeUnpublishVideoTrack(long var1, long var3);

    private native boolean nativeUnpublishDataTrack(long var1, long var3);

    private native void nativeSetEncodingParameters(long var1, EncodingParameters var3);

    private native void nativeRelease(long var1);

    public static interface Listener {
        public void onAudioTrackPublished(@NonNull LocalParticipant var1, @NonNull LocalAudioTrackPublication var2);

        public void onAudioTrackPublicationFailed(@NonNull LocalParticipant var1, @NonNull LocalAudioTrack var2, @NonNull TwilioException var3);

        public void onVideoTrackPublished(@NonNull LocalParticipant var1, @NonNull LocalVideoTrackPublication var2);

        public void onVideoTrackPublicationFailed(@NonNull LocalParticipant var1, @NonNull LocalVideoTrack var2, @NonNull TwilioException var3);

        public void onDataTrackPublished(@NonNull LocalParticipant var1, @NonNull LocalDataTrackPublication var2);

        public void onDataTrackPublicationFailed(@NonNull LocalParticipant var1, @NonNull LocalDataTrack var2, @NonNull TwilioException var3);

        default public void onNetworkQualityLevelChanged(@NonNull LocalParticipant localParticipant, @NonNull NetworkQualityLevel networkQualityLevel) {
        }
    }
}

