/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.video;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.twilio.video.BandwidthProfileMode;
import com.twilio.video.ClientTrackSwitchOffControl;
import com.twilio.video.Preconditions;
import com.twilio.video.TrackPriority;
import com.twilio.video.TrackSwitchOffMode;
import com.twilio.video.Util;
import com.twilio.video.VideoContentPreferencesMode;
import com.twilio.video.VideoDimensions;
import java.util.Collections;
import java.util.Map;

public class VideoBandwidthProfileOptions {
    private static final String CLIENT_TRACK_SWITCH_OFF_CONTROL_ERROR = "Cannot set both clientTrackSwitchOffControl and maxTracks.";
    @Nullable
    private final TrackPriority dominantSpeakerPriority;
    @Nullable
    private final Long maxSubscriptionBitrate;
    @Nullable
    private final Long maxTracks;
    @Nullable
    private final BandwidthProfileMode mode;
    @NonNull
    private final Map<TrackPriority, VideoDimensions> renderDimensions;
    @Nullable
    private final TrackSwitchOffMode trackSwitchOffMode;
    @Nullable
    private final ClientTrackSwitchOffControl clientTrackSwitchOffControl;
    @Nullable
    private VideoContentPreferencesMode videoContentPreferencesMode;

    @Nullable
    public TrackPriority getDominantSpeakerPriority() {
        return this.dominantSpeakerPriority;
    }

    @Nullable
    public Long getMaxSubscriptionBitrate() {
        return this.maxSubscriptionBitrate;
    }

    @Nullable
    public Long getMaxTracks() {
        return this.maxTracks;
    }

    @Nullable
    public BandwidthProfileMode getMode() {
        return this.mode;
    }

    @NonNull
    public Map<TrackPriority, VideoDimensions> getRenderDimensions() {
        return this.renderDimensions;
    }

    @Nullable
    public TrackSwitchOffMode getTrackSwitchOffMode() {
        return this.trackSwitchOffMode;
    }

    @Nullable
    public ClientTrackSwitchOffControl getClientTrackSwitchOffControl() {
        return this.clientTrackSwitchOffControl;
    }

    @Nullable
    public VideoContentPreferencesMode getVideoContentPreferencesMode() {
        return this.videoContentPreferencesMode;
    }

    private VideoBandwidthProfileOptions(Builder builder) {
        this.dominantSpeakerPriority = builder.dominantSpeakerPriority;
        this.maxSubscriptionBitrate = builder.maxSubscriptionBitrate;
        this.maxTracks = builder.maxTracks;
        this.mode = builder.mode;
        this.renderDimensions = builder.renderDimensions;
        this.trackSwitchOffMode = builder.trackSwitchOffMode;
        this.clientTrackSwitchOffControl = builder.clientTrackSwitchOffControl;
        this.videoContentPreferencesMode = builder.videoContentPreferencesMode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VideoBandwidthProfileOptions that = (VideoBandwidthProfileOptions)o;
        if (this.dominantSpeakerPriority != that.dominantSpeakerPriority) {
            return false;
        }
        if (!Util.equals(this.maxSubscriptionBitrate, that.maxSubscriptionBitrate)) {
            return false;
        }
        if (!Util.equals(this.maxTracks, that.maxTracks)) {
            return false;
        }
        if (this.mode != that.mode) {
            return false;
        }
        if (!this.renderDimensions.equals(that.renderDimensions)) {
            return false;
        }
        return this.trackSwitchOffMode == that.trackSwitchOffMode;
    }

    public int hashCode() {
        int result = this.dominantSpeakerPriority != null ? this.dominantSpeakerPriority.hashCode() : 0;
        result = 31 * result + (this.maxSubscriptionBitrate != null ? this.maxSubscriptionBitrate.hashCode() : 0);
        result = 31 * result + (this.maxTracks != null ? this.maxTracks.hashCode() : 0);
        result = 31 * result + (this.mode != null ? this.mode.hashCode() : 0);
        result = 31 * result + this.renderDimensions.hashCode();
        result = 31 * result + (this.trackSwitchOffMode != null ? this.trackSwitchOffMode.hashCode() : 0);
        return result;
    }

    public static class Builder {
        @Nullable
        private TrackPriority dominantSpeakerPriority;
        @Nullable
        private Long maxSubscriptionBitrate = 2400L;
        @Nullable
        private Long maxTracks;
        @Nullable
        private BandwidthProfileMode mode;
        private Map<TrackPriority, VideoDimensions> renderDimensions = Collections.emptyMap();
        @Nullable
        private TrackSwitchOffMode trackSwitchOffMode;
        @Nullable
        private ClientTrackSwitchOffControl clientTrackSwitchOffControl;
        @Nullable
        private VideoContentPreferencesMode videoContentPreferencesMode;

        public Builder dominantSpeakerPriority(@Nullable TrackPriority priority) {
            this.dominantSpeakerPriority = priority;
            return this;
        }

        public Builder maxSubscriptionBitrate(@Nullable Long maxSubscriptionBitrate) {
            this.maxSubscriptionBitrate = maxSubscriptionBitrate;
            return this;
        }

        @Deprecated
        public Builder maxTracks(@Nullable Long maxTracks) {
            this.maxTracks = maxTracks;
            return this;
        }

        public Builder mode(@Nullable BandwidthProfileMode mode) {
            this.mode = mode;
            return this;
        }

        public Builder renderDimensions(@NonNull Map<TrackPriority, VideoDimensions> dimensions) {
            Preconditions.checkNotNull(dimensions, "render dimensions must not be null");
            Preconditions.checkArgument(!dimensions.containsKey(null), "render dimensions cannot contain a null track priority key");
            Preconditions.checkArgument(!dimensions.containsValue(null), "render dimensions cannot contain a null video dimensions value");
            this.renderDimensions = dimensions;
            return this;
        }

        public Builder trackSwitchOffMode(@Nullable TrackSwitchOffMode mode) {
            this.trackSwitchOffMode = mode;
            return this;
        }

        public Builder clientTrackSwitchOffControl(@Nullable ClientTrackSwitchOffControl control) {
            this.clientTrackSwitchOffControl = control;
            return this;
        }

        public Builder videoContentPreferencesMode(@Nullable VideoContentPreferencesMode mode) {
            this.videoContentPreferencesMode = mode;
            return this;
        }

        public VideoBandwidthProfileOptions build() {
            Preconditions.checkArgument(this.videoContentPreferencesMode == null || this.renderDimensions.isEmpty());
            Preconditions.checkArgument(this.clientTrackSwitchOffControl == null || this.maxTracks == null, VideoBandwidthProfileOptions.CLIENT_TRACK_SWITCH_OFF_CONTROL_ERROR);
            return new VideoBandwidthProfileOptions(this);
        }
    }
}

