/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.video;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import android.media.projection.MediaProjection;
import android.os.Build;
import android.os.Handler;
import android.util.DisplayMetrics;
import android.view.WindowManager;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.twilio.video.Logger;
import com.twilio.video.Preconditions;
import com.twilio.video.Util;
import com.twilio.video.VideoCapturer;
import com.twilio.video.VideoDimensions;
import com.twilio.video.VideoFormat;
import tvi.webrtc.CapturerObserver;
import tvi.webrtc.ScreenCapturerAndroid;
import tvi.webrtc.SurfaceTextureHelper;
import tvi.webrtc.VideoFrame;

@TargetApi(value=21)
public class ScreenCapturer
implements VideoCapturer {
    private static final Logger logger = Logger.getLogger(ScreenCapturer.class);
    private static final int SCREENCAPTURE_FRAME_RATE = 30;
    private boolean firstFrameReported;
    private int orientation;
    private final Context context;
    private final Intent screenCaptureIntentData;
    private final Listener screenCapturerListener;
    private final int screenCaptureIntentResult;
    private final Handler listenerHandler;
    private CapturerObserver capturerObserver;
    private ScreenCapturerAndroid webRtcScreenCapturer;
    private VideoDimensions videoDimensions;
    private final MediaProjection.Callback mediaProjectionCallback = new MediaProjection.Callback(){

        public void onStop() {
            super.onStop();
            logger.d("media projection stopped");
        }
    };
    private final CapturerObserver observerAdapter = new CapturerObserver(){

        public void onCapturerStarted(boolean success) {
            logger.d("screen capturer started");
            if (!success && ScreenCapturer.this.screenCapturerListener != null) {
                ScreenCapturer.this.listenerHandler.post(() -> ScreenCapturer.this.screenCapturerListener.onScreenCaptureError("Failed to start screen capturer"));
            }
            ScreenCapturer.this.capturerObserver.onCapturerStarted(success);
        }

        public void onCapturerStopped() {
            logger.d("screen capturer stopped");
        }

        public void onFrameCaptured(VideoFrame videoFrame) {
            if (!ScreenCapturer.this.firstFrameReported) {
                if (ScreenCapturer.this.screenCapturerListener != null) {
                    ScreenCapturer.this.listenerHandler.post(ScreenCapturer.this.screenCapturerListener::onFirstFrameAvailable);
                }
                ScreenCapturer.this.firstFrameReported = true;
            }
            VideoFrame.Buffer buffer = videoFrame.getBuffer();
            ScreenCapturer.this.videoDimensions = new VideoDimensions(buffer.getWidth(), buffer.getHeight());
            int currentOrientation = ScreenCapturer.this.getDeviceOrientation();
            ScreenCapturer.this.capturerObserver.onFrameCaptured(videoFrame);
            if (ScreenCapturer.this.updateCaptureDimensions(ScreenCapturer.this.orientation, currentOrientation)) {
                logger.d("Swapping width and height of frame due to orientation");
                ScreenCapturer.this.orientation = currentOrientation;
                ScreenCapturer.this.webRtcScreenCapturer.changeCaptureFormat(buffer.getHeight(), buffer.getWidth(), 30);
            }
        }
    };

    public ScreenCapturer(@NonNull Context context, int screenCaptureIntentResult, @NonNull Intent screenCaptureIntentData, @Nullable Listener screenCapturerListener) {
        Preconditions.checkState(Build.VERSION.SDK_INT >= 21, "Screen capturing unavailable for " + Build.VERSION.SDK_INT);
        Preconditions.checkNotNull(context, "context must not be null");
        Preconditions.checkNotNull(screenCaptureIntentData, "intent must not be null");
        this.context = context;
        this.screenCaptureIntentData = screenCaptureIntentData;
        this.screenCaptureIntentResult = screenCaptureIntentResult;
        this.screenCapturerListener = screenCapturerListener;
        this.listenerHandler = Util.createCallbackHandler();
        this.orientation = this.getDeviceOrientation();
    }

    @Override
    public VideoFormat getCaptureFormat() {
        DisplayMetrics displayMetrics = new DisplayMetrics();
        WindowManager windowManager = (WindowManager)this.context.getSystemService("window");
        windowManager.getDefaultDisplay().getRealMetrics(displayMetrics);
        VideoDimensions screenDimensions = new VideoDimensions(displayMetrics.widthPixels, displayMetrics.heightPixels);
        return new VideoFormat(screenDimensions, 30);
    }

    public boolean isScreencast() {
        return true;
    }

    public void initialize(@NonNull SurfaceTextureHelper surfaceTextureHelper, @NonNull Context context, @NonNull CapturerObserver capturerObserver) {
        this.capturerObserver = capturerObserver;
        this.webRtcScreenCapturer = new ScreenCapturerAndroid(this.screenCaptureIntentData, this.mediaProjectionCallback);
        this.webRtcScreenCapturer.initialize(surfaceTextureHelper, context, this.observerAdapter);
    }

    public void startCapture(int width, int height, int framerate) {
        this.firstFrameReported = false;
        if (this.screenCaptureIntentResult != -1) {
            if (this.screenCapturerListener != null) {
                this.listenerHandler.post(() -> this.screenCapturerListener.onScreenCaptureError("MediaProjection permissions must be granted to start ScreenCapturer"));
            }
            this.observerAdapter.onCapturerStarted(false);
            return;
        }
        this.webRtcScreenCapturer.startCapture(width, height, framerate);
    }

    public void stopCapture() {
        logger.d("stopCapture");
        if (this.webRtcScreenCapturer != null) {
            this.webRtcScreenCapturer.stopCapture();
        }
        logger.d("stopCapture done");
    }

    @Override
    public void dispose() {
        if (this.webRtcScreenCapturer != null) {
            this.webRtcScreenCapturer.dispose();
            this.webRtcScreenCapturer = null;
        }
    }

    private int getDeviceOrientation() {
        int orientation = 0;
        WindowManager wm = (WindowManager)this.context.getSystemService("window");
        switch (wm.getDefaultDisplay().getRotation()) {
            case 1: {
                orientation = 90;
                break;
            }
            case 2: {
                orientation = 180;
                break;
            }
            case 3: {
                orientation = 270;
                break;
            }
        }
        return orientation;
    }

    private boolean updateCaptureDimensions(int currentOrientation, int orientation) {
        if (currentOrientation == orientation || Math.abs(currentOrientation - orientation) == 180) {
            logger.d("No orientation change detected");
            return false;
        }
        logger.d("Orientation change detected");
        return true;
    }

    @VisibleForTesting(otherwise=5)
    VideoDimensions getVideoDimensions() {
        return this.videoDimensions;
    }

    public static interface Listener {
        public void onScreenCaptureError(@NonNull String var1);

        public void onFirstFrameAvailable();
    }
}

