package com.twilio.video;

import androidx.annotation.NonNull;

public class RemoteVideoTrackStats extends RemoteTrackStats {
    /** Received frame dimensions */
    @NonNull public final VideoDimensions dimensions;

    /** Received frame rate */
    public final int frameRate;

    RemoteVideoTrackStats(
            @NonNull String trackSid,
            int packetsLost,
            @NonNull String codec,
            @NonNull String ssrc,
            double timestamp,
            long bytesReceived,
            int packetsReceived,
            @NonNull VideoDimensions dimensions,
            int frameRate) {
        super(trackSid, packetsLost, codec, ssrc, timestamp, bytesReceived, packetsReceived);
        this.dimensions = dimensions;
        this.frameRate = frameRate;
    }
}
