/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.video;

import android.content.Context;
import android.os.Handler;
import androidx.annotation.NonNull;
import com.twilio.video.AudioDevice;
import com.twilio.video.AudioDeviceContext;
import com.twilio.video.AudioFormat;
import com.twilio.video.Logger;
import com.twilio.video.ThreadChecker;
import com.twilio.video.Util;
import java.nio.ByteBuffer;

class AudioDeviceProxy
extends AudioDeviceContext
implements AudioDevice {
    private static final Logger logger = Logger.getLogger(AudioDeviceProxy.class);
    private static long nativeAudioDeviceProxyHandle;
    Handler handler;
    private AudioDevice audioDevice;
    private boolean released = false;
    private boolean capturingStopped = false;
    private boolean renderingStopped = false;

    private AudioDeviceProxy(Context context, long nativeAudioDeviceProxy, AudioDevice audioDevice) {
        nativeAudioDeviceProxyHandle = nativeAudioDeviceProxy;
        this.audioDevice = audioDevice;
    }

    public void writeCaptureData(ByteBuffer buffer) {
        if (!this.capturingStopped && !this.released) {
            AudioDeviceProxy.nativeWriteData(nativeAudioDeviceProxyHandle, buffer, buffer.capacity());
        } else {
            logger.d("Ignoring writeCaptureData because either AudioDeviceProxy is released or capturing stopped");
        }
    }

    public void readRenderData(ByteBuffer buffer) {
        if (!this.renderingStopped && !this.released) {
            AudioDeviceProxy.nativeReadData(nativeAudioDeviceProxyHandle, buffer, buffer.capacity());
        } else {
            logger.d("Ignoring readRenderData because either AudioDeviceProxy is released or rendering stopped");
        }
    }

    void release() {
        logger.d("release");
        if (!this.released) {
            if (nativeAudioDeviceProxyHandle != 0L) {
                AudioDeviceProxy.nativeRelease(nativeAudioDeviceProxyHandle);
                nativeAudioDeviceProxyHandle = 0L;
            }
            this.released = true;
        }
    }

    @Override
    public AudioFormat getCapturerFormat() {
        return null;
    }

    @Override
    public boolean onInitCapturer() {
        logger.d("onInitCapturer");
        this.checkIsOnValidThread();
        this.capturingStopped = false;
        if (!this.released) {
            this.audioDevice.onInitCapturer();
        }
        return true;
    }

    @Override
    public boolean onStartCapturing(@NonNull AudioDeviceContext audioDeviceContext) {
        logger.d("onStartCapturing");
        this.checkIsOnValidThread();
        if (!this.released) {
            this.audioDevice.onStartCapturing(this);
        }
        return true;
    }

    @Override
    public boolean onStopCapturing() {
        logger.d("onStopCapturing");
        this.checkIsOnValidThread();
        this.capturingStopped = true;
        if (!this.released) {
            this.audioDevice.onStopCapturing();
        }
        return true;
    }

    @Override
    public AudioFormat getRendererFormat() {
        return null;
    }

    @Override
    public boolean onInitRenderer() {
        logger.d("onInitRenderer");
        this.checkIsOnValidThread();
        this.renderingStopped = false;
        if (!this.released) {
            this.audioDevice.onInitRenderer();
        }
        return true;
    }

    @Override
    public boolean onStartRendering(@NonNull AudioDeviceContext audioDeviceContext) {
        logger.d("onStartRendering");
        this.checkIsOnValidThread();
        if (!this.released) {
            this.audioDevice.onStartRendering(this);
        }
        return true;
    }

    @Override
    public boolean onStopRendering() {
        logger.d("onStopRendering");
        this.checkIsOnValidThread();
        this.renderingStopped = true;
        if (!this.released) {
            this.audioDevice.onStopRendering();
        }
        return true;
    }

    void executeWorkerBlock(Runnable runnable) {
        if (this.isValid()) {
            AudioDeviceProxy.nativeExecuteWorkerBlock(nativeAudioDeviceProxyHandle, runnable);
        } else {
            logger.w("Calling executeWorkerBlock not a valid operation");
        }
    }

    void formatChanged() {
        logger.d("formatChanged");
        if (this.isValid()) {
            AudioDeviceProxy.nativeFormatChanged(nativeAudioDeviceProxyHandle, this.audioDevice.getCapturerFormat(), this.audioDevice.getRendererFormat());
        } else {
            logger.w("Calling formatChanged not a valid operation");
        }
    }

    private void checkIsOnValidThread() {
        if (this.handler == null) {
            this.handler = Util.createCallbackHandler();
        }
        ThreadChecker.checkIsValidThread(this.handler);
    }

    private boolean isValid() {
        return !this.renderingStopped && !this.released || !this.capturingStopped && !this.released;
    }

    private static native void nativeRelease(long var0);

    private static native void nativeWriteData(long var0, ByteBuffer var2, int var3);

    private static native void nativeReadData(long var0, ByteBuffer var2, int var3);

    private static native void nativeExecuteWorkerBlock(long var0, Runnable var2);

    private static native void nativeFormatChanged(long var0, AudioFormat var2, AudioFormat var3);
}

