/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.video;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.twilio.video.TrackPriority;
import com.twilio.video.VideoTrack;

public class RemoteVideoTrack
extends VideoTrack {
    private final String sid;
    private boolean isSwitchedOff;
    @Nullable
    private TrackPriority priority;
    private long nativeRemoteVideoTrackContext;

    RemoteVideoTrack(@NonNull tvi.webrtc.VideoTrack webRtcVideoTrack, @NonNull String sid, @NonNull String name, boolean enabled, boolean isSwitchedOff, @Nullable TrackPriority priority, long nativeRemoteVideoTrackContext) {
        super(webRtcVideoTrack, enabled, name);
        this.sid = sid;
        this.isSwitchedOff = isSwitchedOff;
        this.priority = priority;
        this.nativeRemoteVideoTrackContext = nativeRemoteVideoTrackContext;
    }

    @NonNull
    public String getSid() {
        return this.sid;
    }

    public boolean isSwitchedOff() {
        return this.isSwitchedOff;
    }

    @Nullable
    public TrackPriority getPriority() {
        return this.priority;
    }

    public void setPriority(@Nullable TrackPriority priority) {
        this.priority = priority;
        if (!this.isReleased()) {
            this.nativeSetPriority(this.nativeRemoteVideoTrackContext, priority);
        }
    }

    void setSwitchedOff(boolean isSwitchedOff) {
        this.isSwitchedOff = isSwitchedOff;
    }

    @Override
    synchronized void release() {
        if (!this.isReleased()) {
            super.release();
            this.nativeRelease(this.nativeRemoteVideoTrackContext);
            this.nativeRemoteVideoTrackContext = 0L;
        }
    }

    @Override
    synchronized boolean isReleased() {
        return this.nativeRemoteVideoTrackContext == 0L && super.isReleased();
    }

    private native void nativeSetPriority(long var1, TrackPriority var3);

    private native void nativeRelease(long var1);
}

