package com.twilio.video;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * An annotation used by the SDK to indicate what classes, constructors, methods, and fields are
 * accessed by native code. This annotation can be used to construct more fine tuned proguard rules.
 */
@Target({ElementType.CONSTRUCTOR, ElementType.METHOD, ElementType.FIELD, ElementType.TYPE})
@Retention(RetentionPolicy.CLASS)
public @interface AccessedByNative {}
