/*
 * Decompiled with CFR 0.152.
 */
package tvi.webrtc;

import android.support.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import tvi.webrtc.LibvpxVp8Encoder;
import tvi.webrtc.LibvpxVp9Encoder;
import tvi.webrtc.VideoCodecInfo;
import tvi.webrtc.VideoEncoder;
import tvi.webrtc.VideoEncoderFactory;

public class SoftwareVideoEncoderFactory
implements VideoEncoderFactory {
    @Override
    @Nullable
    public VideoEncoder createEncoder(VideoCodecInfo info) {
        if (info.name.equalsIgnoreCase("VP8")) {
            return new LibvpxVp8Encoder();
        }
        if (info.name.equalsIgnoreCase("VP9") && LibvpxVp9Encoder.nativeIsSupported()) {
            return new LibvpxVp9Encoder();
        }
        return null;
    }

    @Override
    public VideoCodecInfo[] getSupportedCodecs() {
        return SoftwareVideoEncoderFactory.supportedCodecs();
    }

    static VideoCodecInfo[] supportedCodecs() {
        ArrayList<VideoCodecInfo> codecs = new ArrayList<VideoCodecInfo>();
        codecs.add(new VideoCodecInfo("VP8", new HashMap<String, String>()));
        if (LibvpxVp9Encoder.nativeIsSupported()) {
            codecs.add(new VideoCodecInfo("VP9", new HashMap<String, String>()));
        }
        return codecs.toArray(new VideoCodecInfo[codecs.size()]);
    }
}

