package com.twilio.video;

import java.nio.ByteBuffer;
import tvi.webrtc.JavaI420Buffer;
import tvi.webrtc.VideoFrame;

// TODO(GSDK-2189) Document this class if the SDK ends up using pure WebRTC classes and APIs as
// part of the new capturing and rendering pipeline.
public class Rgba8888Buffer implements VideoFrame.Buffer {

    private final ByteBuffer data;
    private final int width;
    private final int height;

    public Rgba8888Buffer(ByteBuffer data, int width, int height) {
        this.data = data;
        this.width = width;
        this.height = height;
    }

    @Override
    public int getWidth() {
        return width;
    }

    @Override
    public int getHeight() {
        return height;
    }

    @Override
    public VideoFrame.I420Buffer toI420() {
        return (VideoFrame.I420Buffer) cropAndScale(0, 0, width, height, width, height);
    }

    @Override
    public void retain() {}

    @Override
    public void release() {}

    @Override
    public VideoFrame.Buffer cropAndScale(
            int cropX, int cropY, int cropWidth, int cropHeight, int scaleWidth, int scaleHeight) {
        JavaI420Buffer newBuffer = JavaI420Buffer.allocate(scaleWidth, scaleHeight);
        nativeCropAndScale(
                cropX,
                cropY,
                cropWidth,
                cropHeight,
                scaleWidth,
                scaleHeight,
                this.data.array(),
                this.width,
                this.height,
                newBuffer.getDataY(),
                newBuffer.getStrideY(),
                newBuffer.getDataU(),
                newBuffer.getStrideU(),
                newBuffer.getDataV(),
                newBuffer.getStrideV());
        return newBuffer;
    }

    private static native void nativeCropAndScale(
            int cropX,
            int cropY,
            int cropWidth,
            int cropHeight,
            int scaleWidth,
            int scaleHeight,
            byte[] src,
            int srcWidth,
            int srcHeight,
            ByteBuffer dstY,
            int dstStrideY,
            ByteBuffer dstU,
            int dstStrideU,
            ByteBuffer dstV,
            int dstStrideV);
}
