/*
 * Copyright (C) 2020 Twilio, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.twilio.video;

/**
 * TrackSwitchOffMode represents the possible modes of behavior of the Track switch-off mechanism.
 */
public enum TrackSwitchOffMode {
    /** In this mode, Tracks are never switched off. */
    DISABLED,

    /**
     * In this mode, Tracks are pro-actively switched off when network congestion is predicted by
     * the bandwidth estimation mechanism.
     */
    PREDICTED,

    /** In this mode, Tracks are switched off only when network congestion is detected. */
    DETECTED
}
