/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.video;

import android.support.annotation.NonNull;
import com.twilio.video.LocalVideoTrack;
import com.twilio.video.Preconditions;
import com.twilio.video.TrackPriority;
import com.twilio.video.VideoTrack;
import com.twilio.video.VideoTrackPublication;

public class LocalVideoTrackPublication
implements VideoTrackPublication {
    private final String sid;
    private final LocalVideoTrack localVideoTrack;
    private TrackPriority priority;
    private long nativeLocalVideoTrackPublicationContext;

    LocalVideoTrackPublication(@NonNull String sid, @NonNull LocalVideoTrack localVideoTrack, @NonNull TrackPriority priority, long nativeLocalVideoTrackPublicationContext) {
        Preconditions.checkNotNull(sid, "SID must not be null");
        Preconditions.checkArgument(!sid.isEmpty(), "SID must not be empty");
        Preconditions.checkNotNull(localVideoTrack, "Local video track must not be null");
        Preconditions.checkNotNull(priority, "priority should not be null");
        this.sid = sid;
        this.localVideoTrack = localVideoTrack;
        this.priority = priority;
        this.nativeLocalVideoTrackPublicationContext = nativeLocalVideoTrackPublicationContext;
    }

    @Override
    @NonNull
    public String getTrackSid() {
        return this.sid;
    }

    @Override
    @NonNull
    public String getTrackName() {
        return this.localVideoTrack.getName();
    }

    @Override
    public boolean isTrackEnabled() {
        return this.localVideoTrack.isEnabled();
    }

    @Override
    @NonNull
    public VideoTrack getVideoTrack() {
        return this.localVideoTrack;
    }

    @NonNull
    public LocalVideoTrack getLocalVideoTrack() {
        return this.localVideoTrack;
    }

    @NonNull
    public TrackPriority getPriority() {
        return this.priority;
    }

    public void setPriority(TrackPriority priority) {
        this.priority = priority;
        if (!this.isReleased()) {
            this.nativeSetPriority(this.nativeLocalVideoTrackPublicationContext, priority);
        }
    }

    synchronized void release() {
        if (!this.isReleased()) {
            this.nativeRelease(this.nativeLocalVideoTrackPublicationContext);
            this.nativeLocalVideoTrackPublicationContext = 0L;
        }
    }

    synchronized boolean isReleased() {
        return this.nativeLocalVideoTrackPublicationContext == 0L;
    }

    private native void nativeSetPriority(long var1, TrackPriority var3);

    private native void nativeRelease(long var1);
}

