/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.video;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.getkeepsafe.relinker.ReLinker;
import com.twilio.video.ConnectOptions;
import com.twilio.video.LogLevel;
import com.twilio.video.LogModule;
import com.twilio.video.Logger;
import com.twilio.video.PlatformInfo;
import com.twilio.video.Preconditions;
import com.twilio.video.RemoteParticipant;
import com.twilio.video.Room;
import com.twilio.video.TwilioException;
import com.twilio.video.Util;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class Video {
    private static LogLevel level = LogLevel.OFF;
    private static Map<LogModule, LogLevel> moduleLogLevel = new EnumMap<LogModule, LogLevel>(LogModule.class);
    private static volatile boolean libraryIsLoaded = false;
    private static final Logger logger = Logger.getLogger(Video.class);
    private static final Set<Room> rooms = new HashSet<Room>();
    private static NetworkInfo currentNetworkInfo = null;
    private static Context applicationContext = null;
    private static final BroadcastReceiver connectivityChangeReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            if (intent.getAction().equalsIgnoreCase("android.net.conn.CONNECTIVITY_CHANGE")) {
                if (this.isInitialStickyBroadcast()) {
                    logger.d("Ignoring network event, sticky broadcast");
                    return;
                }
                ConnectivityManager conn = (ConnectivityManager)context.getSystemService("connectivity");
                NetworkInfo newNetworkInfo = conn.getActiveNetworkInfo();
                NetworkChangeEvent networkChangeEvent = NetworkChangeEvent.CONNECTION_CHANGED;
                if (newNetworkInfo != null && (currentNetworkInfo == null || currentNetworkInfo.getDetailedState() != newNetworkInfo.getDetailedState() || currentNetworkInfo.getType() != newNetworkInfo.getType() || currentNetworkInfo.getSubtype() != newNetworkInfo.getSubtype())) {
                    if (!newNetworkInfo.isConnectedOrConnecting()) {
                        networkChangeEvent = NetworkChangeEvent.CONNECTION_LOST;
                    }
                    logger.d("Network event detected: " + networkChangeEvent.name());
                    Video.onNetworkChange(networkChangeEvent);
                } else if (newNetworkInfo == null) {
                    networkChangeEvent = NetworkChangeEvent.CONNECTION_LOST;
                    logger.d("Network connection lost");
                    Video.onNetworkChange(networkChangeEvent);
                }
                currentNetworkInfo = newNetworkInfo;
            }
        }
    };

    @NonNull
    public static synchronized Room connect(@NonNull Context context, @NonNull ConnectOptions connectOptions, @NonNull Room.Listener roomListener) {
        Preconditions.checkNotNull(context, "context must not be null");
        Preconditions.checkNotNull(connectOptions, "connectOptions must not be null");
        Preconditions.checkNotNull(roomListener, "roomListener must not be null");
        if (applicationContext == null) {
            applicationContext = context.getApplicationContext();
        }
        if (!libraryIsLoaded) {
            ReLinker.loadLibrary((Context)applicationContext, (String)"twilio_video_android_so");
            libraryIsLoaded = true;
            Video.trySetCoreLogLevel(level.ordinal());
            for (LogModule module : moduleLogLevel.keySet()) {
                Video.trySetCoreModuleLogLevel(module.ordinal(), moduleLogLevel.get((Object)module).ordinal());
            }
        }
        if (rooms.isEmpty()) {
            ConnectivityManager conn = (ConnectivityManager)applicationContext.getSystemService("connectivity");
            currentNetworkInfo = conn.getActiveNetworkInfo();
            Video.registerConnectivityBroadcastReceiver();
        }
        Room room = new Room(applicationContext, connectOptions.getRoomName(), Util.createCallbackHandler(), Video.roomListenerProxy(roomListener));
        rooms.add(room);
        room.connect(connectOptions);
        return room;
    }

    static synchronized void release(Room room) {
        rooms.remove(room);
        if (rooms.isEmpty()) {
            Video.unregisterConnectivityBroadcastReceiver();
            PlatformInfo.release();
        }
    }

    private static synchronized void onNetworkChange(NetworkChangeEvent networkChangeEvent) {
        for (Room room : rooms) {
            room.onNetworkChanged(networkChangeEvent);
        }
    }

    private static Room.Listener roomListenerProxy(final Room.Listener roomListener) {
        return new Room.Listener(){

            @Override
            public void onConnected(@NonNull Room room) {
                roomListener.onConnected(room);
            }

            @Override
            public void onConnectFailure(@NonNull Room room, @NonNull TwilioException twilioException) {
                roomListener.onConnectFailure(room, twilioException);
                Video.release(room);
            }

            @Override
            public void onReconnecting(@NonNull Room room, @NonNull TwilioException twilioException) {
                roomListener.onReconnecting(room, twilioException);
            }

            @Override
            public void onReconnected(@NonNull Room room) {
                roomListener.onReconnected(room);
            }

            @Override
            public void onDisconnected(@NonNull Room room, @Nullable TwilioException twilioException) {
                roomListener.onDisconnected(room, twilioException);
                Video.release(room);
            }

            @Override
            public void onParticipantConnected(@NonNull Room room, @NonNull RemoteParticipant remoteParticipant) {
                roomListener.onParticipantConnected(room, remoteParticipant);
            }

            @Override
            public void onParticipantDisconnected(@NonNull Room room, @NonNull RemoteParticipant remoteParticipant) {
                roomListener.onParticipantDisconnected(room, remoteParticipant);
            }

            @Override
            public void onDominantSpeakerChanged(@NonNull Room room, @Nullable RemoteParticipant remoteParticipant) {
                roomListener.onDominantSpeakerChanged(room, remoteParticipant);
            }

            @Override
            public void onRecordingStarted(@NonNull Room room) {
                roomListener.onRecordingStarted(room);
            }

            @Override
            public void onRecordingStopped(@NonNull Room room) {
                roomListener.onRecordingStopped(room);
            }
        };
    }

    @NonNull
    public static String getVersion() {
        return "5.7.0";
    }

    @NonNull
    public static LogLevel getLogLevel() {
        return LogLevel.values()[Video.tryGetCoreLogLevel()];
    }

    public static void setLogLevel(@NonNull LogLevel level) {
        Preconditions.checkNotNull(level, "LogLevel should not be null");
        Video.setSDKLogLevel(level);
        Video.trySetCoreLogLevel(level.ordinal());
        Video.level = level;
    }

    public static void setModuleLogLevel(@NonNull LogModule module, @NonNull LogLevel level) {
        Preconditions.checkNotNull(module, "LogModule should not be null");
        Preconditions.checkNotNull(level, "LogLevel should not be null");
        if (module == LogModule.PLATFORM) {
            Video.setSDKLogLevel(level);
        }
        Video.trySetCoreModuleLogLevel(module.ordinal(), level.ordinal());
        moduleLogLevel.put(module, level);
    }

    private static void setSDKLogLevel(LogLevel level) {
        switch (level) {
            case OFF: {
                Logger.setLogLevel(7);
                break;
            }
            case FATAL: {
                Logger.setLogLevel(6);
                break;
            }
            case ERROR: {
                Logger.setLogLevel(6);
                break;
            }
            case WARNING: {
                Logger.setLogLevel(5);
                break;
            }
            case INFO: {
                Logger.setLogLevel(4);
                break;
            }
            case DEBUG: {
                Logger.setLogLevel(3);
                break;
            }
            case TRACE: {
                Logger.setLogLevel(2);
                break;
            }
            case ALL: {
                Logger.setLogLevel(2);
                break;
            }
            default: {
                Logger.setLogLevel(7);
            }
        }
    }

    private static void trySetCoreLogLevel(int level) {
        if (libraryIsLoaded) {
            Video.nativeSetCoreLogLevel(level);
        }
    }

    private static int tryGetCoreLogLevel() {
        return libraryIsLoaded ? Video.nativeGetCoreLogLevel() : level.ordinal();
    }

    private static void trySetCoreModuleLogLevel(int module, int level) {
        if (libraryIsLoaded) {
            Video.nativeSetModuleLevel(module, level);
        }
    }

    private static void registerConnectivityBroadcastReceiver() {
        if (applicationContext != null) {
            applicationContext.registerReceiver(connectivityChangeReceiver, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
        }
    }

    private static void unregisterConnectivityBroadcastReceiver() {
        if (applicationContext != null) {
            applicationContext.unregisterReceiver(connectivityChangeReceiver);
        }
    }

    private static native void nativeSetCoreLogLevel(int var0);

    private static native void nativeSetModuleLevel(int var0, int var1);

    private static native int nativeGetCoreLogLevel();

    static enum NetworkChangeEvent {
        CONNECTION_LOST,
        CONNECTION_CHANGED;

    }
}

